//#include <GL/glut.h>
#include <iostream>
#include <vector>
#include <string>
#include <fstream>
#include "EObject.h"
#include "Triangle.h"
#include "Global.h"
#include "Time.h"
#include <algorithm>


EObject::EObject (string fileIn) {
	mat = Material::blue_metal;
	avgDist = 0;
   numEdge = 0;
	/*
	GLPoint p1(1,5,3);
	GLPoint p2(2,4.5,3);
	GLPoint p3(3,5,3);
	GLPoint p4(2,3,2);
   
	addPoint(p1, Vector(0,0,0));
	addPoint(p2, Vector(0,0,0));
	addPoint(p3, Vector(0,0,0));
	addPoint(p4, Vector(0,0,0));

	addFace (2, 1, 0);
	addFace (0, 1, 3);
	addFace (3, 1, 2);
	addFace (0, 3, 2);
	*/
  readFromFile(fileIn);
  //readFromFile("esphere.ASE");
	gravity = Vector(0,-10,0);

	draw_force = true;
	
	buildDone ();
   avgDist = avgDist/numEdge;
 
   mass = vertex.size();
   
}

void EObject::readFromFile (string fname) {
	ifstream in(fname.c_str());
	string line;

	int numVert = 0;
	int numFace = 0;

	if (in){
		while (getline(in, line)) {
			if (line.find("*MESH_NUMVERTEX") != -1) {
				line = line.substr(line.find("*MESH_NUMVERTEX")+16);
				numVert = atoi(line.c_str());
			}
			if (line.find("*MESH_NUMFACES") != -1) {
				line = line.substr(line.find("*MESH_NUMFACES")+15);
				numFace = atoi(line.c_str());
			}
			if (line.find("*MESH_VERTEX_LIST") != -1) {
				break;
			}
		}
   
 	   estart = 0;
     
	   this->esize = numFace * 3 / 2;

	   edges = new Edge[esize];

		while (in >> line) {
			if (line.find("*MESH_VERTEX") != -1) {
				int num;
				float x, y, z;
				in >> num >> x >> y >> z;
				GLPoint p(x,y,z);
				addPoint(p, Vector(0,0,0));	
			}
			if (line.find("*MESH_FACE_LIST") != -1) {
				break;
			}
		}

		while (in >> line) {
			if (line.find("*MESH_FACE") != -1) {
				string dum;
				int p1, p2, p3;
				in >> dum >> dum >> p1 >> dum >> p2 >> dum >> p3;
				getline (in, line);
				addFace (p1, p2, p3);
		}
			if (line.find("}") != -1) {
				break;
			}
		}
	}
}

void EObject::setVelocity (int i, Vector v) {
   if (i == -1) {
      for (int j = 0; j < (int)velocity.size(); j++)
         velocity[j] = v;
   }
   else {
   	if (i < (int)velocity.size())
	   	velocity[i] = v;
   }
}

void EObject::setExAcceleration (int i, Vector v) {
	if (i < (int)force_external.size())
		force_external[i] = v;
}
void EObject::addPoint (GLPoint p, Vector vel) {
	NeighborList *n = new NeighborList;
	vertex.push_back(p);
	oldPos.push_back(p);

	velocity.push_back(vel);
	oldVel.push_back(vel);
	force_external.push_back(Vector(0,0,0));
	force_internal.push_back(Vector(0,0,0));
	acceleration.push_back(Vector(0,0,0));
	
	depend.push_back(n);
	dep1.push_back(Vector(0,0,0));
	dep2.push_back(Vector(0,0,0));
  	dep3.push_back(Vector(0,0,0));
}

void EObject::addEdge( int p1, int p2 )
{
	Edge e;
   
	e.p1 = &vertex[p1];
	e.p2 = &vertex[p2];
   
   if( !EdgeExists(e) )
   {
	   edges[estart] = e;
      
      estart++;

   }
}

bool EObject::EdgeExists(Edge e)
{
   for( int i=0; i < estart; i++ )
      if( edges[i] == e ) return true;
   return false;
}


void EObject::addFace (int p1, int p2, int p3) {
	Triangle *t = new Triangle;
	t->point [0] = &vertex[p1];
	t->point [1] = &vertex[p2];
	t->point [2] = &vertex[p3];
   t->normal = t->Normal();

   addEdge(p1, p2);
   addEdge(p2, p3);
   addEdge(p3, p1);
	face.push_back(t);

	depend[p1]->add(&vertex[p2], &vertex[p1], p2);
	depend[p1]->add(&vertex[p3], &vertex[p1], p3);
	Vector v1 = vertex[p2] - vertex[p1];
	Vector v2 = vertex[p3] - vertex[p1];
	avgDist += ~v1;
   avgDist += ~v2;
   numEdge += 2;
	depend[p2]->add(&vertex[p1], &vertex[p2], p1);
	depend[p2]->add(&vertex[p3], &vertex[p2], p3);
	v1 = vertex[p1] - vertex[p2];
	v2 = vertex[p3] - vertex[p2];
	avgDist += ~v1;
   avgDist += ~v2;
   numEdge += 2;

	depend[p3]->add(&vertex[p1], &vertex[p3], p1);
	depend[p3]->add(&vertex[p2], &vertex[p3], p2);
	v1 = vertex[p1] - vertex[p3];
	v2 = vertex[p2] - vertex[p3];
	avgDist += ~v1;
   avgDist += ~v2;
   numEdge += 2;

}

void EObject::buildDone () {
	float x=0,y=0,z=0;

   for (int i = 0; i < (int)vertex.size(); i++) {
		x += vertex[i].x;
		y += vertex[i].y;
		z += vertex[i].z;
	}

	x = x / (float) vertex.size();
	y = y / (float) vertex.size();
	z = z / (float) vertex.size();

	center.x = x;
	center.y = y;
	center.z = z;
	
   cdRadius = 0;
   for (int i = 0; i < (int)vertex.size(); i++) {
		distToCenter.push_back (center.Distance(vertex[i]));
      if (cdRadius < center.Distance(vertex[i]))
         cdRadius = center.Distance(vertex[i]);
	}

}

float EObject::edge (GLPoint p1, GLPoint p2) {

	return p1.Distance(p2);
}

void EObject::Draw()
{
	this->draw();
}

void EObject::draw() {
  	glPushMatrix();
	glMaterialfv( GL_FRONT, GL_DIFFUSE,   mat.diff );
	glMaterialfv( GL_FRONT, GL_SPECULAR,  mat.spec );
	glMaterialfv( GL_FRONT, GL_AMBIENT,   mat.amb );
	glMaterialfv( GL_FRONT, GL_SHININESS, &mat.shin );
   
	for (int i = 0; i < (int)face.size(); i++) {

      Vector oN =   face[i]->Normal();
		glBegin( GL_TRIANGLES); 
			glNormal3f( oN.x, 
				         oN.y, 
			            oN.z );
			glVertex3f( face[i]->point[0]->x,
                        face[i]->point[0]->y,
                        face[i]->point[0]->z );

         glVertex3f( face[i]->point[1]->x,
                        face[i]->point[1]->y,
                        face[i]->point[1]->z );

			glVertex3f( face[i]->point[2]->x,
                        face[i]->point[2]->y,
                        face[i]->point[2]->z );
			glEnd();
	
	}

	glPushMatrix();	

   // --- Doing point ----	
/*	glPointSize(10);
   glPushMatrix();	
	   material mat1 = Material::red_metal;
	   glMaterialfv( GL_FRONT, GL_DIFFUSE,   mat1.diff );
	   glMaterialfv( GL_FRONT, GL_SPECULAR,  mat1.spec );
   	glMaterialfv( GL_FRONT, GL_AMBIENT,   mat1.amb );
   	glMaterialfv( GL_FRONT, GL_SHININESS, &mat1.shin );
	
      glBegin( GL_POINTS  ); 
	      glVertex3f(vertex[3].x, vertex[3].y, vertex[3].z);
      glEnd();
	glPushMatrix();	
  */ //---------------------
	
	if (!draw_force) {
		int n = 0;

	glPushMatrix();	
			material mat1 = Material::red_metal;
			glMaterialfv( GL_FRONT, GL_DIFFUSE,   mat1.diff );
			glMaterialfv( GL_FRONT, GL_SPECULAR,  mat1.spec );
			glMaterialfv( GL_FRONT, GL_AMBIENT,   mat1.amb );
			glMaterialfv( GL_FRONT, GL_SHININESS, &mat1.shin );
		
	
			glLineWidth( 2 );
			for (n = 0; n < (int)vertex.size(); n++) {
				glBegin( GL_LINES ); 
					//glNormal3f( 0, 0, -1 );
	
					glVertex3f( vertex[n].x,
						 vertex[n].y,
						 vertex[n].z );

					glVertex3f( (vertex[n].x + acceleration[n].x),
				         (vertex[n].y + acceleration[n].y),
					     (vertex[n].z + acceleration[n].z));
				 glEnd();
			}
		glPopMatrix();
		
		glPushMatrix();
			material mat2 = Material::yellow_metal;
			glMaterialfv( GL_FRONT, GL_DIFFUSE,   mat2.diff );
			glMaterialfv( GL_FRONT, GL_SPECULAR,  mat2.spec );
			glMaterialfv( GL_FRONT, GL_AMBIENT,   mat2.amb );
			glMaterialfv( GL_FRONT, GL_SHININESS, &mat2.shin );
		

			glLineWidth( 2 );	
		
			for (n = 0; n < (int)vertex.size(); n++) {
				glBegin( GL_LINES ); 
				//glNormal3f( 0, 0, -1 );

				glVertex3f( vertex[n].x,
					 vertex[n].y,
					 vertex[n].z );

				glVertex3f( (vertex[n].x + dep1[n].x),
                     (vertex[n].y + dep1[n].y),
                     (vertex[n].z + dep1[n].z));
				 glEnd();
				 glBegin( GL_LINES ); 
					//glNormal3f( 0, 0, -1 );
	
					glVertex3f( vertex[n].x,
						 vertex[n].y,
						 vertex[n].z );
	
					glVertex3f( (vertex[n].x + dep2[n].x),
                     (vertex[n].y + dep2[n].y),
                     (vertex[n].z + dep2[n].z));
             glEnd();
				
			}
	
		glPopMatrix();
	}
}

void EObject::Update()
{
	this->update();
}

void EObject::update() {

	int i;

	float DELTA_TIME = (float)1/100;//(float)Time::GetTimeElapsedMS()/1000;

	Vector centerVel;
	Vector centerAcc;

	for (i = 0; i < (int)vertex.size(); i++) {

		centerVel = centerVel + velocity[i];
		centerAcc = centerAcc + acceleration[i];
		
		oldVel[i] = velocity[i];
		oldPos[i] = vertex[i];
   
		vertex[i].x = oldPos[i].x + velocity[i].x * DELTA_TIME + 
			acceleration[i].x * DELTA_TIME * DELTA_TIME / 2;
		
		vertex[i].y = oldPos[i].y + velocity[i].y * DELTA_TIME + 
			acceleration[i].y * DELTA_TIME * DELTA_TIME / 2;
	
      vertex[i].z = oldPos[i].z + velocity[i].z * DELTA_TIME + 
			acceleration[i].z * DELTA_TIME * DELTA_TIME / 2;
	
		velocity[i].x = oldVel[i].x + acceleration[i].x * DELTA_TIME;
		velocity[i].y = oldVel[i].y + acceleration[i].y * DELTA_TIME;
		velocity[i].z = oldVel[i].z + acceleration[i].z * DELTA_TIME;
	}

	centerVel = centerVel/vertex.size();
	centerAcc = centerAcc/vertex.size();	
	center.x = center.x + centerVel.x * DELTA_TIME + 
			centerAcc.x * DELTA_TIME * DELTA_TIME / 2;
	center.y = center.y + centerVel.y * DELTA_TIME + 
			centerAcc.y * DELTA_TIME * DELTA_TIME / 2;
	center.z = center.z + centerVel.z * DELTA_TIME + 
			centerAcc.z * DELTA_TIME * DELTA_TIME / 2;

	for (i = 0; i < (int)vertex.size(); i++) {
		Vector totalF(0,0,0);
		for (int j = 0; j < (int)depend[i]->points.size(); j++) {
			float delta = depend[i]->deltaDist(vertex[i],j);
         float ratio = depend[i]->ratioDist(vertex[i],j);

         Vector deltaVel = velocity[i] - velocity[depend[i]->index[j]];
			Vector deltaPos = vertex[i] - vertex[depend[i]->index[j]];

			if ( !(0.0001 > delta && delta > -0.0001)) {
				Vector direct(((depend[i] -> points[j] -> x ) - vertex[i].x),
					  			  ((depend[i] -> points[j] -> y ) - vertex[i].y),
								  ((depend[i] -> points[j] -> z ) - vertex[i].z));
			
				direct = direct.Normalize();
				
				float c =1*((deltaPos*deltaPos) / ((~deltaPos)*(~deltaPos))) ;

				direct.x = 1 * k * delta * direct.x - c * deltaVel.x;		
				direct.y = 1 * k * delta * direct.y - c * deltaVel.y;
				direct.z = 1 * k * delta * direct.z - c * deltaVel.z;

            totalF = totalF + direct;
			}

		}

		float delta = center.Distance(vertex[i]) - distToCenter[i];
		Vector deltaVel = velocity[i] - centerVel; // - velocity[depend[i]->index[j]];
		Vector deltaPos = vertex[i] - center;
     /*
		if (!(0.0001 > delta && delta > -0.0001)) {
			Vector direct(  ((center.x ) - vertex[i].x),
							((center.y ) - vertex[i].y),
							((center.z ) - vertex[i].z));
			
			deltaPos = deltaPos.Normalize();
		   direct = deltaPos;
			float c = ((deltaPos*deltaPos) / ((~deltaPos)*(~deltaPos))) ;

			direct.x = 1 * k * delta * direct.x - c * deltaVel.x;		
			direct.y = 1 * k * delta * direct.y - c * deltaVel.y;
			direct.z = 1 * k * delta * direct.z - c * deltaVel.z;
			
			dep1[i] = direct;

			totalF = totalF + direct;
		}
      */
		force_internal[i].x = totalF.x;
		force_internal[i].y = totalF.y;
		force_internal[i].z = totalF.z;
      
		acceleration[i] = ((force_internal[i] + force_external[i] ) / ((float)(mass / (float)vertex.size())))
			+ gravity;

      if (vertex[i].y <= 0 && velocity[i].y < 0) {
	   	velocity[i].y = - velocity[i].y/2;
        velocity[i].x = velocity[i].x/2;
        velocity[i].z = velocity[i].z/2;       

		vertex[i].y = 0;
		/*
		for (int sp = 0; sp < vertex.size(); sp++) {
			if (sp != i){
				velocity[sp].y = - velocity[sp].y/1.5;
				velocity[sp].x = velocity[sp].x/1.5;
				velocity[sp].z = velocity[sp].z/1.5; 
			}
		}
		*/
	 }
   }

   float x=0,y=0,z=0;

   for (int i = 0; i < (int)vertex.size(); i++) {
		x += vertex[i].x;
		y += vertex[i].y;
		z += vertex[i].z;
	}

	x = x / (float) vertex.size();
	y = y / (float) vertex.size();
	z = z / (float) vertex.size();

	center.x = x;
	center.y = y;
	center.z = z;

   cdRadius = 0;
   for (int i = 0; i < (int)vertex.size(); i++) {
		distToCenter.push_back (center.Distance(vertex[i]));
      if (cdRadius < center.Distance(vertex[i]))
         cdRadius = center.Distance(vertex[i]);
	}

}

GLPoint EObject::getPosition() const { return this->center; }
float   EObject::getCDRadius() const { return this->cdRadius; }
float   EObject::getFixed () const {return false;} 

void EObject::setPosition( GLPoint &p )
{
   float xDiff = center.x - p.x;
   float yDiff = center.y - p.y; 
   float zDiff = center.z - p.z;

	this->center = p;

   for (unsigned int i = 0; i < vertex.size(); i++) {
      vertex[i].x -= xDiff;
      vertex[i].y -= yDiff;
      vertex[i].z -= zDiff;
   }

}

EObject::~EObject () {
	for (int i = 0; i < (int)face.size(); i++) {
		delete face[i];
	}
}

bool EObject::CollisionDetected( EObject &o, vector<CollisionEdge> &collisionEdges, 
                                 vector<GLPoint> &collisionPoints ) const
{
   vector<CollisionEdge>::iterator result;

	Vector N, e1, e2, directionVector;
	GLPoint pointToCheck;
	int i, j;
	float e1_p, e2_p, distance, T, angle;
	Vector normal;

	Vector edgeVector1, edgeVector2;
	CollisionEdge* cEdge;


	for( i=0; i < esize; i++ )
	{
		if( !edges[i].outerEdge )
      {
         cout << "Skip!" << endl;
         continue;  // NEW
      }
      
		e1 = ((*edges[i].p1) - GLPoint(0,0,0));
		e2 = ((*edges[i].p2) - GLPoint(0,0,0));
		directionVector = (*edges[i].p2) - (*edges[i].p1);
		directionVector.Normalize();

		for( j=0; j < (int)o.face.size(); j++ )
		{
         N = o.face[j]->normal;
			distance =  N * ((*o.face[j]->point[0])- GLPoint(0,0,0));
			distance = 0 - distance;
			e1_p = N * e1 + distance;
			e2_p = N * e2 + distance;
			
			// Check if we have Edge To Plane Collision
			if( (e1_p < 0.0f && e2_p > 0.0f) || (e1_p > 0.0f && e2_p < 0.0f) )
			{
				T = - ( (N * e1) + distance ) / ( N * directionVector );

				pointToCheck.x = (edges[i].p1->x) + directionVector.x * T;
				pointToCheck.y = (edges[i].p1->y) + directionVector.y * T;
				pointToCheck.z = (edges[i].p1->z) + directionVector.z * T;

            // If the edge is against the edge of the plane then force a collision
            // detection on it.
				if( pointToCheck == *o.face[j]->point[0] ||
					pointToCheck == *o.face[j]->point[1]  ||
               pointToCheck == *o.face[j]->point[2] )
               angle = 360.0f;
            else
            {
				   angle = 0;
               
				   for (int l=2, k = 0; k < 3; l=k++)
				   {
					   int new_angle = ((*(o.face[j]->point[k])) - pointToCheck).Angle(
						   ((*o.face[j]->point[l]) - pointToCheck));
   					
					   angle+=new_angle;
				   }
            }
            
				// Now check if we have Point to Polygon Collision 
				if (angle >= 355.0f)
				{
					cEdge = new CollisionEdge();
               
               // Find out which endpoint was inside the other object.
               // Incase of the possibility that the edge goes completely
               // through to the outside of the object, then we will mark
               // this edge as a "non interior" edge and completey ignore it
               // when running DFS.
					cEdge->point[0] = &(*edges[i].p1);
					cEdge->point[1] = &(*edges[i].p2);
               
               
					edgeVector1 = Vector(edges[i].p1->x - edges[i].p2->x,
						edges[i].p1->y - edges[i].p2->y,
						edges[i].p1->z - edges[i].p2->z);
               
					edgeVector2 = Vector(edges[i].p2->x - edges[i].p1->x,
						edges[i].p2->y - edges[i].p1->y,
						edges[i].p2->z - edges[i].p1->z);
               
					cEdge->collisionIdx = N.Angle(edgeVector1) > 90 ? 0 : 1;
					
               // If we have already added this edge into the set of collision
               // edges then it means the edge has left the object or has re-entered
               // the object.  In this case, then reverse the interior status of the
               // object so we know if the edge fully penetrates the object or not.
               if( (result = find(collisionEdges.begin(), collisionEdges.end(), *cEdge)) != collisionEdges.end() )
                  (*result).interior = !(*result).interior;
               else
               {
                  // Remember this edge as part of the collision
                  cEdge->interior = true;
   					collisionEdges.push_back(*cEdge);
               }

               // Add the points of the triangle into the collision point set
               for( int i=0; i < 3; i++ )
               {
                  if( find(collisionPoints.begin(), collisionPoints.end(), 
                     *o.face[j]->point[i]) == collisionPoints.end() )
                     collisionPoints.push_back(*o.face[j]->point[i]);
               }
				}
			}
		}
	}
	
	return collisionEdges.size() != 0;
}


void EObject::DFS(vector<CollisionEdge> &collisionEdges, vector<GLPoint> &collisionPoints)
{
   vector<CollisionEdge>::iterator result;
   int i=0;

   // Mark all edges as unprocessed.
   for( i=0; i < esize; i++ )
   {
      edges[i].state = Edge::states::None;

      if( find(collisionEdges.begin(), collisionEdges.end(), edges[i]) != collisionEdges.end() )
         edges[i].state = Edge::states::Done;
   }
   
   for( i=0; i < (int)collisionEdges.size(); i++ )
   {
      if( collisionEdges[i].interior )
      {
         collisionPoints.push_back(*collisionEdges[i].point[ (collisionEdges[i].collisionIdx + 1) % 2 ]);
         DFSRec( *collisionEdges[i].point[ collisionEdges[i].collisionIdx ], collisionPoints );
      }
   }
}

void EObject::DFSRec( GLPoint &p, vector<GLPoint> &collisionPoints )
{
   for( int i=0; i < esize; i++ )
   {
      if( (*edges[i].p1 == p || *edges[i].p2 == p) && edges[i].state == Edge::states::None)
      {
         edges[i].state = Edge::states::Processing;
         
         if( *edges[i].p1 == p )
         {
            DFSRec( *edges[i].p2, collisionPoints );
            collisionPoints.push_back(*edges[i].p2);
         }
         else
         {
            DFSRec( *edges[i].p1, collisionPoints );
            collisionPoints.push_back(*edges[i].p1);
         }
         
         edges[i].state = Edge::states::Done;
      }
   }
}


bool Edge::operator ==(const Edge &e)
{
   return ((e.p1->x == p1->x) && (e.p1->y == p1->y) && (e.p1->z == p1->z) &&
          (e.p2->x == p2->x) && (e.p2->y == p2->y) && (e.p2->z == p2->z)) ||
          ((e.p1->x == p2->x) && (e.p1->y == p2->y) && (e.p1->z == p2->z) &&
          (e.p2->x == p1->x) && (e.p2->y == p1->y) && (e.p2->z == p1->z));
}

bool Edge::operator ==(const CollisionEdge &e)
{
   return (e.point[0]->x == p1->x) && (e.point[0]->y == p1->y) && (e.point[0]->z == p1->z) &&
          (e.point[1]->x == p2->x) && (e.point[1]->y == p2->y) && (e.point[1]->z == p2->z);
}

// NEW
bool CollisionEdge::operator==( const CollisionEdge &e )
{
   return (e.point[0]->x == point[0]->x) && (e.point[0]->y == point[0]->y) && (e.point[0]->z == point[0]->z) &&
          (e.point[1]->x == point[1]->x) && (e.point[1]->y == point[1]->y) && (e.point[1]->z == point[1]->z);
}

// NEW
bool CollisionEdge::operator==( const Edge &e )
{
   return (e.p1->x == point[0]->x) && (e.p1->y == point[0]->y) && (e.p1->z == point[0]->z) &&
          (e.p2->x == point[1]->x) && (e.p2->y == point[1]->y) && (e.p2->z == point[1]->z);
}
