#ifndef GLWINDOW_H
#define GLWINDOW_H

#include <vector>
#include <string>

#include "Global.h"
#include "World.h"

class GLObject;

using namespace std;

class GLWindow
{
public:
   GLWindow( World *world, string caption = string("< none >") );

   // Start the GL Main Loop
   void start(int argc, char **argv );

   // Close the screen
   void close();
   void setDimension( int width, int height );
   void setPosition( int left, int top );
   void setInstance();

private:
   static void show();
   static void idleShow();
   static void resize( int width, int height );
   static GLWindow *window;

   int top, left, height, width;
   int windowHandle;

   World *world;

   string caption;
};

#endif

