#include "Math.h"
#include <iostream>
#include "Vector.h"
#include "GLPoint.h"
#include "Triangle.h"
using namespace std;

Vector Vector::ZeroVector( 0,0,0 );

Vector::Vector()
{ 
	this->x = 0; 
	this->y = 0; 
	this->z = 0; 
}

Vector::Vector( float x, float y, float z )
{ 
	this->x = x; 
	this->y = y; 
	this->z = z; 
}


Vector Vector::operator+( const Vector &v )
{
   Vector v1;
   
   v1.x = this->x + v.x;
   v1.y = this->y + v.y;
   v1.z = this->z + v.z;
   
   return v1;
}

Vector Vector::operator-( const Vector &v )
{
   Vector v1;
   
   v1.x = this->x - v.x;
   v1.y = this->y - v.y;
   v1.z = this->z - v.z;
   
   return v1;
}

Vector& Vector::operator+=( const Vector &v )
{
   this->x += v.x;
   this->y += v.y;
   this->z += v.z;

   return *this;
}


float Vector::operator*( const Vector &v )
{
   return (v.x * this->x + v.y * this->y + v.z * this->z);
}


Vector Vector::CrossProduct( const Vector &v )
{
   Vector cp;

   cp.x = this->y * v.z - this->z * v.y;
   cp.y = this->z * v.x - this->x * v.z;
   cp.z = this->x * v.y - this->y * v.x;

   return cp;
}


float Vector::operator ~() const
{
   return (float)sqrt( this->x * this->x + this->y * this->y + this->z * this->z );
}


float Vector::Angle( const Vector &v )
{
   //
   // Angle of two Vectors
   //
   // arc_cosine( dotProduct( this, v ) / (SizeOf( this ) * SizeOf( v )) )

//   if (((~(*this)) * (~v)) == 0)
  //    return 90;
   float t = ((*this) * v) / ((~(*this)) * (~v));
    
   float z = (float)(acos( t )*(180 / 3.1415926535897932384626433));

   return z;
}

Vector Vector::Normalize()
{
   this->x /= ~(*this);
   this->y /= ~(*this);
   this->z /= ~(*this);

   return *this;
}



bool Vector::operator== (const Vector &v) 
{
   return (v.x==x && v.y==y && v.z==z);
}

Vector Vector::operator/(float d ) const{
	Vector v = *this;

	v.x = v.x / d;
	v.y = v.y / d;
	v.z = v.z / d;

	return v;
}

Vector Vector::operator*(float d ) const{
	Vector v = *this;

	v.x = v.x * d;
	v.y = v.y * d;
	v.z = v.z * d;

	return v;
}

bool Vector::operator!=(const Vector &v) 
{
   return !(*this == v);
}
