function E = DDF_c(z, r, flip, a, A, k, K)

    d = bsxfun(@minus, z, z(1+r, 1+r, :));                 % (3.1)
    k = k(sum(real(d).^2, 3));                             % (3.9)
    e = a * sum(sum(bsxfun(@times, d, k))) / sum(k(:));    % (3.3)

    D = fft2(circshift(bsxfun(@times, ...                  % (3.4)
        bsxfun(@minus, d, e), k), -[r r]));
    K = K(abs((D + conj(D(flip)))/2).^2 / sum(k(:).^2));   % (3.10)
    E = A * sum(sum(D .* K)) / numel(k);                   % (3.6)
end
