function x = DDID2_c(y, sigma2)

    N       = 8;
    sigma_s = 13;
    gamma_r = 5.3 / N;
    gamma_f = 13 / N;
    alpha   = exp(15);

    [height width depth] = size(y);
    s = [height * width, depth];
    M = dctmtx(depth)';
    y = reshape(reshape(y, s) * M, size(y));

    x = (1 + 1i) * y;                                      % (3.8)
    for n = N:-1:1, t = (n - 1) / N;

        S =    2    * sigma_s^2 * alpha^(-t/2);            % (4.6)
        T = gamma_r * sigma2    * alpha^t;                 % (4.7)
        V = gamma_f * sigma2;                              % (4.8)

        r       = max(4, round(2 * sqrt(S/2)));            % (4.12)
        [dy dx] = ndgrid(-r:r);
        flip    = circshift(flipdim(reshape(numel(dx)*depth:-1:1, ...
                  [size(dx) depth]), 3), [1 1]);

        a = cos(t * pi/2);                                 % (4.11)
        h = exp(- (dx.^2 + dy.^2) / S);
        k = @(d2) cos(min(pi/2, sqrt(d2/(T*n)))).^n .* h;  % (4.9)
        K = @(D2) cos(min(pi/2, sqrt(D2/(V*n)))).^n;       % (4.10)

        f = @(b) ddf_c(b.data, r, flip, a, a, k, K);
        x = (1 + 1i) * y - imag(blockproc(x, [1 1], f, 'BorderSize', [r r], ...
          'PadMethod', 'symmetric', 'TrimBorder', 0, 'UseParallel', 1));    % (4.5)
    end
    x = real(x);

    x = reshape(reshape(x, s) / M, size(x));
end

