function x = deart(g, y, sigma2, r, sigma_s, gamma_r, gamma_f)

    [dy dx] = ndgrid(-r:r);
    flip    = circshift(reshape(numel(h):-1:1, size(h)), [1 1]);

    h = exp(- (dx.^2 + dy.^2) / (2 * sigma_s^2));
    k = @(d2) h .* exp(- d2 / (gamma_r * sigma2));         % (4.3)
    K = @(d2) max(0, 1 - d2 / (gamma_f * sigma2));         % (4.4)

    z = padarray(g + 1i * y, [r r], 'symmetric');          
    f = @(b) DDF(b.data, r, flip, 1, 1, k, K);             % (4.2)
    n = nlfilter(z, size(h), f);
    x = imag(z - n(1+r:end-r, 1+r:end-r));                 % (4.1)
end
