function x = deart_c(g, y, sigma2, r, sigma_s, gamma_r, gamma_f)

    [height width depth] = size(y);
    s = [height * width, depth];
    M = dctmtx(depth)';
    g = reshape(reshape(g, s) * M, size(y));
    y = reshape(reshape(y, s) * M, size(y));

    [dy dx] = ndgrid(-r:r);
    flip    = circshift(flipdim(reshape(numel(dx)*depth:-1:1, ...
              [size(dx) depth]), 3), [1 1]);

    h = exp(- (dx.^2 + dy.^2) / (2 * sigma_s^2));
    k = @(d2) h .* exp(- d2 / (gamma_r * sigma2));         % (4.3)
    K = @(d2) max(0, 1 - d2 / (gamma_f * sigma2));         % (4.4)

    f = @(b) DDF_c(b.data, r, flip, 1, 1, k, K);           % (4.2)
    x = y - imag(blockproc(g + 1i * y, [1 1], f, ...       % (4.1)
      'BorderSize', [r r], 'PadMethod',   'symmetric', ...
      'TrimBorder', 0,     'UseParallel', 1));

    x = reshape(reshape(x, s) / M, size(x));
end

