import java.util.Scanner;

public class AlignedGaps {

	private static boolean areGapsAligned(double coordinates_x[], double coordinates_y[], double coordinates_z[]) {
		/* ------------------- INSERT CODE HERE ---------------------*/

		/*
		 * coordinates_x[i], coordinates_y[i], coordinates_z[i] denote the x-y-z coordinates of the i'th gap in the asteroid field.
		 *
		 * Your code should return true if all the gaps are aligned, i.e., they all lie on a single line.
		 *
		 */
		double diff_x = coordinates_x[1] - coordinates_x[0];
		double diff_y = coordinates_y[1] - coordinates_y[0];
		double diff_z = coordinates_z[1] - coordinates_z[0];

		for(int i = 2; i < coordinates_x.length; i++) {
			double d_x = coordinates_x[i] - coordinates_x[0];
			double d_y = coordinates_y[i] - coordinates_y[0];
			double d_z = coordinates_z[i] - coordinates_z[0];

			double ratio = 0;
			if( (Math.abs(diff_x) > Math.abs(diff_y)) && (Math.abs(diff_x) > Math.abs(diff_z)) ) {
				ratio = d_x/diff_x;
			} else {
				if( (Math.abs(diff_y) > Math.abs(diff_x)) && (Math.abs(diff_y) > Math.abs(diff_z)) )
					ratio = d_y/diff_y;
				else
					ratio = d_z/diff_z;
			}
			// System.out.println(d_x + " " + ratio + " " + diff_x);
			// System.out.println(d_y + " " + ratio + " " + diff_y);
			// System.out.println(d_z + " " + ratio + " " + diff_z);
			// System.out.println(Math.abs(d_x - ratio * diff_x));

			if( (Math.abs(d_x - ratio * diff_x) > 0.0001) || (Math.abs(d_y - ratio * diff_y) > 0.0001) || (Math.abs(d_z - ratio * diff_z) > 0.0001) )
				return false;
		}
		/* -------------------- END OF INSERTION --------------------*/

		return true;
	}

	public static void main(String[] args) {
		Scanner sc = new Scanner(System.in);

		int numCases = sc.nextInt();

		for(int n = 0; n < numCases; n++)
		{
			int num = sc.nextInt();
			double[] coordinates_x = new double[num];
			double[] coordinates_y = new double[num];
			double[] coordinates_z = new double[num];
			for(int i = 0; i < num; i++) {
				coordinates_x[i] = sc.nextDouble();
				coordinates_y[i] = sc.nextDouble();
				coordinates_z[i] = sc.nextDouble();
			}

			if(areGapsAligned(coordinates_x, coordinates_y, coordinates_z)) {
				System.out.println("Gaps are aligned.");
			} else {
				System.out.println("Gaps are NOT aligned.");
			}
		}

		sc.close();
	}
}
