import java.util.Scanner;
import java.util.Arrays;

public class ForcedCards {

	private static int[] bestPlay(int[] deck) {
		/* 
		 * Insert your code in here
		 *
		 * Your code should construct and return an array of length 3, where the 
		 * first number indicates the best starting point, the second number indicates
		 * the best end point, and the third number is the total value.
		 *
		 */

		int maxIfEndsHere=0;
		int startingPointIfEndsHere=0;

		int maxSoFar=0;
		int startingPointSoFar=-1;
		int endingPointSoFar=-1;

		for (int i=0; i<deck.length; i++) {
			if (maxIfEndsHere + deck[i] > 0) {
				maxIfEndsHere += deck[i];
			}
			else {
				maxIfEndsHere = 0; 
				startingPointIfEndsHere = i+1;
			}

			if (maxIfEndsHere > maxSoFar) {
				startingPointSoFar = startingPointIfEndsHere;
				endingPointSoFar = i;
				maxSoFar = maxIfEndsHere;
			}
		}

		int[] answer = new int[3];
		answer[0]=startingPointSoFar;
		answer[1]=endingPointSoFar;
		answer[2]=maxSoFar;
		return answer;

		/* End */
	}


	public static void main(String[] args) {
		Scanner sc = new Scanner(System.in);

		int numOfTestCases = sc.nextInt();

		for (int testCase=0; testCase < numOfTestCases; testCase++) { 
			int numOfCards = sc.nextInt();
			int[] cards = new int[numOfCards];
			for (int i=0; i<numOfCards; i++) {
				cards[i] = sc.nextInt();
			}

			int[] results = bestPlay(cards);        
			System.out.println(
					"Start/Stop/Value: " + 
					results[0]+"/"+results[1]+"/"+results[2]
					);
		}

		sc.close();
	}
}

