import java.util.Scanner;
import java.util.ArrayList;

class Position {
	int x;
	int y;
	Position(int x, int y) {
		this.x = x;
		this.y = y;
	}
}

public class LegalMovesInGo {

	private static final int NOT_EMPTY = 0;
	private static final int LEGAL_ADJACENT_LIBERTY = 1;
	private static final int LEGAL_THROUGH_CAPTURE = 2;
	private static final int ILLEGAL = 3;

	private static ArrayList<Position> getNeighbors(String[] board, int pos_x, int pos_y) {
		ArrayList<Position> ret = new ArrayList<Position>();
		if(pos_x != 0) ret.add(new Position(pos_x-1, pos_y));
		if(pos_y != 0) ret.add(new Position(pos_x, pos_y-1));
		if(pos_x != board.length-1) ret.add(new Position(pos_x+1, pos_y));
		if(pos_y != board.length-1) ret.add(new Position(pos_x, pos_y+1));
		return ret;
	}

	private static boolean anyAdjacentEmptyIntersections(String[] board, int pos_x, int pos_y) {
		ArrayList<Position> neighbors = getNeighbors(board, pos_x, pos_y);
		for(Position p: neighbors) {
			if(board[p.y].charAt(p.x) == '.') 
				return true;
		}
		return false;
	}

	private static boolean recursivelyCheckForLiberties(String[] board, int pos_x, int pos_y, boolean[][] already_checked) {
		already_checked[pos_x][pos_y] = true;
		// System.out.println("Checking if " + pos_x + " " + pos_y + " has any liberties");
		if(anyAdjacentEmptyIntersections(board, pos_x, pos_y)) {
			return true;
		} else {
			// recurse on adjacent neighbors with the same color
			ArrayList<Position> neighbors = getNeighbors(board, pos_x, pos_y);
			for(Position p: neighbors) {
				if( !already_checked[p.x][p.y] && (board[p.y].charAt(p.x) == board[pos_y].charAt(pos_x)) ) {
					if(recursivelyCheckForLiberties(board, p.x, p.y, already_checked))
						return true;
					else 
						already_checked[p.x][p.y] = true;
				}
			}
			return false;
		}
	}

	// We will call this if any of the reachable stones of the other color are capturable after making this move
	// This will only be done if there is no reachable liberty
	private static boolean recursivelyCheckForNoLibertiesForOtherColorStones(String[] board, int pos_x, int pos_y, boolean[][] already_checked) {
		already_checked[pos_x][pos_y] = true;

		// recurse on adjacent neighbors with the same color
		ArrayList<Position> neighbors = getNeighbors(board, pos_x, pos_y);
		for(Position p: neighbors) {
			if(!already_checked[p.x][p.y]) {
				if(board[p.y].charAt(p.x) == board[pos_y].charAt(pos_x)) {
					// This is a stone of the same color
					if(recursivelyCheckForNoLibertiesForOtherColorStones(board, p.x, p.y, already_checked))
						return true;
				} else {
					// This is a stone of a different color
					// Check if it has any liberties
					if(!recursivelyCheckForLiberties(board, p.x, p.y, already_checked))
						return true;
				}
			}
		}
		return false;
	}

	private static int checkLegality(String[] board, char c, int pos_x, int pos_y) {

		/* ------------------- INSERT CODE HERE ---------------------
		 *
		 * board[] gives us the current state of the board. 
		 *
		 * pos_x = 0, pos_y = 0, refers to the top-left intersection of the board. 
		 * pos_x = 1, pos_y = 0, refers to the next intersection to the right (i.e., x increases horizontally).
		 *
		 * We have to decide if the proposed move is legal or not.
		 *
		 * */

		if(board[pos_y].charAt(pos_x) != '.') 
			return NOT_EMPTY;

		// Let's update the board, and then ask if there is any reachable liberty.
		String n = board[pos_y].substring(0,pos_x)+c+board[pos_y].substring(pos_x+1);
		board[pos_y] = n;

		boolean already_checked[][] = new boolean[board.length][board.length];
		for(int i = 0; i < board.length; i++)
			for(int j = 0; j < board.length; j++)
				already_checked[i][j] = false;

		if(recursivelyCheckForLiberties(board, pos_x, pos_y, already_checked))
			return LEGAL_ADJACENT_LIBERTY;

		// okay, so no adjacent liberty -- let's check if any of the nearby stones of the other color have any liberties left
		for(int i = 0; i < board.length; i++)
			for(int j = 0; j < board.length; j++)
				already_checked[i][j] = false;
		if(recursivelyCheckForNoLibertiesForOtherColorStones(board, pos_x, pos_y, already_checked))
			return LEGAL_THROUGH_CAPTURE;

		/* -------------------- END OF INSERTION --------------------*/
		return ILLEGAL;
	}

	public static void main(String[] args) {
		Scanner sc = new Scanner(System.in);

		int numCases = sc.nextInt();

		for(int i = 0; i < numCases; i++)
		{
			int boardSize = sc.nextInt();
			char c = sc.next().charAt(0);
			int pos_x = sc.nextInt();
			int pos_y = sc.nextInt();

			// Read the current state of the as an array of String -- all the Strings will have the same length = boardSize
			String[] board = new String[boardSize];

			for(int j = 0; j < boardSize; j++)
				board[j] = sc.next();


			int ret = checkLegality(board, c, pos_x, pos_y);
			System.out.print("Move " + c + " in position (" + pos_x + ", " + pos_y + ") is ");
			switch(ret) {
				case NOT_EMPTY:
					System.out.println("illegal - the position is not empty.");
					break;
				case LEGAL_THROUGH_CAPTURE:
					System.out.println("legal through capture of opponent's stones.");
					break;
				case LEGAL_ADJACENT_LIBERTY:
					System.out.println("legal - there is an adjacent (shared) liberty.");
					break;
				default:
					System.out.println("illegal.");
					break;
			}
		}

		sc.close();
	}
}
