import java.util.Scanner;
import java.util.Arrays;
import java.util.ArrayList;

public class ScavengerOne {

	public static ArrayList<Integer> sumToTarget(int startPoint, int[] values, int target) {

		ArrayList<Integer> result = new ArrayList<Integer>();

		if (startPoint==values.length-1) {
			if (values[startPoint]==target) {
				result.add(target);
			}
		}
		else {
			ArrayList<Integer> withFirst = new ArrayList<Integer>();
			withFirst.addAll(sumToTarget(startPoint+1, values, target-values[startPoint]));
			if (!withFirst.isEmpty()) {
				withFirst.add(0,values[startPoint]);
				result = withFirst;
			}
			else { 
				ArrayList<Integer> withoutFirst = new ArrayList<Integer>();
				withoutFirst.addAll(sumToTarget(startPoint+1, values, target));
				if (!withoutFirst.isEmpty()) {
					result = withoutFirst;
				}
			}
		}

		return result;
	}

	private static int[] bestItems(int capacity, int[] available) {
		// YOUR CODE IN HERE

		ArrayList<Integer> ans = sumToTarget(0, available, capacity);
		int[] retVal = new int[ans.size()];
		for (int i=0; i<ans.size(); i++) {
			retVal[i] = ans.get(i);
		}
		return retVal;

		// YOUR CODE IN HERE
	}

	public static void main(String[] args) {
		Scanner sc = new Scanner(System.in);

		int numOfTestCases = sc.nextInt();

		for (int testCase=0; testCase < numOfTestCases; testCase++) { 
			int capacity = sc.nextInt();

			int numItems = sc.nextInt();
			int[] items = new int[numItems];

			for (int i=0; i<numItems; i++) {
				items[i] = sc.nextInt();
			}

			int[] result = bestItems(capacity, items);

			if (result.length == 0) {
				System.out.println("Cannot fill to capacity.");
			} else {
				Arrays.sort(result);
				System.out.println("This run uses: " + Arrays.toString(result));
			}

		}

		sc.close();
	}
}

