import java.util.ArrayList;
import java.util.Arrays;
import java.util.Scanner;
import java.util.Collections;

class NodeInfo {
	int height;
	int label;
	ArrayList<Integer> childLabels = new ArrayList<Integer>();
	int parent;
	NodeInfo(int parent) {
		this.parent = parent;
	}
}

public class Trees {

	// parents_tree1 is always rooted at 0; root2 denotes the root of parents_tree2 we want to try out
	private static boolean areIsomorphic(int[] parents_tree1, int[] parents_tree2, int root2) {
		// reorient tree2
		int[] parents2_tree_copy = parents_tree2.clone();
		int newParent = -1;
		int cur = root2;
		while(true) {
			int temp = parents2_tree_copy[cur];
			parents2_tree_copy[cur] = newParent;
			newParent = cur;
			cur = temp;
			if(cur == -1) 
				break;
		}
		// System.out.println("reoriented: " + Arrays.toString(parents2_tree_copy));

		// assign height labels to both the trees
		int numVertices = parents_tree1.length;
		NodeInfo[] nodes1 = new NodeInfo[numVertices];
		NodeInfo[] nodes2 = new NodeInfo[numVertices];
		for(int i = 0; i < numVertices; i++) {
			nodes1[i] = new NodeInfo(parents_tree1[i]);
			nodes2[i] = new NodeInfo(parents2_tree_copy[i]);
		}

		// Assign heights to all the nodes
		nodes1[0].height = 0;
		nodes2[root2].height = 0;
		for(int h = 1; h <= numVertices; h++) {
			// for every vertex, check if its parent is label h-1; if yes, label it h
			for(int i = 0; i < numVertices; i++) {
				if( (i != 0) && (nodes1[nodes1[i].parent].height == h-1) )
					nodes1[i].height = h;
				if( (i != root2) && (nodes2[nodes2[i].parent].height == h-1) )
					nodes2[i].height = h;
			}
		}

		for(int h = numVertices-1; h > 0; h--) {
			// For all the nodes at level "h", order their "childLabels" sets, and create labels for them
			for(int i = 0; i < numVertices; i++) {
				if(nodes1[i].height == h) {
					Collections.sort(nodes1[i].childLabels);
					// System.out.println("Tree 1, Node " + i + " at height " + h + " has childLabels = " + nodes1[i].childLabels); 
				}
				if(nodes2[i].height == h) {
					Collections.sort(nodes2[i].childLabels);
					// System.out.println("Tree 2, Node " + i + " at height " + h + " has childLabels = " + nodes2[i].childLabels); 
				}
			}
			ArrayList<ArrayList<Integer>> all = new ArrayList<ArrayList<Integer>>();
			for(int i = 0; i < numVertices; i++) {
				if(nodes1[i].height == h) {
					int f = all.indexOf(nodes1[i].childLabels);
					if(f == -1) {
						all.add(nodes1[i].childLabels);
						f = all.size() - 1;
					}
					nodes1[nodes1[i].parent].childLabels.add(f);
				}
			}
			for(int i = 0; i < numVertices; i++) {
				if(nodes2[i].height == h) {
					int f = all.indexOf(nodes2[i].childLabels);
					if(f == -1)
						return false;
					nodes2[nodes2[i].parent].childLabels.add(f);
				}
			}
		}
		return true;
	}

	private static int findIsomorphism(int[] parents_tree1, int[] parents_tree2) {
		for(int i = 0; i < parents_tree1.length; i++) {
			// System.out.println("trying with root " + i);
			if(areIsomorphic(parents_tree1, parents_tree2, i)) 
				return i;
		}
		return -1;
	}

	public static void main(String[] args) {
		Scanner sc = new Scanner(System.in);

		int numTests = sc.nextInt();		// number of test cases

		for (int t = 0; t < numTests; t++) {
			int numVertices = sc.nextInt();
			int[] parents_tree1 = new int[numVertices];
			int[] parents_tree2 = new int[numVertices];

			// We assume both the trees are provided with root = 0, so we set the corresponding parents entries to -1
			parents_tree1[0] = -1;
			parents_tree2[0] = -1;

			// Read the structure of the first tree, and directly set the parents_tree1[] array
			for(int i = 0; i < numVertices - 1; i++) 
				parents_tree1[sc.nextInt()] = sc.nextInt();
			// Similarly read the second tree
			for(int i = 0; i < numVertices - 1; i++) 
				parents_tree2[sc.nextInt()] = sc.nextInt();

			int ans = findIsomorphism(parents_tree1, parents_tree2);
			if(ans == -1) {
				System.out.println("The two trees are not Ragnorianic.");
			} else {
				System.out.println("The trees are Ragnorianic -- root of the first tree maps to node " + ans + " of the second tree.");
			}
		}

		sc.close();
	}
}
