import java.util.Scanner;
import java.util.Arrays;
import java.util.ArrayList;

public class OpeningDoors {

	private static void printMatrix(int[][] matrix) {
		for(int i = 0; i < matrix.length; i++) 
			System.out.println(Arrays.toString(matrix[i]));
	}


	private static ArrayList<Integer> enumerateSwitchesNaive(int numSwitches, int numDoors, ArrayList<Integer> switchOpens[], ArrayList<Integer> needOpen) {
		boolean[] subset = new boolean[numSwitches];

		for(int ii = 0; ii < Math.pow(2, numSwitches); ii++) {
			System.out.print("State = " + Arrays.toString(subset) + ": Open = ");
			for(int i = 0; i < numDoors; i++) {
				// how many times toggled?
				int num_toggled = 0;
				for(int j = 0; j < numSwitches; j++)
					if(subset[j] && switchOpens[j].contains(i)) 
						num_toggled++;
				if (num_toggled % 2 == 1) 
					System.out.print(i + " ");
			}
			System.out.println();

			// advance
			for(int i = numSwitches-1; i >= 0; i--) 
				if(subset[i] = !subset[i])
					break;
		}
		return null;
	}

	private static void chooseSwitchesNaive(int numSwitches, int numDoors, ArrayList<Integer> switchOpens[], ArrayList<Integer> needOpen) {
		boolean[] subset = new boolean[numSwitches];

		for(int ii = 0; ii < Math.pow(2, numSwitches); ii++) {
			boolean viable = true;

			for(int i = 0; i < numDoors; i++) {
				// how many times toggled?
				int num_toggled = 0;
				for(int j = 0; j < numSwitches; j++)
					if(subset[j] && switchOpens[j].contains(i)) 
						num_toggled++;
				if ( ((num_toggled % 2 == 1) && !needOpen.contains(i)) || ((num_toggled % 2 == 0) && needOpen.contains(i)) ) 
					viable = false;
			}

			if(viable) {
				ArrayList<Integer> ans = new ArrayList<Integer>();
				for(int i = 0; i < numSwitches; i++)
					if(subset[i]) ans.add(new Integer(i));
				System.out.println("Toggle switches " + ans);
			}

			// advance
			for(int i = numSwitches-1; i >= 0; i--) 
				if(subset[i] = !subset[i])
					break;
		}
	}


	private static ArrayList<Integer> chooseSwitches(int numSwitches, int numDoors, ArrayList<Integer> switchOpens[], ArrayList<Integer> needOpen) {
		/* ------------------- INSERT CODE HERE ---------------------
		 *
		 * Your code should return the list of switches to toggle so that exactly the required set of 
		 * doors (specified in needOpen) are open, and no other doors are open.
		 *
		 * */

		int matrix[][] = new int[numDoors][numSwitches+1];
		for(int i = 0; i < numSwitches+1; i++)
			for(int j = 0; j < numDoors; j++)
				matrix[j][i] = 0;

		for(int i = 0; i < numSwitches; i++) 
			for(Integer i_int : switchOpens[i]) 
				matrix[i_int.intValue()][i] = 1;

		for(Integer i_int : needOpen)
			matrix[i_int.intValue()][numSwitches] = 1;

		// printMatrix(matrix);

		/* Do Gaussian Elimination. */
		int previousLeadingOneIndex = -1;
		for(int i = 0; i < numDoors; i++) {
			int nextLeadingOneIndex = previousLeadingOneIndex + 1;

			while(true) {
				if(matrix[i][nextLeadingOneIndex] != 1) {
					// if any of the matrix[j][nextLeadingOneIndex], with j > i are 1, then swap
					for(int j = i+1; j < numDoors; j++) {
						if(matrix[j][nextLeadingOneIndex] == 1) {
							// swap rows j and i
							for(int k = 0; k < numSwitches+1; k++) {
								int temp = matrix[j][k];
								matrix[j][k] = matrix[i][k];
								matrix[i][k] = temp;
							}
							break;
						}
					}
				}

				// if still not one, let's move forward
				if( (matrix[i][nextLeadingOneIndex] == 1) || (nextLeadingOneIndex == numSwitches-1) )
					break;
				nextLeadingOneIndex++;
			}

			if(matrix[i][nextLeadingOneIndex] == 1) {
				for(int j = i+1; j < numDoors; j++) {
					if(matrix[j][nextLeadingOneIndex] == 1) {
						// add row i to row j
						for(int k = 0; k < numSwitches+1; k++) 
							matrix[j][k] = (matrix[j][k] + matrix[i][k]) % 2;
					}
				}
			} else {
				break;
			}
		}

		// System.out.println("After elimination step 1");
		// printMatrix(matrix);

		/* Do the reverse reduction into reduced echelon form. */
		for(int i = 0; i < numDoors; i++) {
			// find the leading 1
			int leadingOne = -1;
			for(int j = 0; j < numSwitches; j++) {
				if(matrix[i][j] == 1) {
					leadingOne = j;
					break;
				}
			}

			if(leadingOne == -1) 
				break;
			else {
				for(int j = 0; j < i; j++) {
					if(matrix[j][leadingOne] == 1) {
						// add row i to row j
						for(int k = 0; k < numSwitches+1; k++) 
							matrix[j][k] = (matrix[j][k] + matrix[i][k]) % 2;
					}
				}
			}
		}

		// System.out.println("After elimination step 2");
		// printMatrix(matrix);

		ArrayList<Integer> ans = new ArrayList<Integer>();
		for(int i = 0; i < numDoors; i++) {
			// find the leading 1
			int leadingOne = -1;
			for(int j = 0; j < numSwitches; j++) {
				if(matrix[i][j] == 1) {
					leadingOne = j;
					break;
				}
			}
			if(matrix[i][numSwitches] == 1) {
				if(leadingOne == -1) {
					return null;
				} else {
					ans.add(new Integer(leadingOne));
				}
			}
		}

		return ans;

		/* -------------------- END OF INSERTION --------------------*/
		// return null;
	}

	public static void main(String[] args) {
		Scanner sc = new Scanner(System.in);

		int numCases = sc.nextInt();

		for(int i = 0; i < numCases; i++)
		{
			int numSwitches = sc.nextInt();
			int numDoors = sc.nextInt();

			ArrayList<Integer> switchOpens[] = (ArrayList<Integer>[]) new ArrayList[numSwitches];

			for(int j = 0; j < numSwitches; j++) {
				int n = sc.nextInt();
				switchOpens[j] = new ArrayList<Integer>();
				for(int k = 0; k < n; k++) 
					switchOpens[j].add(new Integer(sc.nextInt()));
			}

			ArrayList<Integer> needOpen = new ArrayList<Integer>();
			int n = sc.nextInt();
			for(int k = 0; k < n; k++) 
				needOpen.add(new Integer(sc.nextInt()));

			// System.out.println("--- Naive");
			// chooseSwitchesNaive(numSwitches, numDoors, switchOpens, needOpen);
			// System.out.println("--- Better");
			ArrayList<Integer> ans = chooseSwitches(numSwitches, numDoors, switchOpens, needOpen);

			if(ans == null) {
				System.out.println("No combination of the switches can result in the desired configuration.");
			} else {
				System.out.println("Toggle switches " + ans);
			}
		}
		sc.close();
	}
}
