import java.util.Scanner;
import java.util.Arrays;
import java.util.ArrayList;

class Solution {
	int value;
	int breakpoint_player;
	int breakpoint_dealer;
	Solution(int v, int bp, int bd) {
		this.value = v;
		this.breakpoint_player = bp;
		this.breakpoint_dealer = bd;
	}
	Solution(int v) {
		this.value = v;
		this.breakpoint_player = -1;
		this.breakpoint_dealer = -1;
	}
	void print() {
		System.out.println(" -- (value, bp_player, bp_dealer) = " + this.value + ", " + this.breakpoint_player + ", " + this.breakpoint_dealer);
	}
}

public class Cards {
	private static ArrayList<Integer> collectBreakpoints(int player_start, int player_end, int dealer_start, int dealer_end, Solution best_solutions[][][][]) {
		Solution sol = best_solutions[player_start][player_end][dealer_start][dealer_end];
		if(sol.breakpoint_player == -1) {
			ArrayList<Integer> arr = new ArrayList<Integer>();
			if(dealer_end == dealer_start)
				arr.add(new Integer(player_end));
			else {
				assert (dealer_end - dealer_start) == (player_end - player_start);
				for(int i = player_start; i <= player_end; i++) 
					arr.add(new Integer(i));
			}
			return arr;
		} else {
			ArrayList<Integer> a1 = collectBreakpoints(player_start, sol.breakpoint_player, dealer_start, sol.breakpoint_dealer, best_solutions);
			ArrayList<Integer> a2 = collectBreakpoints(sol.breakpoint_player+1, player_end, sol.breakpoint_dealer+1, dealer_end, best_solutions);
			a1.addAll(a2);
			return a1;
		}
	}

	// Find solution for every range of player cards, matched with every range of dealer cards
	private static int solveRecursive(int[] cards_player, int start_player, int end_player, int[] cards_dealers, int start_dealer, int end_dealer, Solution[][][][] best_solutions) {

		// Check if already done
		if(best_solutions[start_player][end_player][start_dealer][end_dealer] != null) {
			Solution sol = best_solutions[start_player][end_player][start_dealer][end_dealer];
			return sol.value;
		}

		// base case 1
		if( (end_player - start_player) == (end_dealer - start_dealer) ) {
			int value = 0;
			for(int i = 0; i <= end_player - start_player; i++) {
				if(cards_player[start_player + i] > cards_dealers[start_dealer + i]) {
					value += 10;
				} else {
					if(cards_player[start_player + i] == cards_dealers[start_dealer + i])
						value += 5;
				}
			}

			best_solutions[start_player][end_player][start_dealer][end_dealer] = new Solution(value);
			return value;
		}

		// base case 2
		if(end_dealer == start_dealer) {
			int total = 0;
			for(int i = 0; i <= end_player - start_player; i++)
				total += cards_player[start_player+i];
			int value = (total > cards_dealers[end_dealer]) ? 10 : ( (total == cards_dealers[end_dealer]) ? 5 : 0);

			best_solutions[start_player][end_player][start_dealer][end_dealer] = new Solution(value);
			return value;
		}


		int best_so_far = -1;
		int best_bp_player = -1;
		int best_bp_dealer = -1;
		// go over possible breakpoints in the sequence for both of them
		for(int breakpoint_player = start_player; breakpoint_player < end_player; breakpoint_player++) {
			for(int breakpoint_dealer = start_dealer; breakpoint_dealer < end_dealer; breakpoint_dealer++) {
				// the number of player cards must be larger than the number of dealer cards in either group
				if( ((breakpoint_player - start_player) >= (breakpoint_dealer - start_dealer)) && 
						((end_player - breakpoint_player) >= (end_dealer - breakpoint_dealer)) ) {
					int val = solveRecursive(cards_player, start_player, breakpoint_player, cards_dealers, start_dealer, breakpoint_dealer, best_solutions)  +
						solveRecursive(cards_player, breakpoint_player+1, end_player, cards_dealers, breakpoint_dealer+1, end_dealer, best_solutions);

					if(val > best_so_far) {
						best_so_far = val;
						best_bp_player =  breakpoint_player;
						best_bp_dealer =  breakpoint_dealer;
					}
				}
			}
		}

		best_solutions[start_player][end_player][start_dealer][end_dealer] = new Solution(best_so_far, best_bp_player, best_bp_dealer);
		return best_so_far;

	}

	private static int bestPlay(int[] cards_player, int[] cards_dealer, ArrayList<Integer> solution) {
		Solution[][][][] best_solutions = new Solution[cards_player.length][cards_player.length][cards_dealer.length][cards_dealer.length];

		for(int i = 0; i < cards_dealer.length; i++) 
			solveRecursive(cards_player, 0, cards_player.length-1, cards_dealer, 0, i, best_solutions);

		// need to figure out the best overall solution
		int best_val = -1;
		int best_num_dealer_cards_used = -1;
		for(int i = 0; i < cards_dealer.length; i++) {
			if(best_solutions[0][cards_player.length - 1][0][i].value > best_val) {
				best_val = best_solutions[0][cards_player.length - 1][0][i].value;
				best_num_dealer_cards_used = i+1;
			}
		}

//		for(int i = 0; i < cards_dealer.length; i++) {
//			Solution sol = best_solutions[0][cards_player.length - 1][0][i];
//			System.out.println("For using " + i + " dealer cards: ");
//			sol.print();
//		}

		// need to collect the break points
		ArrayList<Integer> breakpoints = collectBreakpoints(0, cards_player.length-1, 0, best_num_dealer_cards_used - 1, best_solutions);

		for(Integer i: breakpoints) 
			solution.add(i);

		return best_val;
	}

	public static void main(String[] args) {
		Scanner sc = new Scanner(System.in);

		int numOfTestCases = sc.nextInt();

		for (int testCase=0; testCase < numOfTestCases; testCase++) { 
			int numOfCards = sc.nextInt();
			int[] cards_player = new int[numOfCards];
			for (int i=0; i < numOfCards; i++) 
				cards_player[i] = sc.nextInt();
			int[] cards_dealer = new int[numOfCards];
			for (int i=0; i < numOfCards; i++) 
				cards_dealer[i] = sc.nextInt();

			ArrayList<Integer> results = new ArrayList<Integer>();
			int value = bestPlay(cards_player, cards_dealer, results);        
			System.out.println("Best value " + value  + " is obtained by stopping at positions: " + results);
		}

		sc.close();
	}
}

