package cmsc420_s23;

// YOU SHOULD NOT MODIFY THIS FILE

import java.util.Scanner;
import java.util.ArrayList;
import java.util.Iterator;

//---------------------------------------------------------------------
// Command handler. This reads a single command line, processes the 
// command (by invoking the appropriate method(s) on the data structure)
// and returns the result as a string.
//---------------------------------------------------------------------

public class CommandHandler {

	private ScapegoatTree<Double> tree; // the scapegoat tree

	/**
	 * Initialize command handler
	 */
	public CommandHandler() {
		tree = new ScapegoatTree<Double>();
	}

	/**
	 * Process a single command and return the string output.
	 */

	public String processCommand(String inputLine) throws Exception {
		String output = new String(); // for storing summary output
		Scanner line = new Scanner(inputLine);
		try {
			line.useDelimiter(":"); // use ":" to separate arguments
			String cmd = (line.hasNext() ? line.next() : ""); // next command
			// -----------------------------------------------------
			// INSERT x
			// -----------------------------------------------------
			if (cmd.compareTo("insert") == 0) {
				double x = line.nextDouble();
				output += "insert(" + x + "): ";
				tree.insert(x); // insert into tree
				output += "successful" + System.lineSeparator();
			}
			// -----------------------------------------------------
			// DELETE x
			// -----------------------------------------------------
			else if (cmd.compareTo("delete") == 0) {
				double x = line.nextDouble();
				output += "delete(" + x + "): ";
				tree.delete(x); // delete from tree
				output += "successful" + System.lineSeparator();
			}
			// -----------------------------------------------------
			// CLEAR
			// -----------------------------------------------------
			else if (cmd.compareTo("clear") == 0) {
				tree.clear(); // clear the tree
				output += "clear: successful" + System.lineSeparator();
			}
			// -----------------------------------------------------
			// SIZE
			// -----------------------------------------------------
			else if (cmd.compareTo("size") == 0) {
				int size = tree.size(); // get the tree's current size
				output += "size: " + size + System.lineSeparator();
			}
			// -----------------------------------------------------
			// FIND x
			// -----------------------------------------------------
			else if (cmd.compareTo("find") == 0) {
				double x = line.nextDouble();
				Double result = tree.find(x);
				output += "find(" + x + "): ";
				if (result != null) {
					output += "found" + System.lineSeparator();
				} else {
					output += "not found" + System.lineSeparator();
				}
			}
			// -----------------------------------------------------
			// LIST
			// -----------------------------------------------------
			else if (cmd.compareTo("list") == 0) {
				ArrayList<String> list = tree.list();
				output += "list:" + System.lineSeparator();
				Iterator<String> iter = list.iterator(); // iterator for the list
				if (iter.hasNext()) { // tree is nonempty
					output += treeStructureHelper(iter, "  "); // print everything
				}
			}
			// -----------------------------------------------------
			// Invalid command or empty
			// -----------------------------------------------------
			else {
				if (cmd.compareTo("") == 0)
					System.err.println("Error: Empty command line (Ignored)");
				else
					System.err.println("Error: Invalid command - \"" + cmd + "\" (Ignored)");
			}
			line.close();
		} catch (Exception e) { // exception thrown?
			if (e.getMessage() == null) {
				output += "Failure due to unexpected exception (probably runtime error)" + System.lineSeparator();
			} else {
				output += "Failure due to exception: \"" + e.getMessage() + "\"" + System.lineSeparator();
			}
		} catch (Error e) { // error occurred?
			System.err.print("Operation failed due to runtime error: " + e.getMessage());
			e.printStackTrace(System.err);
		} finally { // always executed
			line.close(); // close the input scanner
		}
		return output; // return summary output
	}

	/**
	 * Recursive helper for treeStructure.
	 */
	static String treeStructureHelper(Iterator<String> iter, String indent) {
		final String levelIndent = "| "; // the indentation for each level of the tree
		String output = "";
		if (iter.hasNext()) {
			String entry = iter.next(); // get the next entry
			Boolean isExtern = (entry.length() > 0 && entry.charAt(0) == '['); // external?
			if (isExtern) { // print external node entry
				output += indent + entry + System.lineSeparator();
			} else {
				output += treeStructureHelper(iter, indent + levelIndent); // print right subtree
				output += indent + entry + System.lineSeparator(); // print this node
				output += treeStructureHelper(iter, indent + levelIndent); // print left subtree
			}
		} else {
			System.err.println("Unexpected trailing elements in entries list"); // shouldn't get here!
		}
		return output;
	}
}