package cmsc420_s23;

import java.io.FileInputStream;
import java.util.Scanner;

//---------------------------------------------------------------------
// This reads input from a test file and sends results to the standard
// output.
//---------------------------------------------------------------------
public class Tester {
	public static void main(String[] args) {
		try {
			FileInputStream inStream = new FileInputStream("tests/test01-input.txt");
			System.setIn(inStream);
			Scanner scanner = new Scanner(System.in); // input scanner
			CommandHandler commandHandler = new CommandHandler(); // initialize command handler
			while (scanner.hasNextLine()) {
				String line = scanner.nextLine(); // input next line
				String output = commandHandler.processCommand(line); // process this command
				System.out.print(output); // output summary
			}
			scanner.close();
			inStream.close();
		} catch (Exception e) {
			System.err.println("Error encountered processing file");
			e.printStackTrace();
		}
	}
}
