#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "rijndael-api-ref.h"

static void encrypt_decrypt (int number_of_times) {
  int i, j, r;
  BYTE block[4*MAXBC];
  BYTE keyMaterial[320];
  keyInstance keyInst;
  cipherInstance cipherInst;
  int blockLength = BITSPERBLOCK;
  int keyLength = 256;

  memset (block, 0, blockLength/8);
  memset (keyMaterial, 0, sizeof (keyMaterial));
  memset (keyMaterial, '0', keyLength/4);

  for (i = 0; i < number_of_times; i++) {
    keyInst.blockLen = blockLength;
    r = makeKey(&keyInst, DIR_ENCRYPT, keyLength, keyMaterial);
    if (TRUE != r) {
      fprintf(stderr,"makeKey error %d\n",r);
      exit(-1);
    }
    memset (block, 0, blockLength/8);
    cipherInst.blockLen = blockLength;
    r = cipherInit (&cipherInst, MODE_ECB, NULL);
    if (TRUE != r) {
      fprintf(stderr,"cipherInit error %d\n",r);
      exit(-1);
    }
    r = blockEncrypt(&cipherInst, &keyInst, block, blockLength, block);
    if (blockLength != r) {
      fprintf(stderr,"blockEncrypt error %d\n",r);
      exit(-1);
    }
    keyInst.blockLen = blockLength;
    makeKey(&keyInst, DIR_DECRYPT, keyLength, keyMaterial);
    blockDecrypt(&cipherInst, &keyInst, block, blockLength, block);
    for (j = 0; j < blockLength/8; j++) {
      if (block[j] != 0) {
        fprintf(stderr,"blockDecrypt error\n");
        exit(-1);
      }
    }
  }
}

int main (void) {
  encrypt_decrypt(10000);
  return 0;
}
