/*  cmds.c: BetaFTPD command handler prototypes
    Copyright (C) 1999 Steinar H. Gunderson

    This program is is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License, version 2 if the
    License as published by the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <dirent.h>

#define CMD_PROTO(cmd) void cmd_ ## cmd (struct conn * const c)

int do_chdir(struct conn * const c, const char * const newd);
CMD_PROTO(user);
CMD_PROTO(pass);
CMD_PROTO(port);
CMD_PROTO(pasv);
CMD_PROTO(pwd);
CMD_PROTO(cwd);
CMD_PROTO(cdup);
CMD_PROTO(rest);
CMD_PROTO(retr);
CMD_PROTO(size);
CMD_PROTO(mdtm);
CMD_PROTO(list);
CMD_PROTO(nlst);
CMD_PROTO(syst);
CMD_PROTO(noop);
CMD_PROTO(type);
CMD_PROTO(mode);
CMD_PROTO(stru);
CMD_PROTO(quit);

#if WANT_UPLOAD
CMD_PROTO(stor);
#endif

void parse_command(struct conn * c);
void prepare_for_sending(struct ftran *f);
char decode_mode(mode_t mode);
int do_openfile(struct conn * const c, char * const path, char * const filename, const int flags);
int prepare_for_listing(struct conn * const c, char ** const ptr);
extern char anon_root_dir[128];
