/*  disp.c: BetaFTPD full-screen stats
    Copyright (C) 1999 Steinar H. Gunderson

    This program is is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License, version 2 if the
    License as published by the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#if HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <ftpd.h>

#if WANT_FULLSCREEN
time_t last_update = 0;

void update_display(const struct conn * const first_conn)
{
	struct conn *c = first_conn->next_conn;
	int i = 0;
	time_t now;

	time(&now);
	if (now - last_update < 1) return;
	last_update = now; 

        printf("%cc", (char)27);        /* clear the screen */
	printf("%c[44m                                                                                ", (char)27);
	printf("%c[44m                                                                                ", (char)27);
	printf("%c[38m                               BetaFTPD FTP server                               ", (char)27);
        printf("%c[44m                                                                                ", (char)27);
        printf("%c[44m                                                                               ", (char)27);
	printf("%c[40m", 27);
	while (c != NULL && ++i < 20) {
		const struct ftran * const f = c->transfer;
		printf("%4u ", c->sock);
		if (f == NULL) {
			printf("%-16s %-50s\n", c->username, c->last_cmd);
		} else {
#if WANT_UPLOAD
			if (f->upload) {
				printf("%-16s%-22s%12lu %7.2fkb/s (upl)\n", c->username, f->filename,
				f->size, (float)(f->pos - c->rest_pos) / (float)(difftime(now, f->tran_start)) / 1024);
			} else
#endif
			printf("%-16s%-22s%12lu %7.2fkb/s %.2f%%\n", c->username, f->filename,
				f->size, (float)(f->pos - c->rest_pos) / (float)(difftime(now, f->tran_start)) / 1024,
				(float)(f->pos) / (float)(f->size) * 100.0f);
		}
		c = c->next_conn;
	}
}
#endif
