/*  ftpd.h: Prototypes for BetaFTPD
    Copyright (C) 1999 Steinar H. Gunderson

    This program is is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License, version 2 if the
    License as published by the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#define FTP_PORT 31122

#include <netinet/in.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <pwd.h>

/* doubly linked list of active connections */
struct conn {
	int free_me;

        struct conn *`RC prev_conn;
	struct conn *`RC next_conn;

	int sock;
	char recv_buf[256]@zeroterm;
	char last_cmd[256]@zeroterm;
	int buf_len;
	int auth;

	char username[17]@zeroterm;
	char pass_want[17]@zeroterm;

	uid_t uid;
	char root_dir[256]@zeroterm;
	char curr_dir[256]@zeroterm;

	int port_allocated;
	struct ftran *`RC transfer;

	int rest_pos;
	time_t *`U last_transfer;
};

/* doubly linked list of file transfers */
struct ftran {
	struct ftran *`RC prev_ftran;
	struct ftran *`RC next_ftran;
	struct conn *`RC owner;

	int state;		/*
				 * 0 = none, 1 = got PASV addr,
				 * 2 = waiting on PASV socket,  
				 * 3 = got PORT addr, 4 = waiting for
				 *     PORT connect, 
				 * 5 = transferring file (or waiting 
				 *     for PORT connect)
				 */
	struct sockaddr_in sin;
	int sock;
	int dir_listing;
	char filename[256]@zeroterm;
	time_t tran_start;
	long int size;

	int local_file;

#if HAVE_MMAP
        char ?@nozeroterm file_data;	/* mmap'ed */
#endif
	long int pos;

#if WANT_UPLOAD
	int upload;
#endif
};

struct conn *`RC alloc_new_conn(int sock);
struct ftran *`RC alloc_new_ftran(int sock, struct conn *`RC c) __attribute((consume(2)));
void destroy_conn(struct conn *`r c); 
void destroy_ftran(struct ftran *`RC c) __attribute((consume(1)));
int process_all_clients(fd_set @active_clients, int num_ac);
int process_all_sendfiles(fd_set @active_clients, int num_ac);
void time_out_sockets();
void remove_bytes(struct conn @`r c, const int i);
void numeric(struct conn *`r const c, const int numeric, const char ? const format, ...inject parg_t args);
void init_file_transfer(struct ftran * const f);
