#!/bin/tcsh

set CYCLONE="cyclone -c"
set CYCBISON="cycbison"
set CYCFLEX="cycflex"
set ERRORS_IN_FILES=""

$CYCBISON -y -d boa_grammar.y
mv y_tab.cyc y.tab.cyc
mv y_tab.h y.tab.h

$CYCFLEX boa_lexer.l
mv boa_lexer.cyc lex.yy.cyc

foreach source_file ( `ls *.cyc` )
    $CYCLONE $source_file
    if ( $status != 0 ) then
        set ERRORS_IN_FILES="${ERRORS_IN_FILES}|- ${source_file}\n"
    endif
end

if ( ERRORS_IN_FILES != "" ) then
    echo "\nError compiling following files:"
    echo $ERRORS_IN_FILES
endif
