%{

/*
 *  Boa, an http server
 *  Copyright (C) 1995 Paul Phillips <psp@well.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
/* #include "boa.h" */
#include "parse.h"

/* void yyerror(string_t msg); */

/* yydebug = 1; */

#ifdef DEBUG
#define DBG(x) x
#else
#define DBG(x)
#endif

char *arg1hold;
char mime_type[256] @zeroterm;            /* global to inherit */

%}

%union <`r> {
    sval(char *`r);
    ival(int);
    cval(struct ccommand @`r);
};
%token STMT_NO_ARGS STMT_ONE_ARG STMT_TWO_ARGS MIMETYPE STRING INTEGER
/* boa.conf tokens */
%type <struct ccommand @`r> STMT_NO_ARGS STMT_ONE_ARG STMT_TWO_ARGS

/* mime.type tokens */
%type <char *`r> MIMETYPE
%type <char *`r> STRING
%type <int> INTEGER

%start ConfigFiles

%%

ConfigFiles:		BoaConfigStmts MimeTypeStmts
	;

BoaConfigStmts:		BoaConfigStmts BoaConfigStmt
	|		/* empty */
	;

BoaConfigStmt:		
			StmtNoArgs
	|		StmtOneArg
	|		StmtTwoArgs
	;

StmtNoArgs:		STMT_NO_ARGS
		{ let &ccommand{<`a> my_name, my_type, my_action, my_object} = $1; if (my_action) {
			DBG(printf("StmtNoArgs: %s\n",my_name);)
			my_action(NULL,NULL,my_object);
		 }
		}
	;

StmtOneArg:		STMT_ONE_ARG STRING
		{ let &ccommand{<`a> my_name, my_type, my_action, my_object} = $1; if (my_action) {
			DBG(printf("StmtOneArg: %s %s\n",my_name,$2);)
			my_action($2,NULL,my_object);
		 }
		}
	;

StmtTwoArgs:		STMT_TWO_ARGS STRING
		{ arg1hold = strdup($2); }
			 STRING
		{ let &ccommand{<`a> my_name, my_type, my_action, my_object} = $1; if (my_action) {
			DBG(printf("StmtTwoArgs: '%s' '%s' '%s'\n",
			            my_name,arg1hold,$4);)
			my_action($4,arg1hold,my_object);
		  }
		  free(arg1hold);
		}
	;


/******************* mime.types **********************/

MimeTypeStmts:		MimeTypeStmts MimeTypeStmt
	|		/* empty */
	;

MimeTypeStmt:		MIMETYPE 
		{ strcpy(mime_type, $1); }
			ExtensionList
	;

ExtensionList:		ExtensionList Extension
	|		/* empty */
	;

Extension:		STRING
		{ add_mime_type($1, mime_type); }
	;

%%

