#!/usr/bin/perl -w

$loc_free_map = {};
$allocs = {};
while($line = <>) {
    if($line =~ /^(\S+:\d+)\srefcnt\salloc\s(\S+)$/) {
	$loc = $1; $ptr = $2;
	$allocs->{$ptr} = $loc;
    }
    elsif($line =~ /^(\S+:\d+)\srefcnt\sfree\s(\S+)$/) {
	$floc = $1; $ptr = $2;
	if($allocs->{$ptr}) {
	    $aloc = $allocs->{$ptr};
	    if($loc_free_map->{$aloc}) {
		$flocs = $loc_free_map->{$aloc}; 
		$flocs->{$floc}++;
	    }
	    else {
		$loc_free_map->{$aloc} = {$floc => 1};
	    }
	    delete $allocs->{$ptr};
	}
	else {
	    print "Free $ptr without remembered allocation\n";
	}
    }
}

for $aloc (keys %$loc_free_map) {
    $flocs = $loc_free_map->{$aloc};
    print "Pointers allocated at site $aloc are freed at: ";
    for $floc (keys %$flocs) {
	print "$floc, ";
    }
    print "\n";
}

$leaks = {};
for $ptr (keys %$allocs) {
    $loc = $allocs->{$ptr};
    if($leaks->{$loc}) {
	$leaks->{$loc}++;
    }
    else {
	$leaks->{$loc} = 1;
    }
}
for $loc (keys %$leaks) {
    $n = $leaks->{$loc};
    print "Pointer allocated at $loc leak ($n)\n";
}
