#ifndef __PDEFS_H__
#define __PDEFS_H__
/*
 * +------------------------------------------------------------------+
 * |	     Private Math Library Definitions			      |
 * +------------------------------------------------------------------+
 */
/*
 * Optional assembly language 
 */
#include <stdlib.h>

#ifdef ASM
#include "machineop.h"		/* 16-bit integer machine operations */
#define uModDiv(n, d, qp)	umoddiv16(n, d, qp)   /* slight help */
#else
#define uModDiv_(n, d, qp, qi)	(qp[qi] = (n) / (d), (n) % (d))
#define uModDiv(n, d, qp)	(*(qp) = (n) / (d), (n) % (d))
#endif
#define uMul(u, v)		((u) * (v))	      /* fast enough */

#define IGNOREFREE
/*
 * Optional alternate memory allocator
 */
#ifndef MYALLOC

#    ifdef BWGC
extern char *GC_malloc_atomic();
#define allocate(size)	(char *) GC_malloc_atomic(size)

#    else
//extern char *malloc();
#define allocate(size)	(char *) malloc(size)
#    endif

#ifdef IGNOREFREE
#define deallocate(p)	{};
#else

#define deallocate(p)	free(p)
#endif

#else
extern char  *allocate();
extern void  deallocate();
#endif

/*
 * These next four types are used only used in this include file
 */
typedef	unsigned char	u8;				  /*  8 bits */
typedef unsigned short	u16;				  /* 16 bits */
typedef unsigned long	u32;			  	  /* 32 bits */
typedef u8           	boolean;		          /*  1 bit  */

#define BASE	  	65536		/* Base * (Base-1) <= MAXINT */

/*
 * Operations on Base (unsigned math)
 */
#define modBase(u)	((u) & 0xffff)		/* remainder on Base */
#define divBase(u)	((u) >> 16)		/* divide    by Base */
#define mulBase(u)	((u) << 16)		/* multiply  by Base */

/*
 * The type of a variable used to store intermediate results.  
 * This should be the most efficient unsigned int on your machine.
 */
typedef u32		accumulator;	     /* 0..(Base * Base) - 1 */

/*
 * The type of a single digit
 */
typedef u16      	digit;				/* 0..Base-1 */

/*
 * The type of a digit index (the largest number of digits - 1)
 * Determines the maximum representable precision (not usually changed)
 */
typedef u16      	posit;				 /* 0..size  */

typedef unsigned short	prefc;			/* in precision.h also */
/*
 * End of area which needs to be modified
 */

#define false     	0
#define true	  	1

typedef digit	      	?@aqual(`q) digitString<`q>;	 	 /* dummy array type */
typedef digit     	?digitPtr;

/*
 * A normalized integer has the following attributes:
 *   -0 cannot occur
 *   all digits >= size assumed to be 0.  (no leading zero's)
 *   size > 0
 */
struct __precisionType<`q> {				
  posit	alloc;		/* allocated size      */
  posit       size;	 	/* number of digits    */
  boolean     sign;		/* sign: TRUE negative */
  digitString<`q> value;
};
typedef struct __precisionType<`q> precisionType<`q>;
typedef struct __precisionType<\A> *@aqual(\A) al_precision_t;	/* this a a private data structure */
typedef struct __precisionType<\A> *@aqual(\RC) precision_t;	/* this a a private data structure */
typedef struct __precisionType<\A> *@aqual(\RC) precisiona_t;	/* this a a private data structure */
typedef struct __precisionType<\A> *@aqual(\RC) precision;	/* this a a private data structure */
typedef struct __precisionType<\A> *@aqual(`q) `r  precision_r_t<`r,`q>;	/* this a a private data structure */


/*
 * Overlay for cache of precisions
 */


struct __cacheType<`q\T> {
  precisionType<`q> *next;		/* next item in list */
  short	count;		/* number of items in this sublist */
};
typedef struct __cacheType<`q> cacheType<`q>;

typedef cacheType<`q>	*cachePtr<`q>;
/*
 * Maximum total memory consumed by cache = 
 *    LIMIT * (1 + SIZE * (PrecisionSize + sizeof(digit) * (SIZE-1) / 2))
 */
#ifndef CACHESIZE
#define CACHESIZE	32 		/* size of allocation cache */
#endif
#define CACHELIMIT	128 		/* Determines max mem used by cache */

#define PrecisionSize	(sizeof(precisionType) - sizeof(digitString))

/*
 * Function definitions are all in the global include file "mathdefs.h".
 */
extern precision_t 	pallocf(posit);	/* semi-private */
extern int 		pfree(precision_t) __attribute((consume(1)));	/* semi-private */
extern void 		pnorm(precision_t);	/* semi-private */
extern precision_t pcopyf(struct __precisionType<`q\T> *@aqual(`q2\T) `r in) ;

#endif
