typedef struct Pfs {
   struct Pfs *next;
   precision_t  factor;
   unsigned   count;
} Pfactor;

typedef Pfactor    *FactorPtr;
typedef FactorPtr  FactorList;
typedef precision  (*pfunc)();	/* pointer to func returning precision */

#ifndef __STDC__

extern int       pprime();		/* test whether a number is prime */
extern precision_t pnextprime();		/* next prime >= it's argument */

extern precision_t pgcd();		/* greatest common divisor */
extern precision_t plcm();		/* least common multiple */
extern precision_t peuclid();		/* extended euclid's algorithm */

extern precision_t prho();		/* find factor using rho method */
extern precision_t pfermat();		/* find factor using Fermat's method */
extern precision_t pcfrac();		/* factor w/continued fractions */

extern int prhoInit();			/* alter parameters for rho method */
extern int pcfracInit();		/* alter paramteres for cfrac method */

extern precision_t  ptrial();		/* find factors using trial division */
extern precision_t  prfactor();		/* recursively factor a number */

extern void       paddfactor();		/* add a factor to a factorlist */
extern void       pputfactors();	/* print a factorlist */
extern void	  pfreefactors();	/* return a factorlist to memory */

#else

extern int       pprime(precisiona_t, unsigned trialCount);	
extern precision_t pnextprime(precisiona_t, unsigned trialCount);

extern precision_t pgcd(precisiona_t, precisiona_t);
extern precision_t plcm(precisiona_t, precisiona_t);
extern precision_t peuclid(precisiona_t, precisiona_t, precisiona_t *, precisiona_t *);

extern precision_t prho(precisiona_t n, unsigned *maxCount);
extern precision_t pfermat(precisiona_t n, unsigned *maxCount);
extern precision_t pcfrac(precision_t n, unsigned *maxCount);

extern int prhoInit(precisiona_t c, unsigned batchSize);
extern int pcfracInit(unsigned m, unsigned k, unsigned aborts);

extern precision_t  ptrial(precisiona_t n, unsigned *maxCount, FactorList *);
extern precision_t  prfactor(precisiona_t, unsigned *maxCount, pfunc, FactorList *);

extern void       paddfactor(FactorList *, precisiona_t);
extern void	  pfreefactors(FactorList *);

#ifndef BUFSIZE
#include <stdio.h>
#endif

extern void pputfactors(FILE *, FactorList);

#endif
