/*
 * Arbitrary precision integer math package
 * 
 * (c) Copyright 1991 by David A. Barrett (barrett@asgard.UUCP)
 *
 * Not to be used for profit or distributed in systems sold for profit
 */
#include <core.h>
#include <stdio.h>

#include "pdefs.h"

extern	int		pfree(precision_t) __attribute((consume(1)));	/* free (private) */

typedef precision 	*pvector;	/* a vector of precision */
typedef pvector		*parray;	/* 2d array */

extern precision _rc2a(precision_t);
extern precision * _rc2aa(precision_t);
extern precision_t _a2rc(precision);
/*
 * Error values passed to errorp
 */
#define PNOERROR	0
#define PNOMEM		1
#define PREFCOUNT	2
#define PUNDEFINED	3
#define PDOMAIN		4
#define POVERFLOW	5

#define pUndef		((precision_t) 0)		/* An undefined value */
#define pNull		((precision *) 0)

#define peq(u, v)	(pcmp((u), (v)) == 0)
#define pne(u, v)	(pcmp((u), (v)) != 0)
#define pgt(u, v)	(pcmp((u), (v)) >  0)
#define plt(u, v)	(pcmp((u), (v)) <  0)
#define pge(u, v)	(pcmp((u), (v)) >= 0)
#define ple(u, v)	(pcmp((u), (v)) <= 0)

#define peqz(u)		(pcmpz(u) == 0)
#define pnez(u)		(pcmpz(u) != 0)
#define pltz(u)		(pcmpz(u) <  0)
#define pgtz(u)		(pcmpz(u) >  0)
#define plez(u)		(pcmpz(u) <= 0)
#define pgez(u)		(pcmpz(u) >= 0)

enum __rq {REM,QUOT,NONE};
#define peven(u)	(!podd(u))

// #define pdiv(u,v)	(pdivmod(u,v, QUOT, pNull, pNull))
// #define pmod(u,v)	(pdivmod(u,v, REM,pNull, pNull))
// #define pdivr(u,v,r)	(pdivmod(u,v, QUOT, pNull, r))
// #define pmodq(u,v,q)	(pdivmod(u,v, REM,q, pNull))

#define pdiv(u,v) ({let $(__q, __r) = pdivmod2(u,v); pdestroy(__r); __q;})
#define pmod(u,v)	({let $(__q, __r) = pdivmod2(u,v); pdestroy(__q); __r;})
#define pdivr(u,v,r)	({let $(__q, __r) = pdivmod2(u,v); r=__r; __q;})
#define pmodq(u,v,q)	({let $(__q, __r) = pdivmod2(u,v); q=__q; __r;})

/*
 * Application programs should only use the following definitions;
 *
 *    pnew, pdestroy, pparm, presult and pset
 *
 * Other variants are internal only!  
 * All are side-effect safe except for pparm and presult.
 * -DDEBUG will enable argument checking for pset and pparm
 */

// #ifdef __GNUC__		/* inline is NOT ansii!  Sigh. */
// //#ifndef BWGC
// #if 0
// extern inline precision pnew(precision_t u) { (* (prefc *) u)++; return u; }
// extern inline void      pdestroy(precision_t u) {
//   if (u != pUndef && --(*(prefc *) u) == 0) pfree(u);
// }
// extern inline precision pparmq(precision u) { 
//    if (u != pUndef) (* (prefc *) u)++; return u;
// }
// extern inline precision presult(precision u) {
//    if (u != pUndef) --(*(prefc *) u); return u;
// }
// extern inline precision psetq(precision *up, precision v) {
//    precision u = *up;
//    *up = v;
//    if (v != pUndef) (* (prefc *) v)++;
//    if (u != pUndef && --(* (prefc *) u) == 0) pfree(u);
//    return v;
// }
// #define pvoid(u)	pdestroy(u)
// extern inline precision pnew(precision u) { return u; }
// extern inline void      pdestroy(precision u) {}
// extern inline precision pparmq(precision u) { return u; }
// extern inline precision presult(precision u) { return u; }
// extern inline precision psetq(precision *up, precision v) {
//    precision u = *up;
//    *up = v;
//    return v;
// }
// #define pvoid(u)	pdestroy(u)
// #endif

// #else
// #ifndef BWGC
// #define pdestroy(u)     (void) ((u)!=pUndef&&--(*(prefc *)(u))==0&&pfree(u))
// #define pparmq(u)	((u) != pUndef && (* (prefc *) (u))++, (u))
// #define pvoid(u)	pdestroyf(u)
// #else
// #define pdestroy(u)     (void) (0)
// #define pparmq(u)	(u)
// #define pvoid(u)	pdestroyf(u)
// #endif
// #endif
// #ifdef PDEBUG
// #define pset(u, v)	psetv(u, v)
// #define pparm(u)	pparmv(u)
// #else
// #define pset(u, v)	psetq(u, v)
// #define pparm(u)	pparmq(u)
// #endif

#define ALIAS_CONST(c) \
     ({ precision_t __tmp = NULL, __res=NULL; \
       __tmp :=: c; \
       __res = Core::alias_refptr(__tmp); \
       __tmp :=: c; \
       __res;})
     

#define pparm(u)	pparmv(u)
#define pset_mm(u, v) \
({ precision_t __rhs = (v); \
  precision_t __tmp = NULL; \
  __tmp :=: u; \ 
  u = Core::alias_refptr(__rhs); \
  pdestroy(__tmp);})

#define pset_m(u, v) \
({ precision_t __rhs = (v); \
  precision_t __tmp = u; \
  u = __rhs; \
  pdestroy(__tmp);})

#define pset_nc(u, v) \
({  precision_t __tmp = NULL; \
  __tmp = u; \ 
  u = Core::alias_refptr(v); \
  pdestroy(__tmp);})

#define pset_na(u, v) \
({ precision_t __rhs = (v); \
   precision_t __tmp = NULL; \
  __tmp = u; \ 
  u = __rhs; \
  pdestroy(__tmp); })

// #ifdef APROF
// #define palloc(n) \
//  ({ _ tmp = pallocf(n); \
//     { let alias<`r> precision_r_t<`r> tt = tmp;\
//  fprintf(stderr, "alloc : %s:%d\t0x%x\n", __FILE__, __LINE__, ((unsigned int)tt)-4);}\
//     tmp;})
// #else
// #define palloc(n) pallocf(n)
// #endif

#include "aprof.h"

#define pcopy(u) u

#ifdef __STDC__		/* if ANSI compiler */
extern void init_constants();
extern	precision_t 	pnew(precision_t);		/* initialization */

  //extern	precision_t 	pcopy(precision_r_t<`r,`q\T>);		/* initialization */
extern	void pdestroyf(precision_t) __attribute((consume(1)));		/* freeing */
void pdestroyaprof(precision u, char @f, int l) __attribute((consume(1)));
extern	precision_t 	presult(precision_t) __attribute((consume(1)));		/* function result */
//extern	precision	psetq(precision *, precision);	/* quick assignment */
//extern	precision	psetv(precision *, precision); /* checked assignment */
extern	precision_t	pparmv(precision_t);	/* checked parameter */
extern	precision_t	pparmf(precision_t);	/* unchecked parameter (fn) */

extern	int		pcmpz(precisiona_t);		/* compare to zero */
extern	int		pcmp(precisiona_t, precisiona_t);	/* compare */
extern	int		picmp(precisiona_t, int);	        /* single digit cmp */

extern	precision_t	padd(precisiona_t, precisiona_t);	/* add */
extern	precision_t	psub(precisiona_t, precisiona_t);	/* subtract */
extern	precision_t	pmul(precisiona_t, precisiona_t);// __attribute((consume(1),consume(2)));	/* multiply */

extern	precision_t	pdivmod(precisiona_t, precisiona_t, 
				enum __rq,
			        precisiona_t *q, precisiona_t *r);
extern	$(precision_t,precision_t)	pdivmod2(precisiona_t, precisiona_t)
  __attribute((consume(1), consume(2)));
//				enum __rq,
//			        precisiona_t *q, precisiona_t *r);

extern 	precision_t	pidiv(precisiona_t, int);		/* single digit pdiv */
extern 	int		pimod(precisiona_t, int);		/* single digit pmod */
extern 	void		pidivmod(precisiona_t, int, 	/* single pdivmod */
				 precisiona_t *q, int *r);

extern	precision_t	pneg(precisiona_t);		/* negate */
extern	precision_t	pabs(precisiona_t);		/* absolute value */
extern	int		podd(precisiona_t);		/* true if odd */
extern	precision_t	phalf(precisiona_t) __attribute((consume(1)));		/* divide by two */

extern	precisiona_t	pmin(precisiona_t, precisiona_t);	/* minimum value */
extern	precisiona_t	pmax(precisiona_t, precisiona_t);	/* maximum value */

extern	precision_t	prand(precisiona_t);	/* random number generator */

extern	precision_t	itop(int);		/* int to precision */
extern	precision_t	utop(unsigned);		/* unsigned to precision */
extern	precision_t	ltop(long);		/* long to precision */
extern	precision_t	ultop(unsigned long);	/* unsigned long to precision */

extern	int		ptoi(precisiona_t);	/* precision to int */
extern	unsigned int	ptou(precisiona_t);	/* precision to unsigned */
extern	long		ptol(precisiona_t);	/* precision to long */
extern	unsigned long	ptoul(precisiona_t);	/* precision to unsigned long */

extern	precision_t	atop(mstring_t);		/* ascii to precision */
extern	mstring_t ptoa(precisiona_t);	/* precision to ascii */

extern	int 		btop(precision *result, /* base to precision */
   char *src, unsigned size, int *digitmap, unsigned radix);

extern	int				/* precision to base */
   ptob(precision, char *result, unsigned size, char *alphabet, unsigned radix);

/*
 * Can't do prototyping for these unless stdio.h has been included 
 */
#ifdef BUFSIZ
extern	precision_t	fgetp(FILE *stream);	        /* input precision */
extern	int		fputp(FILE *stream, precisiona_t); /* output precision */
extern	int		
   fprintp(FILE *stream, precisiona_t, int minWidth); /* output within a field */
#else
extern	precision_t	fgetp();	        /* input precision */
extern	int		fputp(); 		/* output precision */
extern	int		fprintp(); 		/* output within a field */
#endif

extern	int		putp(precisiona_t);  	  /* stdout  with '\n' */

extern	void		pshow(precision);	  /* display debug info */
extern	precision	prandnum();		  /* debug and profil only */
extern	precision	pshift(precision, int);	  /* shift left */

extern	precision_t	errorp(int errnum, string_t routine, string_t message);

extern	precision	pzero, pone, ptwo;	  /* constants 0, 1, and 2 */
extern	precision	p_one;			  /* constant -1 */

extern	precision_t	pzerot, ponet, ptwot;	  /* constants 0, 1, and 2 */
extern	precision_t	p_onet;			  /* constant -1 */

extern	precision_t	psqrt(precisiona_t) __attribute((consume(1)));	     /* square root */
extern	precision_t	pfactorial(precisiona_t);	     /* factorial */
extern	precision_t	pipow(precisiona_t, unsigned);  /* unsigned int power */
extern	precision_t	ppow(precisiona_t, precisiona_t);  /* precision power */
extern	precision_t
   ppowmod(precisiona_t, precisiona_t, precisiona_t) __attribute((consume(1), consume(2)));	     /* precision power mod m */
extern	int		plogb(precision, precision); /* log base b of n */

extern	precision_t	dtop(double);		/* double to precision */
extern	double		ptod(precision);	/* precision to double */

/*
 * vector operations
 */
pvector pvundef(pvector, unsigned size);	/* local variable entry */
void    pvdestroy(pvector, unsigned size);	/* local variable exit */

pvector pvalloc(unsigned size);			/* pvec allocate */
void    pvfree(pvector, unsigned size);		/* pvec free */

pvector pvset(pvector, unsigned size, precision value);
#endif
