/*
 * Arbitrary precision integer math package
 * 
 * (c) Copyright 1991 by David A. Barrett (barrett@asgard.UUCP)
 *
 * Not to be used for profit or distributed in systems sold for profit
 */
#include <core.h>
#include <stdio.h>
#ifndef BASE
extern struct __precisionType<`r::R>;
typedef struct __precisionType<`r>*`r precision<`r>;	/* this a a private data structure */
typedef struct __precisionType<`r>*@aqual(`q) `r precisionq<`r,`q>;	/* this a a private data structure */
typedef struct __precisionType<`r>@`r precisionA<`r>;	/* this a a private data structure */
extern	int		pfree(precision);	/* free (private) */
#endif

typedef precision 	*pvector;	/* a vector of precision */
typedef pvector		*parray;	/* 2d array */

/*
 * Error values passed to errorp
 */
#define PNOERROR	0
#define PNOMEM		1
#define PREFCOUNT	2
#define PUNDEFINED	3
#define PDOMAIN		4
#define POVERFLOW	5

#define pUndef		((precision) 0)		/* An undefined value */
#define pNull		((precision *) 0)

#define peq(u, v)	(pcmp((u), (v)) == 0)
#define pne(u, v)	(pcmp((u), (v)) != 0)
#define pgt(u, v)	(pcmp((u), (v)) >  0)
#define plt(u, v)	(pcmp((u), (v)) <  0)
#define pge(u, v)	(pcmp((u), (v)) >= 0)
#define ple(u, v)	(pcmp((u), (v)) <= 0)

#define peqz(u)		(pcmpz(u) == 0)
#define pnez(u)		(pcmpz(u) != 0)
#define pltz(u)		(pcmpz(u) <  0)
#define pgtz(u)		(pcmpz(u) >  0)
#define plez(u)		(pcmpz(u) <= 0)
#define pgez(u)		(pcmpz(u) >= 0)

enum __rq {REM,QUOT,NONE};
#define peven(u)	(!podd(u))
#define pdiv(rgn,u,v)	(pdivmod(rgn, u,v, QUOT, pNull, pNull))
#define pmod(rgn,u,v)	(pdivmod(rgn, u,v, REM,  pNull, pNull))
#define pdivr(rgn,u,v,r)(pdivmod(rgn, u,v, QUOT, pNull, r))
#define pmodq(rgn,u,v,q)(pdivmod(rgn, u,v, REM,  q,     pNull))

/*
 * Application programs should only use the following definitions;
 *
 *    pnew, pdestroy, pparm, presult and pset
 *
 * Other variants are internal only!  
 * All are side-effect safe except for pparm and presult.
 * -DDEBUG will enable argument checking for pset and pparm
 */
#ifdef __GNUC__		/* inline is NOT ansii!  Sigh. */
#ifndef BWGC
extern inline precision pnew(precision u) { (* (prefc *) u)++; return u; }
extern inline void      pdestroy(precision u) {
  if (u != pUndef && --(*(prefc *) u) == 0) pfree(u);
}
extern inline precision pparmq(precision u) { 
  if (u != pUndef) (* (prefc *) u)++; return u;
}
extern inline precision presult(precision u) {
  if (u != pUndef) --(*(prefc *) u); return u;
}
extern inline precision psetq(precision *up, precision v) {
   precision u = *up;
   *up = v;
   if (v != pUndef) (* (prefc *) v)++;
   if (u != pUndef && --(* (prefc *) u) == 0) pfree(u);
   return v;
}
#define pvoid(u)	pdestroy(u)
#else
extern inline precision<`r> pnew(precision<`r> u) { return u; }
extern precisionq<`r1,`q> pqcopy(region_t<`r1> r, aqual_t<`q\T> q, precision<`r> u); 
extern inline void      pdestroy(precision<`r> u) {}
extern inline precision<`r> pparmq(precision<`r> u) { return u; }
extern inline precision<`r> presult(precision<`r> u) { return u; }
extern inline precision<`r> psetq(precision<`r> @up, precision<`r> v) {
   precision u = *up;
   *up = v;
   return v;
}
#define pvoid(u)	pdestroy(u)
#endif
#else
#ifndef BWGC
#define pdestroy(u)     (void) ((u)!=pUndef&&--(*(prefc *)(u))==0&&pfree(u))
#define pparmq(u)	((u) != pUndef && (* (prefc *) (u))++, (u))
#define pvoid(u)	pdestroyf(u)
#else
#define pdestroy(u)     (void) (0)
#define pparmq(u)	(u)
#define pvoid(u)	pdestroyf(u)
#endif
#endif


#ifdef PDEBUG
#define pset(u, v)	psetv(u, v)
#define pparm(u)	pparmv(u)
#else
#define pset(u, v)	psetq(u, v)
#define pparm(u)	pparmq(u)
#endif

#ifdef __STDC__		/* if ANSI compiler */
#ifndef __GNUC__
extern	precision<`r> 	pnew(precision<`r>);		/* initialization */
extern	precision<`r> 	presult(precision<`r>);		/* function result */
extern	precision<`r>	psetq(precision<`r> @, precision<`r>);	/* quick assignment */
#endif
extern	precision<`r>	psetv(precision<`r> @, precision<`r>); /* checked assignment */
extern	precision<`r>	pparmv(precision<`r>);	/* checked parameter */
extern	precision<`r>	pparmf(precision<`r>);	/* unchecked parameter (fn) */

extern	int		pcmpz(precisionA);		/* compare to zero */
extern	int		pcmp(precisionA, precisionA);	/* compare */
extern	int		picmp(precisionA, int);	        /* single digit cmp */

//precisionA<`r> padd(region_t<`r> r, struct __precisionType<`r1> *`r1 u, 
//		    struct __precisionType<`r2> *`r2 v) ;
extern	precisionA<`r>	padd(region_t<`r>,precisionA,precisionA);//add
extern	precisionA<`r>	psub(region_t<`r>,precisionA,precisionA);//sub
extern	precisionA<`r>	pmul(region_t<`r>,precisionA,precisionA);//mul

extern	precision<`r>	pdivmod(region_t<`r>, precision<`r>, precision<`r>, 
				enum __rq,
			        precision<`r> *q, precision<`r> *r);

extern 	precision<`r>	pidiv(region_t<`r>,precisionA, int);		/* single digit pdiv */
extern 	int		pimod(precisionA, int);		/* single digit pmod */
extern 	void		pidivmod(precision, int, 	/* single pdivmod */
				 precision *q, int *r);

extern	precisionA<`r>	pneg(region_t<`r>, precisionA);	  /* negate */
extern	precisionA<`r>  pabs(region_t<`r>,precisionA);/* absolute value */
extern	int		podd(precisionA);		/* true if odd */
extern	precision<`r>	phalf(region_t<`r>, precision<`r>);/* divide by two */

extern	precision	pmin(precision, precision);	/* minimum value */
extern	precision	pmax(precision, precision);	/* maximum value */

extern	precision	prand(precision);	/* random number generator */

extern	precision<`r>	itop(region_t<`r>,int);	     /* int to precision */
extern	precision<`r>	utop(region_t<`r>,unsigned); /* unsigned to precision */
extern	precision	ltop(long);		/* long to precision */
extern	precision	ultop(unsigned long);	/* unsigned long to precision */

extern	int		ptoi(precision);	/* precision to int */
extern	unsigned int	ptou(precision);	/* precision to unsigned */
extern	long		ptol(precision);	/* precision to long */
extern	unsigned long	ptoul(precision);	/* precision to unsigned long */

extern	precision	atop(mstring_t);		/* ascii to precision */
extern	mstring_t ptoa(precision);	/* precision to ascii */

extern	int 		btop(precision *result, /* base to precision */
   char *src, unsigned size, int *digitmap, unsigned radix);

extern	int				/* precision to base */
   ptob(precision, char *result, unsigned size, char *alphabet, unsigned radix);

/*
 * Can't do prototyping for these unless stdio.h has been included 
 */
#ifdef BUFSIZ
extern	precision	fgetp(FILE *stream);	        /* input precision */
extern	int		fputp(FILE *stream, precision<`r>); /* output precision */
extern	int		
   fprintp(FILE *stream, precision<`r>, int minWidth); /* output within a field */
#else
extern	precision	fgetp();	        /* input precision */
extern	int		fputp(); 		/* output precision */
extern	int		fprintp(); 		/* output within a field */
#endif

extern	int		putp(precision<`H>);  	  /* stdout  with '\n' */

extern	void		pshow(precision);	  /* display debug info */
extern	precision	prandnum();		  /* debug and profil only */
extern	precision	pshift(precision, int);	  /* shift left */

extern	precision	errorp(int errnum, string_t routine, string_t message);

extern	precision	pzero, pone, ptwo;	  /* constants 0, 1, and 2 */
extern	precision	p_one;			  /* constant -1 */

extern	precision<`r>	psqrt(region_t<`r>, precision<`r>); /* square root */
extern	precision	pfactorial(precision);	     /* factorial */
extern	precision	pipow(precision, unsigned);  /* unsigned int power */
extern	precision	ppow(precision, precision);  /* precision power */
extern	precision<`r>  /* precision power mod m */
   ppowmod(region_t<`r>, precision<`r>, precision<`r>, precision<`r>);
extern	int		plogb(precision, precision); /* log base b of n */

extern	precision<`r>	dtop(region_t<`r>,double);/* double to precision */
extern	double		ptod(precision);	/* precision to double */

/*
 * vector operations
 */
pvector pvundef(pvector, unsigned size);	/* local variable entry */
void    pvdestroy(pvector, unsigned size);	/* local variable exit */

pvector pvalloc(unsigned size);			/* pvec allocate */
void    pvfree(pvector, unsigned size);		/* pvec free */

pvector pvset(pvector, unsigned size, precision value);

#else

/*
 * Function versions of above if you still want side effects
 */

#ifndef __GNUC__
extern	precision 	pnew();		/* initialization */
extern	precision 	presult();	/* function result */
extern	precision	psetq();	/* quick assignment */
#endif
extern	precision	psetv(); 	/* checked assignment */
extern	precision	pparmv();	/* checked parameter */
extern	precision	pparmf();	/* unchecked parameter (fn) */

extern	int		pcmpz();	/* compare to zero */
extern	int		pcmp();		/* compare */
extern	int		picmp();	/* single digit compare */

extern	precision	padd();		/* add */
extern	precision	psub();		/* subtract */
extern	precision	pmul();		/* multiply */

extern	precision	pdivmod();	/* divide/remainder */
extern 	void		pidivmod();	/* single digit divide/remainder */
extern 	precision	pidiv();	/* single digit divide */
extern 	int		pimod();	/* single digit remainder */
extern	precision	pneg();		/* negate */
extern	precision	pabs();		/* absolute value */
extern	int		podd();		/* true if odd */
extern	precision	phalf();	/* divide by two */

extern	precision	pmin();		/* minimum value */
extern	precision	pmax();		/* maximum value */

extern	precision	prand();	/* random number generator */

extern	precision	itop();		/* int to precision */
extern	precision	utop();		/* unsigned to precision */
extern	precision	ltop();		/* long to precision */
extern	precision	ultop();	/* unsigned long to precision */

extern	int		ptoi();		/* precision to int */
extern	unsigned int	ptou();		/* precision to unsigned */
extern	long		ptol();		/* precision to long */
extern	unsigned long	ptoul();	/* precision to unsigned long */

extern	precision	atop();		/* ascii to precision */
extern	char		*ptoa();	/* precision to ascii */

extern	int		btop();		/* base to precision */
extern	int		ptob();		/* precision to base */

extern	precision	fgetp();	/* input a precision */
extern	int		fputp();	/* output a precision */
extern	int		putp();		/* output precision '\n' to stdout */
extern	int		fprintp();	/* output a precision within a field */

extern	void		pshow();	/* display debug info */
extern	precision	prandnum();	/* for debug and profil only */
extern	precision	pshift();	/* shift left */

extern	precision	errorp(int errnum, string_t routine, string_t message);

extern	precision	pzero, pone, ptwo;	/* constants 0, 1, and 2 */
extern	precision	p_one;			/* constant -1 */

extern	precision	psqrt();	/* square root */
extern	precision	pfactorial();	/* factorial */
extern	precision	pipow();	/* unsigned int power */
extern	precision	ppow();		/* precision power */
extern	precision	ppowmod();	/* precision power mod m */
extern	int		plogb();	/* log base b of n */

extern	precision	dtop();		/* double to precision */
extern	double		ptod();		/* precision to double */

/*
 * vector operations
 */
pvector pvundef();			/* local variable entry */
void    pvdestroy();			/* local variable exit */
pvector pvalloc();			/* pvec allocate */
void    pvfree();			/* pvec free */
pvector pvset();			/* set each element to scaler */

#endif
