/* 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;  File: convolve.h
;;;  Author: Simoncelli
;;;  Description: Header file for convolve.c
;;;  Creation Date:
;;;  ----------------------------------------------------------------
;;;    Object-Based Vision and Image Understanding System (OBVIUS),
;;;      Copyright 1988, Vision Science Group,  Media Laboratory,  
;;;              Massachusetts Institute of Technology.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
*/

#define abs(x)	  (x>=0 ? x : -(x))
#define ROOT2 1.4142135623730951
#define FILTER 0
#define EXPAND 1
#define IS    ==
#define ISNT  !=
#define AND &&
#define OR ||

typedef  int (*fptr)();

typedef struct 
  {
  char *name;
  fptr func;
  } EDGE_HANDLER;

fptr edge_function(char *edges);
int internal_filter(register float *image, register int x_dim, int y_dim, float *filt, register float *temp, register int x_fdim, int y_fdim, int xgrid_start, register int xgrid_step, int ygrid_start, int ygrid_step, register float *result, char *edges), internal_expand(register float *image, float *filt, register float *temp, register int x_fdim, int y_fdim, int xgrid_start, register int xgrid_step, int ygrid_start, int ygrid_step, register float *result, register int x_dim, int y_dim, char *edges);


/* Local Variables: */
/* buffer-read-only: t */
/* End: */
