/* 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;  File: convolve.h
;;;  Author: Simoncelli
;;;  Description: Header file for convolve.c
;;;  Creation Date:
;;;  ----------------------------------------------------------------
;;;    Object-Based Vision and Image Understanding System (OBVIUS),
;;;      Copyright 1988, Vision Science Group,  Media Laboratory,  
;;;              Massachusetts Institute of Technology.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
*/

#define abs(x)	  (x>=0 ? x : -(x))
#define ROOT2 1.4142135623730951
#define FILTER 0
#define EXPAND 1
#define IS    ==
#define ISNT  !=
#define AND &&
#define OR ||

typedef int (*fptr)<`r,`r2>(float ?`r filt, int x_dim, int y_dim, int x_pos, int y_pos, float ?`r2 result, int f_or_e);

typedef struct edge_handler
  {
  const char @name;
  fptr func;
  } EDGE_HANDLER;

fptr edge_function(const char @edges);
int internal_filter (float ?image, int x_dim, int y_dim, float ?filt, float ?temp, int x_fdim, int y_fdim, int xgrid_start, int xgrid_step, int ygrid_start, int ygrid_step, float ?result, const char @edges), internal_expand(float ?image, float ?filt, float ?temp, int x_fdim, int y_fdim, int xgrid_start, int xgrid_step, int ygrid_start, int ygrid_step, float ?result, int x_dim, int y_dim, const char @edges);


/* Local Variables: */
/* buffer-read-only: t */
/* End: */
