#include <stdio.h>
#include <stdlib.h>

#define MATXSIZE 300
typedef double** matx_t;

// a = mn
void matxmult(int sz, matx_t a, matx_t m, matx_t n) {
  int i,j,k;
  for(i = 0; i < sz; i++) {
    for(j = 0; j < sz; j++) {
      for(k = 0; k < sz; k++) {
	a[i][j] += m[i][k] * n[k][j];
      }
    }
  }
}

void mkmatx(int sz, matx_t x) {
  int i,j;
  for(i = 0; i < sz; i++) {
    for(j = 0; j < sz; j++) {
      x[i][j] = rand();
    }
  }
}

matx_t initmatx(int sz) {
  int i,j;
  matx_t ptr = (matx_t)malloc(sizeof(double*)*sz);
  for(i = 0; i < sz; i++) {
    ptr[i] = (double*)malloc(sizeof(double)*sz);
    for(j = 0; j < sz; j++) {
      ptr[i][j] = (double)0.0;
    }
  }
  return ptr;
}

int main(int argc, char** argv) {
  int i;
  int sz = MATXSIZE;
  matx_t x, y, a;
  x = initmatx(sz);
  y = initmatx(sz);
  a = initmatx(sz);

  if(argc < 2)  {
    fprintf(stderr, "usage: matxmult seed\n");
    return 0;
  }
  printf("Seed %d\n", atoi(argv[1]));
  srand(atoi(argv[1]));
  mkmatx(sz,x);
  mkmatx(sz,y);
  matxmult(sz,a,x,y);
  return 0;
}
