
module DRuby
  module Contract
    class ContractViolation < Exception
    end

    class Origin
      def initialize(file,line)
        @file = file
        @line = line
      end

      def violation(msg)
        fname = File.basename(@file)
        hdr = "Unsafe code from #{fname}:#{@line} caused the following error\n"
        raise ContractViolation.new(hdr+msg)
        #exit(1)
      end
      
      def to_s
        "In file #{@file}, line #{@line}"
      end
    end
  end
end
