#include <intercomm.h>
#include <mpi.h>
#include <stdio.h>

IC_Desc* create_bdecomp(int p, int r, float A[5][5][5]) {
  int blocks[8][2][3];
  int tasks[8];  
  int i, j, k;
  IC_Desc* desc;
  
  for (i = 0; i < 2; ++i) {
    for (j = 0; j < 2; ++j) {
      for (k = 0; k < 2; ++k) {
	blocks[4*i+2*j+k][0][0] = i*5;
	blocks[4*i+2*j+k][1][0] = i*5 + 5 - 1;
	blocks[4*i+2*j+k][0][1] = j*5;
	blocks[4*i+2*j+k][1][1] = j*5 + 5 - 1;
	blocks[4*i+2*j+k][0][2] = k*5;
	blocks[4*i+2*j+k][1][2] = k*5 + 5 - 1;
      }
    }
  }
  
  for (i = 0; i < 8; ++i)
    tasks[i] = i;
  
  desc = IC_Create_bdecomp_desc(3, &blocks[0][0][0], tasks, 8);
  
  for (i = 0; i < 5; ++i) {
    for (j = 0; j < 5; ++j) {
      for (k = 0; k < 5; ++k) {
	A[i][j][k] = 1000*r + 100*i + 10*j + k;
      }
    }
  }
  
  return desc;
}


int main(int argc, char* argv[]) {
  char* localname = "fexample";
  char* othername = "cexample";
  int local_tasks = 8;
  int other_tasks = 4;
  int i, rank;

  MPI_Comm groupcomm;

  IC_Program* local;
  IC_Program* other;
  
  IC_Desc* desc;
  float A[5][5][5];
  
  IC_Region* region_set[2];
  int lower[3], upper[3], stride[3];
  IC_Sched* sched;
  int tag = 99;
  
  /* initialize mpi */
  printf("initialize mpi\n");
  MPI_Init(&argc, &argv);
  MPI_Comm_dup(MPI_COMM_WORLD, &groupcomm);
  MPI_Comm_rank(groupcomm, &rank);
  MPI_Barrier(groupcomm);

  /* initialize ic */
  printf("initialize ic\n");
  local = IC_Init(localname, local_tasks, rank);
  other = IC_Wait(othername, other_tasks);
  IC_Sync(local, other);
  
  desc = create_bdecomp(local_tasks, rank, A);

  printf("define regions\n");
  for (i = 0; i < 3; ++i) {
    lower[i] = 0;
    upper[i] = 1;
    stride[i] = 1;
  }
  region_set[0] = IC_Create_block_region(3, lower, upper, stride);
  for (i = 0; i < 3; ++i) {
    lower[i] = 5;
    upper[i] = 6;
    stride[i] = 1;
  }
  region_set[1] = IC_Create_block_region(3, lower, upper, stride);
  
  printf("create schedule\n");
  sched = IC_Compute_schedule(local, other, desc, region_set, 2);
  printf("receive data\n");
  IC_Recv_float(other, sched, &A[0][0][0], tag);
  IC_Sync(local, other);
  IC_Free_sched(sched);
  
  /* clean up */
  printf("clean up\n");
  IC_Free_region(region_set[1]);
  IC_Free_region(region_set[0]);

  IC_Free_desc(desc);

  IC_Free_program(other);
  IC_Quit(local);

  MPI_Barrier(groupcomm);
  MPI_Comm_free(&groupcomm);
  MPI_Finalize();

  return 0;
}
