/*
 * File: compute_schedule.h
 * Auth: Jae-Yong Lee (jylee@cs.umd.edu)
 *       University of Maryland, College Park
 * Desc: Computing schedules 
 * Date: Feb. 2004
 */

#ifndef COMPUTE_SCHEDULE_H
#define COMPUTE_SCHEDULE_H

#include "pgme.h"
#include "region.h"
#include "schedule.h"
#include "global.h"

typedef enum {
  Sender,
  Receiver
} WhatAmI;

#define First Sender
#define Second Receiver

/* 
   Currently not used types.
*/  
   
/*
typedef enum {
  ComputeOnSender,      
  ComputeOnReceiver,
  ComputeOnBothSide     
} WhereToCompute;

typedef enum {
  OptComm,               
  DoNotOptComm
} T_OptimiseComm;


typedef enum {
  Regular,    
  Irregular   
} DADType;

typedef enum {
  BothSides,   
  OneSideMe,   
  OneSideOther 
} WhereToCompute2;

typedef enum {
  ForActualOwnedData,
  ForDataInTable
} WhatComputed;

*/
  
typedef enum {
  SendOneToOne, /* Just one node sends the info(DAD and a set of regions)
                   to just one node on the other side.
                   And then the receiving node broadcasts the info over all nodes. */  
  SendAllToAll  /* All nodes participate in sending and receiving the info.*/
} HowToSendDAD;


typedef enum {
  SendBackAll, /* All-To-All Send back */
  SendBackPart /* One-To-One Send-Back */
} SendBackMethod;



/* Compute schedule function for Compact to Compact */

sched_s* ComputeSchedule_Two_Compacts(HowToSendDAD howsend, 
				      void *datadescriptor, 
				      setOfRegion_s *ar_Set, 
				      pgme_s *my_pgme,
				      pgme_s *other_pgme);

sched_s* ComputeScheduleOnMe_Two_Compacts(HowToSendDAD howsend,
					  void *datadescriptor,
					  setOfRegion_s *ar_Set,
					  pgme_s *my_pgme,
					  pgme_s *other_pgme);

sched_s* ComputeScheduleOnOther_Two_Compacts(HowToSendDAD howsend,
					     void *datadescriptor,
					     setOfRegion_s *ar_Set,
					     pgme_s *my_pgme,
					     pgme_s *other_pgme);

/* Compute schedule function for Compact to Non-Compact */


sched_s* ComputeScheduleOnNonCompact_Mixed(HowToSendDAD howsend,
					   SendBackMethod sendback,
					   void *datadescriptor,
					   setOfRegion_s *ar_Set,
					   pgme_s *my_pgme,
					   pgme_s *other_pgme);

sched_s* ComputeScheduleOnCompact_Mixed(HowToSendDAD howsend,
					SendBackMethod sendback,
					void *datadescriptor,
					setOfRegion_s *ar_Set,
					pgme_s *my_pgme,
					pgme_s *other_pgme);

sched_s* ComputeScheduleOnNonCompact_Mixed_Both(HowToSendDAD howsend,
						void *datadescriptor,
						setOfRegion_s *ar_Set,
						pgme_s *my_pgme,
						pgme_s *other_pgme);

sched_s* ComputeScheduleOnCompact_Mixed_Both(HowToSendDAD howsend,
					     void *datadescriptor,
					     setOfRegion_s *ar_Set,
					     pgme_s *my_pgme,
					     pgme_s *other_pgme);

/*
 * Compute schedule function for Non-Compact to Non-Compact
 * For now, just one implementation. 
 * All processors on both sides compute schedules. 
 */
sched_s* ComputeScheduleFor_Two_NonCompacts(WhatAmI resp,
					    void *datadescriptor,
					    setOfRegion_s *ar_Set,
					    pgme_s *my_pgme,
					    pgme_s *other_pgme);

#endif /* COMPUTE_SCHEDULE_H */
