/*
 * File: chaos2ttable.c
 * Auth: Jae-Yong Lee (jylee@cs.umd.edu)
 *       University of Maryland, College Park
 * Desc: 
 * Date: 
 */

#include "chaos2ttable.h"
#include "parti.h"


IC_Desc* IC_Translate_chaos_descriptor(TTABLE* ttable) {
  IC_Desc* desc;
  int size;

  desc = (IC_Desc*)malloc(sizeof(IC_Desc));
  desc->type = IC_TTABLE;
  size = ttable->tabptr->pageSize*ttable->tabptr->numPages*PARTI_numnodes;
  desc->spec = translate_ttable(ttable, PARTI_numnodes, PARTI_mynode, size);
  
  return desc;
}

simple_ttable* translate_ttable(TTABLE *CH_ttable, int num_procs, int me, int size)
{
  int nData;
  int low, high;
  int i, index;
  simple_ttable* table;

  if (CH_ttable == 0 || CH_ttable->tabptr == 0) {
    error("invalid Chaos descriptor");
  }
  /*
  if (me == 0) {
    low = 1;
    high = CH_ttable->tabptr->pageSize-1;   
    nData = CH_ttable->tabptr->pageSize-1;   
  }
  else
  */

  if (CH_ttable->tabptr->pageSize*(me+1)/*+(CH_ttable->tabptr->pageSize-1)*/ <= size) {
    nData = CH_ttable->tabptr->pageSize;   
    low = CH_ttable->tabptr->pageSize*me;
    high = CH_ttable->tabptr->pageSize*me+(CH_ttable->tabptr->pageSize-1);
  }
  else { 
    nData = size - (CH_ttable->tabptr->pageSize*(me/*-1*/)/*+(CH_ttable->tabptr->pageSize-1)*/);
    low = CH_ttable->tabptr->pageSize*me;
    high = CH_ttable->tabptr->pageSize*me+(CH_ttable->tabptr->pageSize-1)+nData;
  }
  /*
    else { 
    printf("Error: in translate simple table\n");
    nData = 0;
    low = -1;
    high = -1;
    }
  */
 
  table = Allocate_Simple_TTABLE(nData);
  
  for (i = 0; i < nData; i++)
    {
      if (me == 0)
	table->global_index[i] = i/*+1*/;
      else 
	table->global_index[i] = CH_ttable->tabptr->pageSize*me/*-1*/+i/*+1*/;       
    }
  /* 
     if (me == 0) 
     index = 1;
     else 
  */
  index = 0;
  
  if (CH_ttable->tabptr->pageTable[me] == 0) {
    error("missing page table in Chaos descriptor");
  }
  
  for(i = 0; i < nData; i++, index++)
    {
      table->proc_num[i] = CH_ttable->tabptr->pageTable[me]->Proc[index];    
      table->local_offset[i] = CH_ttable->tabptr->pageTable[me]->Offset[index];    
    }
  
  table->nData = nData;
  table->global_low_bound = low;
  table->global_high_bound = high;
  
  return table;
}
