#include <stdarg.h>
#include <assert.h>
#include <stdlib.h>
#include <stdio.h>
#include "carray_descriptor.h"

#define CREATECHARARRAYDESC_F77 F77_FUNC_(createchararraydesc, CREATECHARARRAYDESC)
#define CREATESHORTARRAYDESC_F77 F77_FUNC_(createshortarraydesc, CREATESHORTARRAYDESC)
#define CREATEINTARRAYDESC_F77 F77_FUNC_(createintarraydesc, CREATEINTARRAYDESC)
#define CREATEFLOATARRAYDESC_F77    F77_FUNC_(createfloatarraydesc, CREATEFLOATARRAYDESC)
#define CREATEDOUBLEARRAYDESC_F77  F77_FUNC_(createdoublearraydesc, CREATEDOUBLEARRAYDESC)

#define DESTROYCHARARRAYDESC_F77 F77_FUNC_(destroychararraydesc, DESTROYCHARARRAYDESC)
#define DESTROYSHORTARRAYDESC_F77 F77_FUNC_(destroyshortarraydesc, DESTROYSHORTARAYDESC)
#define DESTROYINTARRAYDESC_F77 F77_FUNC_(destroyintarraydesc, DESTROYINTARRAYDESC)
#define DESTROYFLOATARRAYDESC_F77    F77_FUNC_(destroyfloatarraydesc, DESTROYFLOATARRAYDESC)
#define DESTROYDOUBLEARRAYDESC_F77  F77_FUNC_(destroydoublearraydesc, DESTROYDOUBLEARRAYDESC)

extern "C" {

void PRINTCHARARRAY_F77(const F90_charArray** A) {
  int i, j, k, l;

  assert((*A) != NULL);

  switch ((*A)->rank) {
  case 1:
    for (i = 0; i < (*A)->shape[0]; ++i) {
      fprintf(stdout, "%c ", *((*A)->base+(*A)->stride[0]*i));
    }
    fprintf(stdout, "\n");
    break;
  case 2:
    for (i = 0; i < (*A)->shape[0]; ++i) {
      for (j = 0; j < (*A)->shape[1]; ++j) {
	fprintf(stdout, "%c ", *((*A)->base+(*A)->stride[1]*i+(*A)->stride[0]*j));
      }
      fprintf(stdout, "\n");
    }
    break;
  case 3:
    for (i = 0; i < (*A)->shape[0]; ++i) {
      for (j = 0; j < (*A)->shape[1]; ++j) {
	for (k = 0; k < (*A)->shape[2]; ++k) {
	  fprintf(stdout, "%c ", *((*A)->base+(*A)->stride[2]*i+(*A)->stride[1]*j+(*A)->stride[0]*k));
	}
	fprintf(stdout, "\n");
      }
      fprintf(stdout, "\n");
    }    
    break;
  case 4:
    for (i = 0; i < (*A)->shape[0]; ++i) {
      for (j = 0; j < (*A)->shape[1]; ++j) {
	for (k = 0; k < (*A)->shape[2]; ++k) {
	  for (l = 0; l < (*A)->shape[3]; ++l) {
            fprintf(stdout, "%c ", *((*A)->base+(*A)->stride[3]*i+(*A)->stride[2]*j+(*A)->stride[1]*k+(*A)->stride[0]*l));
          }
	  fprintf(stdout, "\n");
	}
	fprintf(stdout, "\n");
      }
      fprintf(stdout, "\n");
    }    
    break;
  default:
    fprintf(stderr,"InterComm printing function cannot handle this many dimensions\n");
  }
}

void PRINTSHORTARRAY_F77(const F90_shortArray** A) {
  int i, j, k, l;

  assert((*A) != NULL);

  switch ((*A)->rank) {
  case 1:
    for (i = 0; i < (*A)->shape[0]; ++i) {
      fprintf(stdout, "%7d", *((*A)->base+(*A)->stride[0]*i));
    }
    fprintf(stdout, "\n");
    break;
  case 2:
    for (i = 0; i < (*A)->shape[0]; ++i) {
      for (j = 0; j < (*A)->shape[1]; ++j) {
	fprintf(stdout, "%7d", *((*A)->base+(*A)->stride[1]*i+(*A)->stride[0]*j));
      }
      fprintf(stdout, "\n");
    }
    break;
  case 3:
    for (i = 0; i < (*A)->shape[0]; ++i) {
      for (j = 0; j < (*A)->shape[1]; ++j) {
	for (k = 0; k < (*A)->shape[2]; ++k) {
	  fprintf(stdout, "%7d", *((*A)->base+(*A)->stride[2]*i+(*A)->stride[1]*j+(*A)->stride[0]*k));
	}
	fprintf(stdout, "\n");
      }
      fprintf(stdout, "\n");
    }    
    break;
  case 4:
    for (i = 0; i < (*A)->shape[0]; ++i) {
      for (j = 0; j < (*A)->shape[1]; ++j) {
	for (k = 0; k < (*A)->shape[2]; ++k) {
	  for (l = 0; l < (*A)->shape[3]; ++l) {
            fprintf(stdout, "%7d", *((*A)->base+(*A)->stride[3]*i+(*A)->stride[2]*j+(*A)->stride[1]*k+(*A)->stride[0]*l));
          }
	  fprintf(stdout, "\n");
	}
	fprintf(stdout, "\n");
      }
      fprintf(stdout, "\n");
    }    
    break;
  default:
    fprintf(stderr,"InterComm printing function cannot handle this many dimensions\n");
  }
}

void PRINTINTARRAY_F77(const F90_intArray** A) {
  int i, j, k, l;

  assert((*A) != NULL);

  switch ((*A)->rank) {
  case 1:
    for (i = 0; i < (*A)->shape[0]; ++i) {
      fprintf(stdout, "%7d", *((*A)->base+(*A)->stride[0]*i));
    }
    fprintf(stdout, "\n");
    break;
  case 2:
    for (i = 0; i < (*A)->shape[0]; ++i) {
      for (j = 0; j < (*A)->shape[1]; ++j) {
	fprintf(stdout, "%7d", *((*A)->base+(*A)->stride[1]*i+(*A)->stride[0]*j));
      }
      fprintf(stdout, "\n");
    }
    break;
  case 3:
    for (i = 0; i < (*A)->shape[0]; ++i) {
      for (j = 0; j < (*A)->shape[1]; ++j) {
	for (k = 0; k < (*A)->shape[2]; ++k) {
	  fprintf(stdout, "%7d", *((*A)->base+(*A)->stride[2]*i+(*A)->stride[1]*j+(*A)->stride[0]*k));
	}
	fprintf(stdout, "\n");
      }
      fprintf(stdout, "\n");
    }    
    break;
  case 4:
    for (i = 0; i < (*A)->shape[0]; ++i) {
      for (j = 0; j < (*A)->shape[1]; ++j) {
	for (k = 0; k < (*A)->shape[2]; ++k) {
	  for (l = 0; l < (*A)->shape[3]; ++l) {
            fprintf(stdout, "%7d", *((*A)->base+(*A)->stride[3]*i+(*A)->stride[2]*j+(*A)->stride[1]*k+(*A)->stride[0]*l));
          }
	  fprintf(stdout, "\n");
	}
	fprintf(stdout, "\n");
      }
      fprintf(stdout, "\n");
    }    
    break;
  default:
    fprintf(stderr,"InterComm printing function cannot handle this many dimensions\n");
  }
}

void PRINTFLOATARRAY_F77(const F90_floatArray** A) {
  int i, j, k, l;

  assert((*A) != NULL);

  switch ((*A)->rank) {
  case 1:
    for (i = 0; i < (*A)->shape[0]; ++i) {
      fprintf(stdout, "%7.1f", *((*A)->base+(*A)->stride[0]*i));
    }
    fprintf(stdout, "\n");
    break;
  case 2:
    for (i = 0; i < (*A)->shape[0]; ++i) {
      for (j = 0; j < (*A)->shape[1]; ++j) {
	fprintf(stdout, "%7.1f", *((*A)->base+(*A)->stride[1]*i+(*A)->stride[0]*j));
      }
      fprintf(stdout, "\n");
    }
    break;
  case 3:
    for (i = 0; i < (*A)->shape[0]; ++i) {
      for (j = 0; j < (*A)->shape[1]; ++j) {
	for (k = 0; k < (*A)->shape[2]; ++k) {
	  fprintf(stdout, "%7.1f", *((*A)->base+(*A)->stride[2]*i+(*A)->stride[1]*j+(*A)->stride[0]*k));
	}
	fprintf(stdout, "\n");
      }
      fprintf(stdout, "\n");
    }    
    break;
  case 4:
    for (i = 0; i < (*A)->shape[0]; ++i) {
      for (j = 0; j < (*A)->shape[1]; ++j) {
	for (k = 0; k < (*A)->shape[2]; ++k) {
	  for (l = 0; l < (*A)->shape[3]; ++l) {
            fprintf(stdout, "%7.1f", *((*A)->base+(*A)->stride[3]*i+(*A)->stride[2]*j+(*A)->stride[1]*k+(*A)->stride[0]*l));
          }
	  fprintf(stdout, "\n");
	}
	fprintf(stdout, "\n");
      }
      fprintf(stdout, "\n");
    }    
    break;
  default:
    fprintf(stderr,"InterComm printing function cannot handle this many dimensions\n");
  }
}

void PRINTDOUBLEARRAY_F77(const F90_doubleArray** A) {
  int i, j, k, l;

  assert((*A) != NULL);

  switch ((*A)->rank) {
  case 1:
    for (i = 0; i < (*A)->shape[0]; ++i) {
      fprintf(stdout, "%7.1f", *((*A)->base+(*A)->stride[0]*i));
    }
    fprintf(stdout, "\n");
    break;
  case 2:
    for (i = 0; i < (*A)->shape[0]; ++i) {
      for (j = 0; j < (*A)->shape[1]; ++j) {
	fprintf(stdout, "%7.1f", *((*A)->base+(*A)->stride[1]*i+(*A)->stride[0]*j));
      }
      fprintf(stdout, "\n");
    }
    break;
  case 3:
    for (i = 0; i < (*A)->shape[0]; ++i) {
      for (j = 0; j < (*A)->shape[1]; ++j) {
	for (k = 0; k < (*A)->shape[2]; ++k) {
	  fprintf(stdout, "%7.1f", *((*A)->base+(*A)->stride[2]*i+(*A)->stride[1]*j+(*A)->stride[0]*k));
	}
	fprintf(stdout, "\n");
      }
      fprintf(stdout, "\n");
    }    
    break;
  case 4:
    for (i = 0; i < (*A)->shape[0]; ++i) {
      for (j = 0; j < (*A)->shape[1]; ++j) {
	for (k = 0; k < (*A)->shape[2]; ++k) {
	  for (l = 0; l < (*A)->shape[3]; ++l) {
            fprintf(stdout, "%7.1f", *((*A)->base+(*A)->stride[3]*i+(*A)->stride[2]*j+(*A)->stride[1]*k+(*A)->stride[0]*l));
          }
	  fprintf(stdout, "\n");
	}
	fprintf(stdout, "\n");
      }
      fprintf(stdout, "\n");
    }    
    break;
  default:
    fprintf(stderr,"InterComm printing function cannot handle this many dimensions\n");
  }
}

void CREATECHARARRAYDESC_F77(F90_charArray** A, int* ndims, ...) {
  int d;
  va_list ap; 

  assert(static_cast<unsigned>(*ndims) <= IC_MAX_DIM);  
  (*A) = new F90_charArray;
  assert((*A) != NULL);
//  printf("address being returned integer: %x\n",(void*)(*A));

  (*A)->rank = *ndims;
  va_start(ap, ndims);
  for (d = 0; d < *ndims; ++d) {
    (*A)->shape[d] = *(va_arg(ap, int*));
  }
  (*A)->base = va_arg(ap, char*);
  for (d = 0; d < *ndims; ++d) {
    (*A)->stride[d] = va_arg(ap, char*) - (*A)->base;
  }
  va_end(ap);
}

void CREATESHORTARRAYDESC_F77(F90_shortArray** A, int* ndims, ...) {
  int d;
  va_list ap; 

  assert(static_cast<unsigned>(*ndims) <= IC_MAX_DIM);  
  (*A) = new F90_shortArray;
  assert((*A) != NULL);
//  printf("address being returned integer: %x\n",(void*)(*A));

  (*A)->rank = *ndims;
  va_start(ap, ndims);
  for (d = 0; d < *ndims; ++d) {
    (*A)->shape[d] = *(va_arg(ap, int*));
  }
  (*A)->base = va_arg(ap, short*);
  for (d = 0; d < *ndims; ++d) {
    (*A)->stride[d] = va_arg(ap, short*) - (*A)->base;
  }
  va_end(ap);
}

void CREATEINTARRAYDESC_F77(F90_intArray** A, int* ndims, ...) {
  int d;
  va_list ap; 

  assert(static_cast<unsigned>(*ndims) <= IC_MAX_DIM);  
  (*A) = new F90_intArray;
  assert((*A) != NULL);
//  printf("address being returned integer: %x\n",(void*)(*A));

  (*A)->rank = *ndims;
  va_start(ap, ndims);
  for (d = 0; d < *ndims; ++d) {
    (*A)->shape[d] = *(va_arg(ap, int*));
  }
  (*A)->base = va_arg(ap, int*);
  for (d = 0; d < *ndims; ++d) {
    (*A)->stride[d] = va_arg(ap, int*) - (*A)->base;
  }
  va_end(ap);
}

void CREATEFLOATARRAYDESC_F77(F90_floatArray** A, int* ndims, ...) {
  int d;
  va_list ap; 

  assert(static_cast<unsigned>(*ndims) <= IC_MAX_DIM);  
  (*A) = new F90_floatArray;
//  printf("address being returned float: %x\n",(void*)(*A));
  assert((*A) != NULL);

  (*A)->rank = *ndims;
  va_start(ap, ndims);
  for (d = 0; d < *ndims; ++d) {
    (*A)->shape[d] = *(va_arg(ap, int*));
  }
  (*A)->base = va_arg(ap, float*);
  for (d = 0; d < *ndims; ++d) {
    (*A)->stride[d] = va_arg(ap, float*) - (*A)->base;
  }
  va_end(ap);
}

void CREATEDOUBLEARRAYDESC_F77(F90_doubleArray** A, int* ndims, ...) {
  int d;
  va_list ap; 

  assert(static_cast<unsigned>(*ndims) <= IC_MAX_DIM);  
  (*A) = new F90_doubleArray;
//  printf("address being returned double: %x\n",(void*)(*A));
  assert((*A) != NULL);

  (*A)->rank = *ndims;
  va_start(ap, ndims);
  for (d = 0; d < *ndims; ++d) {
    (*A)->shape[d] = *(va_arg(ap, int*));
  }
  (*A)->base = va_arg(ap, double*);
  for (d = 0; d < *ndims; ++d) {
    (*A)->stride[d] = va_arg(ap, double*) - (*A)->base;
  }
  va_end(ap);
}

void DESTROYCHARARRAYDESC_F77(F90_charArray** A) {
  assert(*A != NULL);
//  printf("destroying memory at %x\n", *A);
  delete *A;
}

void DESTROYSHORTARRAYDESC_F77(F90_shortArray** A) {
  assert(*A != NULL);
//  printf("destroying memory at %x\n", *A);
  delete *A;
}

void DESTROYINTARRAYDESC_F77(F90_intArray** A) {
  assert(*A != NULL);
//  printf("destroying memory at %x\n", *A);
  delete *A;
}

void DESTROYFLOATARRAYDESC_F77(F90_floatArray** A) {
  assert(*A != NULL);
//  printf("destroying memory at %x\n", *A);
  delete *A;
}

void DESTROYDOUBLEARRAYDESC_F77(F90_doubleArray** A) {
  assert(*A != NULL);
//  printf("destroying memory at %x\n", *A);
  delete *A;
}

}
