module array_descriptor
  implicit none
  
  interface createArrayDesc
     module procedure &
          create1DcharArrayDesc, &
          create1DshortArrayDesc, &
          create1DintArrayDesc, &
          create1DfloatArrayDesc, &
          create1DdoubleArrayDesc, &
          create2DcharArrayDesc, &
          create2DshortArrayDesc, &
          create2DintArrayDesc, &
          create2DfloatArrayDesc, &
          create2DdoubleArrayDesc, &
          create3DcharArrayDesc, &
          create3DshortArrayDesc, &
          create3DintArrayDesc, &
          create3DfloatArrayDesc, &
          create3DdoubleArrayDesc, &
          create4DcharArrayDesc, &
          create4DshortArrayDesc, &
          create4DintArrayDesc, &
          create4DfloatArrayDesc, &
          create4DdoubleArrayDesc
  end interface

  type arraydesc
     character, dimension(4) :: this
  end type arraydesc
  
contains

  function create1DcharArrayDesc(A)
    type(arraydesc) :: create1DcharArrayDesc
    integer*1, dimension (:) :: A
    call createchararraydesc(create1DcharArrayDesc, 1, size(A,1), A(1), A(2))
  end function create1DcharArrayDesc

  function create2DcharArrayDesc(A)
    type(arraydesc) :: create2DcharArrayDesc
    integer*1, dimension (:,:) :: A
    call createchararraydesc(create2DcharArrayDesc, 2, size(A,1), size(A,2), A(1,1), A(1,2), A(2,1))
  end function create2DcharArrayDesc

  function create3DcharArrayDesc(A)
    type(arraydesc) :: create3DcharArrayDesc
    integer*1, dimension (:,:,:) :: A
    call createchararraydesc(create3DcharArrayDesc, 3, size(A,1), &
        size(A,2), size(A,3), A(1,1,1), A(1,1,2), A(1,2,1), A(2,1,1))
  end function create3DcharArrayDesc

  function create4DcharArrayDesc(A)
    type(arraydesc) :: create4DcharArrayDesc
    integer*1, dimension (:,:,:,:) :: A
    call createchararraydesc(create4DcharArrayDesc, 4, size(A,1), &
        size(A,2), size(A,3), size(A,4), A(1,1,1,1), A(1,1,1,2), A(1,1,2,1), &
        A(1,2,1,1), A(2,1,1,1))
  end function create4DcharArrayDesc

  function create1DshortArrayDesc(A)
    type(arraydesc) :: create1DshortArrayDesc
    integer*2, dimension (:) :: A
    call createchararraydesc(create1DshortArrayDesc, 1, size(A,1), A(1), A(2))
  end function create1DshortArrayDesc

  function create2DshortArrayDesc(A)
    type(arraydesc) :: create2DshortArrayDesc
    integer*2, dimension (:,:) :: A
    call createchararraydesc(create2DshortArrayDesc, 2, size(A,1), size(A,2), A(1,1), A(1,2), A(2,1))
  end function create2DshortArrayDesc

  function create3DshortArrayDesc(A)
    type(arraydesc) :: create3DshortArrayDesc
    integer*2, dimension (:,:,:) :: A
    call createshortarraydesc(create3DshortArrayDesc, 3, size(A,1), &
        size(A,2), size(A,3), A(1,1,1), A(1,1,2), A(1,2,1), A(2,1,1))
  end function create3DshortArrayDesc

  function create4DshortArrayDesc(A)
    type(arraydesc) :: create4DshortArrayDesc
    integer*2, dimension (:,:,:,:) :: A
    call createshortarraydesc(create4DshortArrayDesc, 4, size(A,1), &
        size(A,2), size(A,3), size(A,4), A(1,1,1,1), A(1,1,1,2), A(1,1,2,1), &
        A(1,2,1,1), A(2,1,1,1))
  end function create4DshortArrayDesc

  function create1DintArrayDesc(A)
    type(arraydesc) :: create1DintArrayDesc
    integer, dimension (:) :: A
    call createintarraydesc(create1DintArrayDesc, 1, size(A,1), A(1), A(2))
  end function create1DintArrayDesc
  
  function create2DintArrayDesc(A)
    type(arraydesc) :: create2DintArrayDesc
    integer, dimension (:,:) :: A
    call createintarraydesc(create2DintArrayDesc, 2, size(A,1), size(A,2), A(1,1), A(1,2), A(2,1))
  end function create2DintArrayDesc

  function create3DintArrayDesc(A)
    type(arraydesc) :: create3DintArrayDesc
    integer, dimension (:,:,:) :: A
    call createintarraydesc(create3DintArrayDesc, 3, size(A,1), &
        size(A,2), size(A,3), A(1,1,1), A(1,1,2), A(1,2,1), A(2,1,1))
  end function create3DintArrayDesc

  function create4DintArrayDesc(A)
    type(arraydesc) :: create4DintArrayDesc
    integer, dimension (:,:,:,:) :: A
    call createintarraydesc(create4DintArrayDesc, 4, size(A,1), &
        size(A,2), size(A,3), size(A,4), A(1,1,1,1), A(1,1,1,2), A(1,1,2,1), &
        A(1,2,1,1), A(2,1,1,1))
  end function create4DintArrayDesc

  function create1DfloatArrayDesc(A)
    type(arraydesc) :: create1DfloatArrayDesc
    real, dimension (:) :: A
    call createfloatarraydesc(create1DfloatArrayDesc, 1, size(A,1), A(1), A(2))
  end function create1DfloatArrayDesc
  
  function create2DfloatArrayDesc(A)
    type(arraydesc) :: create2DfloatArrayDesc
    real, dimension (:,:) :: A
    call createfloatarraydesc(create2DfloatArrayDesc, 2, size(A,1), size(A,2), A(1,1), A(1,2), A(2,1))
  end function create2DfloatArrayDesc
  
  function create3DfloatArrayDesc(A)
    type(arraydesc) :: create3DfloatArrayDesc
    real, dimension (:,:,:) :: A
    call createfloatarraydesc(create3DfloatArrayDesc, 3, size(A,1), size(A,2), size(A,3), A(1,1,1), A(1,1,2), A(1,2,1), A(2,1,1))
  end function create3DfloatArrayDesc

  function create4DfloatArrayDesc(A)
    type(arraydesc) :: create4DfloatArrayDesc
    real, dimension (:,:,:,:) :: A
    call createfloatArrayDesc(create4DfloatArrayDesc, 4, size(A,1), &
        size(A,2), size(A,3), size(A,4), A(1,1,1,1), A(1,1,1,2), A(1,1,2,1), &
        A(1,2,1,1), A(2,1,1,1))
  end function create4DfloatArrayDesc

  function create1DdoubleArrayDesc(A)
    type(arraydesc) :: create1DdoubleArrayDesc
    double precision, dimension (:) :: A
    call createdoublearraydesc(create1DdoubleArrayDesc, 1, size(A,1), A(1), A(2))
  end function create1DdoubleArrayDesc

  function create2DdoubleArrayDesc(A)
    type(arraydesc) :: create2DdoubleArrayDesc
    double precision, dimension (:,:) :: A
    integer :: i
    character :: temp
    call createdoublearraydesc(create2DdoubleArrayDesc, 2, size(A,1), size(A,2), A(1,1), A(1,2), A(2,1))
  end function create2DdoubleArrayDesc

  function create3DdoubleArrayDesc(A)
    type(arraydesc) :: create3DdoubleArrayDesc
    double precision, dimension (:,:,:) :: A
    call createdoublearraydesc(create3DdoubleArrayDesc, 3, size(A,1), size(A,2), size(A,3), A(1,1,1), A(1,1,2), A(1,2,1), A(2,1,1))
  end function create3DdoubleArrayDesc

  function create4DdoubleArrayDesc(A)
    type(arraydesc) :: create4DdoubleArrayDesc
    double precision, dimension (:,:,:,:) :: A
    call createdoubleArrayDesc(create4DdoubleArrayDesc, 4, size(A,1), &
        size(A,2), size(A,3), size(A,4), A(1,1,1,1), A(1,1,1,2), A(1,1,2,1), &
        A(1,2,1,1), A(2,1,1,1))
  end function create4DdoubleArrayDesc
 
end module array_descriptor
