module array_printing
  implicit none

  interface printArray
     module procedure &
          print1DintArray, &
          print1DrealArray, &
          print1DdoubleArray, &
          print2DintArray, &
          print2DrealArray, &
          print2DdoubleArray, &
          print3DintArray, &
          print3DrealArray, &
          print3DdoubleArray
  end interface
  
contains
  
  ! print 1D integer arrays
  subroutine print1DintArray(A)
    integer, dimension (:) :: A
    integer :: i    
    print "(10i7)", (A(i), i = 1, size(A,1))
  end subroutine print1DintArray

  ! print 2D integer arrays
  subroutine print2DintArray(A)
    integer, dimension (:,:) :: A
    integer :: i, j
    do i = 1, size(A,1)
       print "(10i7)", (A(i,j), j = 1, size(A,2))
    end do
  end subroutine print2DintArray
  
  ! print 3D integer arrays
  subroutine print3DintArray(A)
    integer, dimension (:,:,:) :: A
    integer :: i, j, k
    do i = 1, size(A,1)
       do j = 1, size(A,2)
          print "(10i7)", (A(i,j,k), k = 1, size(A,3))
       end do
    end do
  end subroutine print3DintArray
  
  ! print 1D real arrays
  subroutine print1DrealArray(A)
    real, dimension (:) :: A
    integer :: i
    print "(10f7.1)", (A(i), i = 1, size(A,1))
  end subroutine print1DrealArray
  
  ! print 2D real arrays
  subroutine print2DrealArray(A)
    real, dimension (:,:) :: A
    integer :: i, j
    do i = 1, size(A,1)
       print "(10f7.1)", (A(i,j), j = 1, size(A,2))
    end do
  end subroutine print2DrealArray
  
  ! print 3D real arrays
  subroutine print3DrealArray(A)
    real, dimension (:,:,:) :: A
    integer :: i, j, k
    do i = 1, size(A,1)
       do j = 1, size(A,2)
          print "(10f7.1)", (A(i,j,k), k = 1, size(A,3))
       end do
    end do
  end subroutine print3DrealArray

  ! print 1D double arrays
  subroutine print1DdoubleArray(A)
    double precision, dimension (:) :: A
    integer :: i
    print "(10f7.1)", (A(i), i = 1, size(A,1))
  end subroutine print1DdoubleArray

  ! print 2D double arrays
  subroutine print2DdoubleArray(A)
    double precision, dimension (:,:) :: A
    integer :: i, j
    do i = 1, size(A,1)
       print "(10f7.1)", (A(i,j), j = 1, size(A,2))
    end do
  end subroutine print2DdoubleArray

  ! print 3D double arrays
  subroutine print3DdoubleArray(A)
    double precision, dimension (:,:,:) :: A
    integer :: i, j, k
    do i = 1, size(A,1)
       do j = 1, size(A,2)
          print "(10f7.1)", (A(i,j,k), k = 1, size(A,3))
       end do
    end do
  end subroutine print3DdoubleArray
  
end module array_printing
