
!------- module definition
module intercomm_interface

  use array_descriptor

  implicit none

  include 'intercomm_interface.h'

  interface ic_export_array
     module procedure &
          ic_export_1DintArray, &
          ic_export_1DfloatArray, &
          ic_export_1DdoubleArray, &
          ic_export_2DintArray, &
          ic_export_2DfloatArray, &
          ic_export_2DdoubleArray, &
          ic_export_3DintArray, &
          ic_export_3DfloatArray, &
          ic_export_3DdoubleArray, &
          ic_export_4DintArray, &
          ic_export_4DfloatArray, &
          ic_export_4DdoubleArray
  end interface

  interface ic_import_array
     module procedure &
          ic_import_1DintArray, &
          ic_import_1DfloatArray, &
          ic_import_1DdoubleArray, &
          ic_import_2DintArray, &
          ic_import_2DfloatArray, &
          ic_import_2DdoubleArray, &
          ic_import_3DintArray, &
          ic_import_3DfloatArray, &
          ic_import_3DdoubleArray, &
          ic_import_4DintArray, &
          ic_import_4DfloatArray, &
          ic_import_4DdoubleArray
  end interface

  interface ic_dump_array_info
     module procedure &
          ic_dump_1DintArray_info, &
          ic_dump_1DfloatArray_info, &
          ic_dump_1DdoubleArray_info, &
          ic_dump_2DintArray_info, &
          ic_dump_2DfloatArray_info, &
          ic_dump_2DdoubleArray_info, &
          ic_dump_3DintArray_info, &
          ic_dump_3DfloatArray_info, &
          ic_dump_3DdoubleArray_info, &
          ic_dump_4DintArray_info, &
          ic_dump_4DfloatArray_info, &
          ic_dump_4DdoubleArray_info
  end interface

  interface ic_send
     module procedure &
          ic_send_1Dchar, &
          ic_send_2Dchar, &
          ic_send_3Dchar, &
          ic_send_4Dchar, &
          ic_send_1Dshort, &
          ic_send_2Dshort, &
          ic_send_3Dshort, &
          ic_send_4Dshort, &
          ic_send_1Dint, &
          ic_send_2Dint, &
          ic_send_3Dint, &
          ic_send_4Dint, &
          ic_send_1Dfloat, &
          ic_send_2Dfloat, &
          ic_send_3Dfloat, &
          ic_send_4Dfloat, &
          ic_send_1Ddouble, &
          ic_send_2Ddouble, &
          ic_send_3Ddouble, &
          ic_send_4Ddouble
  end interface

  interface ic_recv
     module procedure &
          ic_recv_1Dchar, &
          ic_recv_2Dchar, &
          ic_recv_3Dchar, &
          ic_recv_4Dchar, &
          ic_recv_1Dshort, &
          ic_recv_2Dshort, &
          ic_recv_3Dshort, &
          ic_recv_4Dshort, &
          ic_recv_1Dint, &
          ic_recv_2Dint, &
          ic_recv_3Dint, &
          ic_recv_4Dint, &
          ic_recv_1Dfloat, &
          ic_recv_2Dfloat, &
          ic_recv_3Dfloat, &
          ic_recv_4Dfloat, &
          ic_recv_1Ddouble, &
          ic_recv_2Ddouble, &
          ic_recv_3Ddouble, &
          ic_recv_4Ddouble
  end interface

  type ic_obj
!  the InterComm object is a pointer. Pointers require 4 bytes
     character(4) :: this
  end type ic_obj
  
contains

!---- 1D
  
  subroutine ic_import_1DintArray(ico, A, sts)
    type(ic_obj) :: ico 
    integer, dimension (:) :: A
    integer :: sts
    type(arraydesc) :: A_desc 
!    print *,">>>>>>>>>>>>>>>>>>>>>>>>>> before getintArray"
!    write(6,fmt="(z7)") A_desc.this
    A_desc = createArrayDesc(A)
!    print *,">>>>>>>>>>>>>>>>>>>>>>>>>> after getintArray"
!    write(6,fmt="(z7)") A_desc.this
!    print *,"in ic_import_array"
    call ic_import_array_int_helper(ico,A_desc,sts)
    call destroyintarraydesc(A_desc)
  end subroutine ic_import_1DintArray
  
  subroutine ic_export_1DintArray(ico, A, sts)
    type(ic_obj) :: ico 
    integer, dimension (:) :: A
    integer :: sts
    type(arraydesc) :: A_desc 
    A_desc = createArrayDesc(A)
!    print *,"in ic_export_array"
    call ic_export_array_int_helper(ico,A_desc,sts)
    call destroyintarraydesc(A_desc)
  end subroutine ic_export_1DintArray
  
  subroutine ic_dump_1DintArray_info(A)
    type(arraydesc) :: A_desc
    integer, dimension (:) :: A
    A_desc = createArrayDesc(A)
    call ic_dump_int_arrayinternals(A_desc);
    call destroyintarraydesc(A_desc)
  end subroutine ic_dump_1DintArray_info

  
  subroutine ic_import_1DfloatArray(ico, A, sts)
    type(ic_obj) :: ico 
    real, dimension (:) :: A
    integer :: sts
    type(arraydesc) :: A_desc 
!    print *,">>>>>>>>>>>>>>>>>>>>>>>>>> before getfloatArray"
!    write(6,fmt="(z7)") A_desc.this
    A_desc = createArrayDesc(A)
!    print *,">>>>>>>>>>>>>>>>>>>>>>>>>> after getfloatArray"
!    write(6,fmt="(z7)") A_desc.this
!    print *,"in ic_import_array"
    call ic_import_array_float_helper(ico,A_desc,sts)
    call destroyfloatarraydesc(A_desc)
  end subroutine ic_import_1DfloatArray
  
  subroutine ic_export_1DfloatArray(ico, A, sts)
    type(ic_obj) :: ico 
    real, dimension (:) :: A
    integer :: sts
    type(arraydesc) :: A_desc 
    A_desc = createArrayDesc(A)
!    print *,"in ic_export_array"
    call ic_export_array_float_helper(ico,A_desc,sts)
    call destroyfloatarraydesc(A_desc)
  end subroutine ic_export_1DfloatArray
  
  subroutine ic_dump_1DfloatArray_info(A)
    type(arraydesc) :: A_desc
    real, dimension (:) :: A
    A_desc = createArrayDesc(A)
    call ic_dump_float_arrayinternals(A_desc);
    call destroyfloatarraydesc(A_desc)
  end subroutine ic_dump_1DfloatArray_info

  
  subroutine ic_import_1DdoubleArray(ico, A, sts)
    type(ic_obj) :: ico 
    double precision, dimension (:) :: A
    integer :: sts
    type(arraydesc) :: A_desc 
!    print *,">>>>>>>>>>>>>>>>>>>>>>>>>> before getdoubleArray"
!    write(6,fmt="(z7)") A_desc.this
    A_desc = createArrayDesc(A)
!    print *,">>>>>>>>>>>>>>>>>>>>>>>>>> after getdoubleArray"
!    write(6,fmt="(z7)") A_desc.this
!    print *,"in ic_import_array"
    call ic_import_array_double_helper(ico,A_desc,sts)
    call destroydoublearraydesc(A_desc)
  end subroutine ic_import_1DdoubleArray
  
  subroutine ic_export_1DdoubleArray(ico, A, sts)
    type(ic_obj) :: ico 
    double precision, dimension (:) :: A
    integer :: sts
    type(arraydesc) :: A_desc 
    A_desc = createArrayDesc(A)
!    print *,"in ic_export_array"
    call ic_export_array_double_helper(ico,A_desc,sts)
    call destroydoublearraydesc(A_desc)
  end subroutine ic_export_1DdoubleArray
  
  subroutine ic_dump_1DdoubleArray_info(A)
    type(arraydesc) :: A_desc
    double precision, dimension (:) :: A
    A_desc = createArrayDesc(A)
    call ic_dump_double_arrayinternals(A_desc);
    call destroydoublearraydesc(A_desc)
  end subroutine ic_dump_1DdoubleArray_info
 
!---- 2D
  
  subroutine ic_import_2DintArray(ico, A, sts)
    type(ic_obj) :: ico 
    integer, dimension (:,:) :: A
    integer :: sts
    type(arraydesc) :: A_desc 
!    print *,">>>>>>>>>>>>>>>>>>>>>>>>>> before getintArray"
!    write(6,fmt="(z7)") A_desc.this
    A_desc = createArrayDesc(A)
!    print *,">>>>>>>>>>>>>>>>>>>>>>>>>> after getintArray"
!    write(6,fmt="(z7)") A_desc.this
!    print *,"in ic_import_array"
    call ic_import_array_int_helper(ico,A_desc,sts)
    call destroyintarraydesc(A_desc)
  end subroutine ic_import_2DintArray
  
  subroutine ic_export_2DintArray(ico, A, sts)
    type(ic_obj) :: ico 
    integer, dimension (:,:) :: A
    integer :: sts
    type(arraydesc) :: A_desc 
    A_desc = createArrayDesc(A)
!    print *,"in ic_export_array"
    call ic_export_array_int_helper(ico,A_desc,sts)
    call destroyintarraydesc(A_desc)
  end subroutine ic_export_2DintArray
  
  subroutine ic_dump_2DintArray_info(A)
    type(arraydesc) :: A_desc
    integer, dimension (:,:) :: A
    A_desc = createArrayDesc(A)
    call ic_dump_int_arrayinternals(A_desc);
    call destroyintarraydesc(A_desc)
  end subroutine ic_dump_2DintArray_info

  
  subroutine ic_import_2DfloatArray(ico, A, sts)
    type(ic_obj) :: ico 
    real, dimension (:,:) :: A
    integer :: sts
    type(arraydesc) :: A_desc 
!    print *,">>>>>>>>>>>>>>>>>>>>>>>>>> before getfloatArray"
!    write(6,fmt="(z7)") A_desc.this
    A_desc = createArrayDesc(A)
!    print *,">>>>>>>>>>>>>>>>>>>>>>>>>> after getfloatArray"
!    write(6,fmt="(z7)") A_desc.this
!    print *,"in ic_import_array"
    call ic_import_array_float_helper(ico,A_desc,sts)
    call destroyfloatarraydesc(A_desc)
  end subroutine ic_import_2DfloatArray
  
  subroutine ic_export_2DfloatArray(ico, A, sts)
    type(ic_obj) :: ico 
    real, dimension (:,:) :: A
    integer :: sts
    type(arraydesc) :: A_desc 
    A_desc = createArrayDesc(A)
!    print *,"in ic_export_array"
    call ic_export_array_float_helper(ico,A_desc,sts)
    call destroyfloatarraydesc(A_desc)
  end subroutine ic_export_2DfloatArray
  
  subroutine ic_dump_2DfloatArray_info(A)
    type(arraydesc) :: A_desc
    real, dimension (:,:) :: A
    A_desc = createArrayDesc(A)
    call ic_dump_float_arrayinternals(A_desc);
    call destroyfloatarraydesc(A_desc)
  end subroutine ic_dump_2DfloatArray_info

  
  subroutine ic_import_2DdoubleArray(ico, A, sts)
    type(ic_obj) :: ico 
    double precision, dimension (:,:) :: A
    integer :: sts
    type(arraydesc) :: A_desc 
!    print *,">>>>>>>>>>>>>>>>>>>>>>>>>> before getdoubleArray"
!    write(6,fmt="(z7)") A_desc.this
    A_desc = createArrayDesc(A)
!    print *,">>>>>>>>>>>>>>>>>>>>>>>>>> after getdoubleArray"
!    write(6,fmt="(z7)") A_desc.this
!    print *,"in ic_import_array"
    call ic_import_array_double_helper(ico,A_desc,sts)
    call destroydoublearraydesc(A_desc)
  end subroutine ic_import_2DdoubleArray
  
  subroutine ic_export_2DdoubleArray(ico, A, sts)
    type(ic_obj) :: ico 
    double precision, dimension (:,:) :: A
    integer :: sts
    type(arraydesc) :: A_desc 
    A_desc = createArrayDesc(A)
!    print *,"in ic_export_array"
    call ic_export_array_double_helper(ico,A_desc,sts)
    call destroydoublearraydesc(A_desc)
  end subroutine ic_export_2DdoubleArray
  
  subroutine ic_dump_2DdoubleArray_info(A)
    type(arraydesc) :: A_desc
    double precision, dimension (:,:) :: A
    A_desc = createArrayDesc(A)
    call ic_dump_double_arrayinternals(A_desc);
    call destroydoublearraydesc(A_desc)
  end subroutine ic_dump_2DdoubleArray_info
 
!---- 3D
  
  subroutine ic_import_3DintArray(ico, A, sts)
    type(ic_obj) :: ico 
    integer, dimension (:,:,:) :: A
    integer :: sts
    type(arraydesc) :: A_desc 
!    print *,">>>>>>>>>>>>>>>>>>>>>>>>>> before getintArray"
!    write(6,fmt="(z7)") A_desc.this
    A_desc = createArrayDesc(A)
!    print *,">>>>>>>>>>>>>>>>>>>>>>>>>> after getintArray"
!    write(6,fmt="(z7)") A_desc.this
!    print *,"in ic_import_array"
    call ic_import_array_int_helper(ico,A_desc,sts)
    call destroyintarraydesc(A_desc)
  end subroutine ic_import_3DintArray
  
  subroutine ic_export_3DintArray(ico, A, sts)
    type(ic_obj) :: ico 
    integer, dimension (:,:,:) :: A
    integer :: sts
    type(arraydesc) :: A_desc 
    A_desc = createArrayDesc(A)
!    print *,"in ic_export_array"
    call ic_export_array_int_helper(ico,A_desc,sts)
    call destroyintarraydesc(A_desc)
  end subroutine ic_export_3DintArray
  
  subroutine ic_dump_3DintArray_info(A)
    type(arraydesc) :: A_desc
    integer, dimension (:,:,:) :: A
    A_desc = createArrayDesc(A)
    call ic_dump_int_arrayinternals(A_desc);
    call destroyintarraydesc(A_desc)
  end subroutine ic_dump_3DintArray_info

  
  subroutine ic_import_3DfloatArray(ico, A, sts)
    type(ic_obj) :: ico 
    real, dimension (:,:,:) :: A
    integer :: sts
    type(arraydesc) :: A_desc 
!    print *,">>>>>>>>>>>>>>>>>>>>>>>>>> before getfloatArray"
!    write(6,fmt="(z7)") A_desc.this
    A_desc = createArrayDesc(A)
!    print *,">>>>>>>>>>>>>>>>>>>>>>>>>> after getfloatArray"
!    write(6,fmt="(z7)") A_desc.this
!    print *,"in ic_import_array"
    call ic_import_array_float_helper(ico,A_desc,sts)
    call destroyfloatarraydesc(A_desc)
  end subroutine ic_import_3DfloatArray
  
  subroutine ic_export_3DfloatArray(ico, A, sts)
    type(ic_obj) :: ico 
    real, dimension (:,:,:) :: A
    integer :: sts
    type(arraydesc) :: A_desc 
    A_desc = createArrayDesc(A)
!    print *,"in ic_export_array"
    call ic_export_array_float_helper(ico,A_desc,sts)
    call destroyfloatarraydesc(A_desc)
  end subroutine ic_export_3DfloatArray
  
  subroutine ic_dump_3DfloatArray_info(A)
    type(arraydesc) :: A_desc
    real, dimension (:,:,:) :: A
    A_desc = createArrayDesc(A)
    call ic_dump_float_arrayinternals(A_desc);
    call destroyfloatarraydesc(A_desc)
  end subroutine ic_dump_3DfloatArray_info

  
  subroutine ic_import_3DdoubleArray(ico, A, sts)
    type(ic_obj) :: ico 
    double precision, dimension (:,:,:) :: A
    integer :: sts
    type(arraydesc) :: A_desc 
!    print *,">>>>>>>>>>>>>>>>>>>>>>>>>> before getdoubleArray"
!    write(6,fmt="(z7)") A_desc.this
    A_desc = createArrayDesc(A)
!    print *,">>>>>>>>>>>>>>>>>>>>>>>>>> after getdoubleArray"
!    write(6,fmt="(z7)") A_desc.this
!    print *,"in ic_import_array"
    call ic_import_array_double_helper(ico,A_desc,sts)
    call destroydoublearraydesc(A_desc)
  end subroutine ic_import_3DdoubleArray
  
  subroutine ic_export_3DdoubleArray(ico, A, sts)
    type(ic_obj) :: ico 
    double precision, dimension (:,:,:) :: A
    integer :: sts
    type(arraydesc) :: A_desc 
    A_desc = createArrayDesc(A)
!    print *,"in ic_export_array"
    call ic_export_array_double_helper(ico,A_desc,sts)
    call destroydoublearraydesc(A_desc)
  end subroutine ic_export_3DdoubleArray
  
  subroutine ic_dump_3DdoubleArray_info(A)
    type(arraydesc) :: A_desc
    double precision, dimension (:,:,:) :: A
    A_desc = createArrayDesc(A)
    call ic_dump_double_arrayinternals(A_desc);
    call destroydoublearraydesc(A_desc)
  end subroutine ic_dump_3DdoubleArray_info

!---- 4D
  
  subroutine ic_import_4DintArray(ico, A, sts)
    type(ic_obj) :: ico 
    integer, dimension (:,:,:,:) :: A
    integer :: sts
    type(arraydesc) :: A_desc 
!    print *,">>>>>>>>>>>>>>>>>>>>>>>>>> before getintArray"
!    write(6,fmt="(z7)") A_desc.this
    A_desc = createArrayDesc(A)
!    print *,">>>>>>>>>>>>>>>>>>>>>>>>>> after getintArray"
!    write(6,fmt="(z7)") A_desc.this
!    print *,"in ic_import_array"
    call ic_import_array_int_helper(ico,A_desc,sts)
    call destroyintarraydesc(A_desc)
  end subroutine ic_import_4DintArray
  
  subroutine ic_export_4DintArray(ico, A, sts)
    type(ic_obj) :: ico 
    integer, dimension (:,:,:,:) :: A
    integer :: sts
    type(arraydesc) :: A_desc 
    A_desc = createArrayDesc(A)
!    print *,"in ic_export_array"
    call ic_export_array_int_helper(ico,A_desc,sts)
    call destroyintarraydesc(A_desc)
  end subroutine ic_export_4DintArray
  
  subroutine ic_dump_4DintArray_info(A)
    type(arraydesc) :: A_desc
    integer, dimension (:,:,:,:) :: A
    A_desc = createArrayDesc(A)
    call ic_dump_int_arrayinternals(A_desc);
    call destroyintarraydesc(A_desc)
  end subroutine ic_dump_4DintArray_info

  
  subroutine ic_import_4DfloatArray(ico, A, sts)
    type(ic_obj) :: ico 
    real, dimension (:,:,:,:) :: A
    integer :: sts
    type(arraydesc) :: A_desc 
!    print *,">>>>>>>>>>>>>>>>>>>>>>>>>> before getfloatArray"
!    write(6,fmt="(z7)") A_desc.this
    A_desc = createArrayDesc(A)
!    print *,">>>>>>>>>>>>>>>>>>>>>>>>>> after getfloatArray"
!    write(6,fmt="(z7)") A_desc.this
!    print *,"in ic_import_array"
    call ic_import_array_float_helper(ico,A_desc,sts)
    call destroyfloatarraydesc(A_desc)
  end subroutine ic_import_4DfloatArray
  
  subroutine ic_export_4DfloatArray(ico, A, sts)
    type(ic_obj) :: ico 
    real, dimension (:,:,:,:) :: A
    integer :: sts
    type(arraydesc) :: A_desc 
    A_desc = createArrayDesc(A)
!    print *,"in ic_export_array"
    call ic_export_array_float_helper(ico,A_desc,sts)
    call destroyfloatarraydesc(A_desc)
  end subroutine ic_export_4DfloatArray
  
  subroutine ic_dump_4DfloatArray_info(A)
    type(arraydesc) :: A_desc
    real, dimension (:,:,:,:) :: A
    A_desc = createArrayDesc(A)
    call ic_dump_float_arrayinternals(A_desc);
    call destroyfloatarraydesc(A_desc)
  end subroutine ic_dump_4DfloatArray_info

  
  subroutine ic_import_4DdoubleArray(ico, A, sts)
    type(ic_obj) :: ico 
    double precision, dimension (:,:,:,:) :: A
    integer :: sts
    type(arraydesc) :: A_desc 
!    print *,">>>>>>>>>>>>>>>>>>>>>>>>>> before getdoubleArray"
!    write(6,fmt="(z7)") A_desc.this
    A_desc = createArrayDesc(A)
!    print *,">>>>>>>>>>>>>>>>>>>>>>>>>> after getdoubleArray"
!    write(6,fmt="(z7)") A_desc.this
!    print *,"in ic_import_array"
    call ic_import_array_double_helper(ico,A_desc,sts)
    call destroydoublearraydesc(A_desc)
  end subroutine ic_import_4DdoubleArray
  
  subroutine ic_export_4DdoubleArray(ico, A, sts)
    type(ic_obj) :: ico 
    double precision, dimension (:,:,:,:) :: A
    integer :: sts
    type(arraydesc) :: A_desc 
    A_desc = createArrayDesc(A)
!    print *,"in ic_export_array"
    call ic_export_array_double_helper(ico,A_desc,sts)
    call destroydoublearraydesc(A_desc)
  end subroutine ic_export_4DdoubleArray
  
  subroutine ic_dump_4DdoubleArray_info(A)
    type(arraydesc) :: A_desc
    double precision, dimension (:,:,:,:) :: A
    A_desc = createArrayDesc(A)
    call ic_dump_double_arrayinternals(A_desc);
    call destroydoublearraydesc(A_desc)
  end subroutine ic_dump_4DdoubleArray_info

!---- char
  
  subroutine ic_send_1Dchar(otherp,sched,data2send,tag,sts)
    integer otherp
    integer sched
    integer*1, dimension (:) :: data2send
    integer tag
    integer sts
    type(arraydesc) :: data2send_desc
    data2send_desc = createArrayDesc(data2send)
    call ic_send_char_helper(otherp,sched,data2send_desc,tag,sts);
    call destroychararraydesc(data2send_desc)
  end subroutine ic_send_1Dchar
  
  subroutine ic_recv_1Dchar(otherp,sched,data2recv,tag,sts)
    integer otherp
    integer sched
    integer*1, dimension (:) :: data2recv
    integer tag
    integer sts
    type(arraydesc) :: data2recv_desc
    data2recv_desc = createArrayDesc(data2recv)
    call ic_recv_char_helper(otherp,sched,data2recv_desc,tag,sts);
    call destroychararraydesc(data2recv_desc)
  end subroutine ic_recv_1Dchar
  
  subroutine ic_send_2Dchar(otherp,sched,data2send,tag,sts)
    integer otherp
    integer sched
    integer*1, dimension (:,:) :: data2send
    integer tag
    integer sts
    type(arraydesc) :: data2send_desc
    data2send_desc = createArrayDesc(data2send)
    call ic_send_char_helper(otherp,sched,data2send_desc,tag,sts);
    call destroychararraydesc(data2send_desc)
  end subroutine ic_send_2Dchar
  
  subroutine ic_recv_2Dchar(otherp,sched,data2recv,tag,sts)
    integer otherp
    integer sched
    integer*1, dimension (:,:) :: data2recv
    integer tag
    integer sts
    type(arraydesc) :: data2recv_desc
    data2recv_desc = createArrayDesc(data2recv)
    call ic_recv_char_helper(otherp,sched,data2recv_desc,tag,sts);
    call destroychararraydesc(data2recv_desc)
  end subroutine ic_recv_2Dchar
  
  subroutine ic_send_3Dchar(otherp,sched,data2send,tag,sts)
    integer otherp
    integer sched
    integer*1, dimension (:,:,:) :: data2send
    integer tag
    integer sts
    type(arraydesc) :: data2send_desc
    data2send_desc = createArrayDesc(data2send)
    call ic_send_char_helper(otherp,sched,data2send_desc,tag,sts);
    call destroychararraydesc(data2send_desc)
  end subroutine ic_send_3Dchar
  
  subroutine ic_recv_3Dchar(otherp,sched,data2recv,tag,sts)
    integer otherp
    integer sched
    integer*1, dimension (:,:,:) :: data2recv
    integer tag
    integer sts
    type(arraydesc) :: data2recv_desc
    data2recv_desc = createArrayDesc(data2recv)
    call ic_recv_char_helper(otherp,sched,data2recv_desc,tag,sts);
    call destroychararraydesc(data2recv_desc)
  end subroutine ic_recv_3Dchar
  
  subroutine ic_send_4Dchar(otherp,sched,data2send,tag,sts)
    integer otherp
    integer sched
    integer*1, dimension (:,:,:,:) :: data2send
    integer tag
    integer sts
    type(arraydesc) :: data2send_desc
    data2send_desc = createArrayDesc(data2send)
    call ic_send_char_helper(otherp,sched,data2send_desc,tag,sts);
    call destroychararraydesc(data2send_desc)
  end subroutine ic_send_4Dchar
  
  subroutine ic_recv_4Dchar(otherp,sched,data2recv,tag,sts)
    integer otherp
    integer sched
    integer*1, dimension (:,:,:,:) :: data2recv
    integer tag
    integer sts
    type(arraydesc) :: data2recv_desc
    data2recv_desc = createArrayDesc(data2recv)
    call ic_recv_char_helper(otherp,sched,data2recv_desc,tag,sts);
    call destroychararraydesc(data2recv_desc)
  end subroutine ic_recv_4Dchar

!---- short
  
  subroutine ic_send_1Dshort(otherp,sched,data2send,tag,sts)
    integer otherp
    integer sched
    integer*2, dimension (:) :: data2send
    integer tag
    integer sts
    type(arraydesc) :: data2send_desc
    data2send_desc = createArrayDesc(data2send)
    call ic_send_short_helper(otherp,sched,data2send_desc,tag,sts);
    call destroyshortarraydesc(data2send_desc)
  end subroutine ic_send_1Dshort
  
  subroutine ic_recv_1Dshort(otherp,sched,data2recv,tag,sts)
    integer otherp
    integer sched
    integer*2, dimension (:) :: data2recv
    integer tag
    integer sts
    type(arraydesc) :: data2recv_desc
    data2recv_desc = createArrayDesc(data2recv)
    call ic_recv_short_helper(otherp,sched,data2recv_desc,tag,sts);
    call destroyshortarraydesc(data2recv_desc)
  end subroutine ic_recv_1Dshort
  
  subroutine ic_send_2Dshort(otherp,sched,data2send,tag,sts)
    integer otherp
    integer sched
    integer*2, dimension (:,:) :: data2send
    integer tag
    integer sts
    type(arraydesc) :: data2send_desc
    data2send_desc = createArrayDesc(data2send)
    call ic_send_short_helper(otherp,sched,data2send_desc,tag,sts);
    call destroyshortarraydesc(data2send_desc)
  end subroutine ic_send_2Dshort
  
  subroutine ic_recv_2Dshort(otherp,sched,data2recv,tag,sts)
    integer otherp
    integer sched
    integer*2, dimension (:,:) :: data2recv
    integer tag
    integer sts
    type(arraydesc) :: data2recv_desc
    data2recv_desc = createArrayDesc(data2recv)
    call ic_recv_short_helper(otherp,sched,data2recv_desc,tag,sts);
    call destroyshortarraydesc(data2recv_desc)
  end subroutine ic_recv_2Dshort
  
  subroutine ic_send_3Dshort(otherp,sched,data2send,tag,sts)
    integer otherp
    integer sched
    integer*2, dimension (:,:,:) :: data2send
    integer tag
    integer sts
    type(arraydesc) :: data2send_desc
    data2send_desc = createArrayDesc(data2send)
    call ic_send_short_helper(otherp,sched,data2send_desc,tag,sts);
    call destroyshortarraydesc(data2send_desc)
  end subroutine ic_send_3Dshort
  
  subroutine ic_recv_3Dshort(otherp,sched,data2recv,tag,sts)
    integer otherp
    integer sched
    integer*2, dimension (:,:,:) :: data2recv
    integer tag
    integer sts
    type(arraydesc) :: data2recv_desc
    data2recv_desc = createArrayDesc(data2recv)
    call ic_recv_short_helper(otherp,sched,data2recv_desc,tag,sts);
    call destroyshortarraydesc(data2recv_desc)
  end subroutine ic_recv_3Dshort
  
  subroutine ic_send_4Dshort(otherp,sched,data2send,tag,sts)
    integer otherp
    integer sched
    integer*2, dimension (:,:,:,:) :: data2send
    integer tag
    integer sts
    type(arraydesc) :: data2send_desc
    data2send_desc = createArrayDesc(data2send)
    call ic_send_short_helper(otherp,sched,data2send_desc,tag,sts);
    call destroyshortarraydesc(data2send_desc)
  end subroutine ic_send_4Dshort
  
  subroutine ic_recv_4Dshort(otherp,sched,data2recv,tag,sts)
    integer otherp
    integer sched
    integer*2, dimension (:,:,:,:) :: data2recv
    integer tag
    integer sts
    type(arraydesc) :: data2recv_desc
    data2recv_desc = createArrayDesc(data2recv)
    call ic_recv_short_helper(otherp,sched,data2recv_desc,tag,sts);
    call destroyshortarraydesc(data2recv_desc)
  end subroutine ic_recv_4Dshort

!---- int
  
  subroutine ic_send_1Dint(otherp,sched,data2send,tag,sts)
    integer otherp
    integer sched
    integer, dimension (:) :: data2send
    integer tag
    integer sts
    type(arraydesc) :: data2send_desc
    data2send_desc = createArrayDesc(data2send)
    call ic_send_int_helper(otherp,sched,data2send_desc,tag,sts);
    call destroyintarraydesc(data2send_desc)
  end subroutine ic_send_1Dint
  
  subroutine ic_recv_1Dint(otherp,sched,data2recv,tag,sts)
    integer otherp
    integer sched
    integer, dimension (:) :: data2recv
    integer tag
    integer sts
    type(arraydesc) :: data2recv_desc
    data2recv_desc = createArrayDesc(data2recv)
    call ic_recv_int_helper(otherp,sched,data2recv_desc,tag,sts);
    call destroyintarraydesc(data2recv_desc)
  end subroutine ic_recv_1Dint
  
  subroutine ic_send_2Dint(otherp,sched,data2send,tag,sts)
    integer otherp
    integer sched
    integer, dimension (:,:) :: data2send
    integer tag
    integer sts
    type(arraydesc) :: data2send_desc
    data2send_desc = createArrayDesc(data2send)
    call ic_send_int_helper(otherp,sched,data2send_desc,tag,sts);
    call destroyintarraydesc(data2send_desc)
  end subroutine ic_send_2Dint
  
  subroutine ic_recv_2Dint(otherp,sched,data2recv,tag,sts)
    integer otherp
    integer sched
    integer, dimension (:,:) :: data2recv
    integer tag
    integer sts
    type(arraydesc) :: data2recv_desc
    data2recv_desc = createArrayDesc(data2recv)
    call ic_recv_int_helper(otherp,sched,data2recv_desc,tag,sts);
    call destroyintarraydesc(data2recv_desc)
  end subroutine ic_recv_2Dint
  
  subroutine ic_send_3Dint(otherp,sched,data2send,tag,sts)
    integer otherp
    integer sched
    integer, dimension (:,:,:) :: data2send
    integer tag
    integer sts
    type(arraydesc) :: data2send_desc
    data2send_desc = createArrayDesc(data2send)
    call ic_send_int_helper(otherp,sched,data2send_desc,tag,sts);
    call destroyintarraydesc(data2send_desc)
  end subroutine ic_send_3Dint
  
  subroutine ic_recv_3Dint(otherp,sched,data2recv,tag,sts)
    integer otherp
    integer sched
    integer, dimension (:,:,:) :: data2recv
    integer tag
    integer sts
    type(arraydesc) :: data2recv_desc
    data2recv_desc = createArrayDesc(data2recv)
    call ic_recv_int_helper(otherp,sched,data2recv_desc,tag,sts);
    call destroyintarraydesc(data2recv_desc)
  end subroutine ic_recv_3Dint
  
  subroutine ic_send_4Dint(otherp,sched,data2send,tag,sts)
    integer otherp
    integer sched
    integer, dimension (:,:,:,:) :: data2send
    integer tag
    integer sts
    type(arraydesc) :: data2send_desc
    data2send_desc = createArrayDesc(data2send)
    call ic_send_int_helper(otherp,sched,data2send_desc,tag,sts);
    call destroyintarraydesc(data2send_desc)
  end subroutine ic_send_4Dint
  
  subroutine ic_recv_4Dint(otherp,sched,data2recv,tag,sts)
    integer otherp
    integer sched
    integer, dimension (:,:,:,:) :: data2recv
    integer tag
    integer sts
    type(arraydesc) :: data2recv_desc
    data2recv_desc = createArrayDesc(data2recv)
    call ic_recv_int_helper(otherp,sched,data2recv_desc,tag,sts);
    call destroyintarraydesc(data2recv_desc)
  end subroutine ic_recv_4Dint

!---- float
  
  subroutine ic_send_1Dfloat(otherp,sched,data2send,tag,sts)
    integer otherp
    integer sched
    real, dimension (:) :: data2send
    integer tag
    integer sts
    type(arraydesc) :: data2send_desc
    data2send_desc = createArrayDesc(data2send)
    call ic_send_float_helper(otherp,sched,data2send_desc,tag,sts);
    call destroyfloatarraydesc(data2send_desc)
  end subroutine ic_send_1Dfloat
  
  subroutine ic_recv_1Dfloat(otherp,sched,data2recv,tag,sts)
    integer otherp
    integer sched
    real, dimension (:) :: data2recv
    integer tag
    integer sts
    type(arraydesc) :: data2recv_desc
    data2recv_desc = createArrayDesc(data2recv)
    call ic_recv_float_helper(otherp,sched,data2recv_desc,tag,sts);
    call destroyfloatarraydesc(data2recv_desc)
  end subroutine ic_recv_1Dfloat
  
  subroutine ic_send_2Dfloat(otherp,sched,data2send,tag,sts)
    integer otherp
    integer sched
    real, dimension (:,:) :: data2send
    integer tag
    integer sts
    type(arraydesc) :: data2send_desc
    data2send_desc = createArrayDesc(data2send)
    call ic_send_float_helper(otherp,sched,data2send_desc,tag,sts);
    call destroyfloatarraydesc(data2send_desc)
  end subroutine ic_send_2Dfloat
  
  subroutine ic_recv_2Dfloat(otherp,sched,data2recv,tag,sts)
    integer otherp
    integer sched
    real, dimension (:,:) :: data2recv
    integer tag
    integer sts
    type(arraydesc) :: data2recv_desc
    data2recv_desc = createArrayDesc(data2recv)
    call ic_recv_float_helper(otherp,sched,data2recv_desc,tag,sts);
    call destroyfloatarraydesc(data2recv_desc)
  end subroutine ic_recv_2Dfloat
  
  subroutine ic_send_3Dfloat(otherp,sched,data2send,tag,sts)
    integer otherp
    integer sched
    real, dimension (:,:,:) :: data2send
    integer tag
    integer sts
    type(arraydesc) :: data2send_desc
    data2send_desc = createArrayDesc(data2send)
    call ic_send_float_helper(otherp,sched,data2send_desc,tag,sts);
    call destroyfloatarraydesc(data2send_desc)
  end subroutine ic_send_3Dfloat
  
  subroutine ic_recv_3Dfloat(otherp,sched,data2recv,tag,sts)
    integer otherp
    integer sched
    real, dimension (:,:,:) :: data2recv
    integer tag
    integer sts
    type(arraydesc) :: data2recv_desc
    data2recv_desc = createArrayDesc(data2recv)
    call ic_recv_float_helper(otherp,sched,data2recv_desc,tag,sts);
    call destroyfloatarraydesc(data2recv_desc)
  end subroutine ic_recv_3Dfloat
  
  subroutine ic_send_4Dfloat(otherp,sched,data2send,tag,sts)
    integer otherp
    integer sched
    real, dimension (:,:,:,:) :: data2send
    integer tag
    integer sts
    type(arraydesc) :: data2send_desc
    data2send_desc = createArrayDesc(data2send)
    call ic_send_float_helper(otherp,sched,data2send_desc,tag,sts);
    call destroyfloatarraydesc(data2send_desc)
  end subroutine ic_send_4Dfloat
  
  subroutine ic_recv_4Dfloat(otherp,sched,data2recv,tag,sts)
    integer otherp
    integer sched
    real, dimension (:,:,:,:) :: data2recv
    integer tag
    integer sts
    type(arraydesc) :: data2recv_desc
    data2recv_desc = createArrayDesc(data2recv)
    call ic_recv_float_helper(otherp,sched,data2recv_desc,tag,sts);
    call destroyfloatarraydesc(data2recv_desc)
  end subroutine ic_recv_4Dfloat

!---- double
  
  subroutine ic_send_1Ddouble(otherp,sched,data2send,tag,sts)
    integer otherp
    integer sched
    double precision, dimension (:) :: data2send
    integer tag
    integer sts
    type(arraydesc) :: data2send_desc
    data2send_desc = createArrayDesc(data2send)
    call ic_send_double_helper(otherp,sched,data2send_desc,tag,sts);
    call destroydoublearraydesc(data2send_desc)
  end subroutine ic_send_1Ddouble
  
  subroutine ic_recv_1Ddouble(otherp,sched,data2recv,tag,sts)
    integer otherp
    integer sched
    double precision, dimension (:) :: data2recv
    integer tag
    integer sts
    type(arraydesc) :: data2recv_desc
    data2recv_desc = createArrayDesc(data2recv)
    call ic_recv_double_helper(otherp,sched,data2recv_desc,tag,sts);
    call destroydoublearraydesc(data2recv_desc)
  end subroutine ic_recv_1Ddouble
  
  subroutine ic_send_2Ddouble(otherp,sched,data2send,tag,sts)
    integer otherp
    integer sched
    double precision, dimension (:,:) :: data2send
    integer tag
    integer sts
    type(arraydesc) :: data2send_desc
    data2send_desc = createArrayDesc(data2send)
    call ic_send_double_helper(otherp,sched,data2send_desc,tag,sts);
    call destroydoublearraydesc(data2send_desc)
  end subroutine ic_send_2Ddouble
  
  subroutine ic_recv_2Ddouble(otherp,sched,data2recv,tag,sts)
    integer otherp
    integer sched
    double precision, dimension (:,:) :: data2recv
    integer tag
    integer sts
    type(arraydesc) :: data2recv_desc
    data2recv_desc = createArrayDesc(data2recv)
    call ic_recv_double_helper(otherp,sched,data2recv_desc,tag,sts);
    call destroydoublearraydesc(data2recv_desc)
  end subroutine ic_recv_2Ddouble
  
  subroutine ic_send_3Ddouble(otherp,sched,data2send,tag,sts)
    integer otherp
    integer sched
    double precision, dimension (:,:,:) :: data2send
    integer tag
    integer sts
    type(arraydesc) :: data2send_desc
    data2send_desc = createArrayDesc(data2send)
    call ic_send_double_helper(otherp,sched,data2send_desc,tag,sts);
    call destroydoublearraydesc(data2send_desc)
  end subroutine ic_send_3Ddouble
  
  subroutine ic_recv_3Ddouble(otherp,sched,data2recv,tag,sts)
    integer otherp
    integer sched
    double precision, dimension (:,:,:) :: data2recv
    integer tag
    integer sts
    type(arraydesc) :: data2recv_desc
    data2recv_desc = createArrayDesc(data2recv)
    call ic_recv_double_helper(otherp,sched,data2recv_desc,tag,sts);
    call destroydoublearraydesc(data2recv_desc)
  end subroutine ic_recv_3Ddouble
  
  subroutine ic_send_4Ddouble(otherp,sched,data2send,tag,sts)
    integer otherp
    integer sched
    double precision, dimension (:,:,:,:) :: data2send
    integer tag
    integer sts
    type(arraydesc) :: data2send_desc
    data2send_desc = createArrayDesc(data2send)
    call ic_send_double_helper(otherp,sched,data2send_desc,tag,sts);
    call destroydoublearraydesc(data2send_desc)
  end subroutine ic_send_4Ddouble
  
  subroutine ic_recv_4Ddouble(otherp,sched,data2recv,tag,sts)
    integer otherp
    integer sched
    double precision, dimension (:,:,:,:) :: data2recv
    integer tag
    integer sts
    type(arraydesc) :: data2recv_desc
    data2recv_desc = createArrayDesc(data2recv)
    call ic_recv_double_helper(otherp,sched,data2recv_desc,tag,sts);
    call destroydoublearraydesc(data2recv_desc)
  end subroutine ic_recv_4Ddouble

  subroutine ic_create_bdecomp_desc(rank,blocks,tasks,nblocks,desc)
    integer rank
    integer, dimension (:,:,:) :: blocks
    integer, dimension (:) :: tasks
    integer nblocks
    integer :: desc
    type(arraydesc) :: blocks_desc
    type(arraydesc) :: tasks_desc
    blocks_desc = createArrayDesc(blocks)
    tasks_desc = createArrayDesc(tasks)
    call ic_create_bdecomp_desc_helper(rank,blocks_desc,tasks_desc,nblocks,desc);
    call destroyintarraydesc(tasks_desc)
    call destroyintarraydesc(blocks_desc)
  end subroutine ic_create_bdecomp_desc

  subroutine ic_create_ttable_desc(globals,locals,tasks,count,desc)
    integer, dimension (:) :: globals
    integer, dimension (:) :: locals
    integer, dimension (:) :: tasks
    integer :: count
    integer :: desc
    type(arraydesc) :: globals_desc
    type(arraydesc) :: locals_desc
    type(arraydesc) :: tasks_desc
    globals_desc = createArrayDesc(globals)
    locals_desc = createArrayDesc(locals)
    tasks_desc = createArrayDesc(tasks)
    call ic_create_ttable_desc_helper(globals_desc,locals_desc,tasks_desc,count,desc);
    call destroyintarraydesc(globals_desc)
    call destroyintarraydesc(locals_desc)
    call destroyintarraydesc(tasks_desc)
  end subroutine ic_create_ttable_desc

  subroutine ic_create_block_region(rank,lower,upper,stride,region)
    integer rank
    integer, dimension (:) :: lower
    integer, dimension (:) :: upper
    integer, dimension (:) :: stride
    integer :: region
    type(arraydesc) :: lower_desc
    type(arraydesc) :: upper_desc
    type(arraydesc) :: stride_desc
    lower_desc = createArrayDesc(lower)
    upper_desc = createArrayDesc(upper)
    stride_desc = createArrayDesc(stride)
    call ic_create_block_region_helper(rank,lower_desc,upper_desc,stride_desc,region);
    call destroyintarraydesc(lower_desc)
    call destroyintarraydesc(upper_desc)
    call destroyintarraydesc(stride_desc)
  end subroutine ic_create_block_region

  subroutine ic_create_enum_region(indices,size,region)
    integer, dimension (:) :: indices
    integer size
    integer :: region
    type(arraydesc) :: indices_desc
    indices_desc = createArrayDesc(indices)
    call ic_create_enum_region_helper(indices_desc,size,region);
    call destroyintarraydesc(indices_desc)
  end subroutine ic_create_enum_region

  subroutine ic_compute_schedule(thisp,otherp,desc,region_set,set_size,sched)
    integer thisp
    integer otherp
    integer desc
    integer, dimension (:) :: region_set
    integer set_size
    integer sched
    type(arraydesc) :: region_set_desc
    region_set_desc = createArrayDesc(region_set)
    call ic_compute_schedule_helper(thisp,otherp,desc,region_set_desc,set_size,sched);
    call destroyintarraydesc(region_set_desc)
  end subroutine ic_compute_schedule

end module intercomm_interface
