/*
 * File: gen_schedules.h
 * Auth: Jae-Yong Lee (jylee@cs.umd.edu)
 *       University of Maryland, College Park
 * Desc: Header file for generating schedules 
 * Date: Feb. 2004
 */

#ifndef GEN_SCHEDULES_H
#define GEN_SCHEDULES_H

#include "schedule.h"
#include "region.h"
#include "pgme.h"
#include "general_bsparti.h" 
#include "simple_ttable.h"
#include "global.h"

typedef struct intersection {   
  int nDims;
  int* size; /* Dim0 to Dim(nDims-2) */
  int start_LZ;
  int end_LZ;
  int* stride_LZ; /* Dim0 to Dim(nDims-2) */
  int length_LZ;  /* actual */
  int numPieces;
  block* b;       /* added for Ch2MB */
  struct intersection* next;
  int regionNum;
  int* stride;    /* Dim 0 to Dim(nDims-1) , for all dims*/
  int* start_gap; /* Dim 0 to Dim(nDims-1) , for all dims*/  
} interX;

typedef struct {
  int num;
  interX* first;
  interX* last;
} interXs;

interXs* AllocateInterXsList();
interX* AllocateInterX(int nDim);
void FreeInterXsList(interXs* list);
void FreeInterX(interX* node);
void Add_InterX(interXs* list, interX* item);

sched_s* GenerateSchedules_Two_Compacts(sched_s** tab,
					int numofblocks,
					int otherNumNodes,
					block **mine,
					block *** others,
					setOfRegion_s *my_ar_Set,
					setOfRegion_s *other_ar_Set,
					int* numblocksothers,
					int col_major,
					int col_major_other
					);

void GenerateSchedules_Mixed_On_Non_Compact(sched_s** tab,
					    sched_s** tab2,
					    void* ttable,
					    int otherNumNodes,
					    block *** others,
					    setOfRegion_s *compact_ar_Set,
					    int* numblocksothers,
					    int mem_layout,
					    pgme_s* my_pgme,
					    int overall_size);

void GenerateSchedules_Mixed_Both(sched_s** tab_other,
				  sched_s** tab_me,
				  void* ttable,
				  int otherNumNodes,
				  block *** others,
				  setOfRegion_s *compact_ar_Set, 
				  int* numblocksothers,
				  int mem_layout,
				  pgme_s* my_pgme,
				  pgme_s* other_pgme,
				  int overall_size,
				  int order);

void GenerateSchedules_Two_Non_Compacts(sched_s** tab_sched_me,
					sched_s** tab_sched_other,
					simple_ttable* table_me,
					simple_ttable* table_other,
					pgme_s* my_pgme,
					pgme_s* other_pgme,
					int OverallSize);

interXs** build_Dic_intersection_boxes(block*** block_set,
				       setOfRegion_s* ar_Set,
				       int numNodes,
				       int* numblocks,
				       int from, 
				       int to);

void compute_whole_schedules_CN_mixed(sched_s** tab_other,
				      sched_s** tab_me,
				      interXs** Xss,
				      void* ttable,
				      setOfRegion_s* compact_ar_Set,
				      int from,
				      int to,
				      int mem_layout);

interXs* gen_intersection_boxes(block* b, setOfRegion_s* ar_Set);
int Is_intersect(interX* p, interX* q);

void compute_add_scheds_CC(interXs* my_X, 
			   interXs* other_X,
			   sched_s* sched,
			   int which_proc,
			   block* b,
			   setOfRegion_s* ar_Set,
			   sched_s** tab,
			   block* other_b,
			   setOfRegion_s* other_ar_Set,
			   int col_major,
			   int col_major_other);

void comp_add_scheds_two_interXs_CC(interX* p, 
				    interX* q,
				    sched_s* scheds,
				    int which_proc,block* b,
				    setOfRegion_s* ar_Set,
				    sched_s** tab,
				    block* other_b,
				    setOfRegion_s* other_ar_Set,
				    int col_major,
				    int col_major_other);

void put_scheds_CC(int st, int end, sched_s* scheds, int which_proc, block* b, setOfRegion_s* ar_Set);
void put_scheds_CC_one_by_one(int st,int end,sched_s* scheds,int which_proc,block* b,setOfRegion_s* ar_Set, int col_major);

void put_scheds_CN(int st,
		   int end,
		   sched_s** tab_me,
		   sched_s** tab_other,
		   block* b, 
		   setOfRegion_s* ar_Set,
		   simple_ttable* ttable,
		   int from, 
		   int mem_layout);

void get_next_piece(interX* p, int* st, int* end, int count);
void print_put_interX(int st, int end, sched_s* scheds, int which_proc);
void Print_interX(interX* p);

#endif /* GEN_SCHEDULES_H */
