/*
 * File: general_bsparti.h
 * Auth: Jae-Yong Lee (jylee@cs.umd.edu)
 *       University of Maryland, College Park
 * Desc: 
 * Date: 
 */

#ifndef GENERAL_BSPARTI_H
#define GENERAL_BSPARTI_H

#include <stdio.h>

struct decomp_TREE;
struct leaf_node;

typedef struct decomp_birreg {
  int nDims;
  int col_majeur;
  struct decomp_TREE *root;
} decomp_Birreg;

typedef struct decomp_TREE {
  int nDims;
  int num_of_partitions;
  struct decomp_TREE* children;
  int *keys;
  struct leaf_node *block_info;
} Decomp_TREE;

typedef struct leaf_node {
  int proc;          /*which processor owns */
  int nDims;
  int* size;         /* in each dim.  */
  int* start_global; /* in each dim */
  int* end_global; 
  int* coord;
} leaf_Node;

typedef leaf_Node block;

decomp_Birreg* Allocate_decomp_Birreg(int nDims);
void Free_Decomp_Birreg(decomp_Birreg* decomp);
void Free_Decomp_TREE(Decomp_TREE* irr_dd);
block* Allocate_Block(int nDims);
void Free_Block(block* b);
int get_num_of_blocks(decomp_Birreg* irr_dd);
int get_num_of_blocks_TREE(Decomp_TREE* root);
block** get_my_blocks(int me, block** block_array, int num_blocks, int* num_my_blocks, int nDims);
void store_block_array_ptr(decomp_Birreg* irr_dd, block** block_array);
int store_block_array_ptrs(Decomp_TREE* root, block** block_array, int pos);
void Print_block(int dim, block* block);
void print_irr(Decomp_TREE* irr_dd);
void file_Print_block(FILE* fp, int dim, block* block);

#endif /* GENERAL_BSPARTI_H */
