// some functions originally written by Mike Beynon (beynon@cs.umd.edu)
// modified by Henrique Andrade (hcma@cs.umd.edu)
#include <assert.h>
#include <ctype.h>
#include <errno.h>
#include <iostream>
#include <iomanip>
#include <fstream.h>
#include <math.h>
#include <sys/utsname.h>
#include <stdio.h>
#include <iostream>
#include <fstream.h>
#include <string.h>
#include <sys/time.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <malloc.h>
#include <unistd.h>
#include <netdb.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#if defined(solaris)
#include <sys/systeminfo.h>
#endif /* solaris */

#if defined(linux)
#include <linux/unistd.h>
#include <linux/kernel.h>
#include <linux/sys.h>
//extern int sysinfo(struct sysinfo* info);
#endif /* linux */

#if defined(rs6000)
#include <sys/systemcfg.h>
#include <sys/cfgodm.h>
#endif /* rs6000 */
#if defined(ALPHA)
#include <unistd.h>
extern long gethostid(void);
#include <sys/systeminfo.h>
#include <sys/systeminfo.h>
#endif /* ALPHA */

#include "InterComm.h"
#include "IC_support.h"

#ifndef HZ
#  include <sys/param.h>
#endif
#if !defined(HZ) && defined(CLOCKS_PER_SEC)
#  define HZ CLOCKS_PER_SEC
#endif
#if !defined(HZ) && defined(CLK_TCK)
#  define HZ CLK_TCK
#endif

int cmp_unsigned(const void* a, const void *b) {
  if (*(unsigned **)a==NULL)
    return 1;
  if (*(unsigned **)b==NULL)
    return -1;
  return (**(unsigned **)a)-(**(unsigned **)b);
}

double convert2double(const char* str) {
  double tmp;
  unsigned i;
  
  tmp=0.0;
  for(i=0;i<strlen(str);++i) {
    tmp+=static_cast<double>(str[i]);
  }

  return tmp;
}

double convert2double(const unsigned u) {
  double tmp=static_cast<double>(u);
  return tmp;
}

double convert2double(const int i) {
  double tmp=static_cast<double>(i);
  return tmp;
}

double convert2double(const void* i) {
  double tmp=static_cast<double>(((char*)i)-(char*)(0));
  return tmp;
}

double convert2double(const double d) {
//  cout << setiosflags(ios::fixed) << "returning " << d << endl;
  return d;
}

char* ll2suffix(long long n) {
  static char str[IC_MAX_STR]="";
  static char suffix[]="bKMGTP";

  unsigned i=0;
  double res=static_cast<double>(n);
  do {
    double next=res/1024.0;
    if (next<1)
      break;
    res=next;
    i++;
  } while(1);
  sprintf(str,"%.1f%c",res,suffix[i]);

  return str;
}

long long str2ll(const char* str) {
  char* ptr=StrDup(str);
  char suffix=toupper(static_cast<int>(ptr[strlen(ptr)-1]));
  double temp;
  long long factor=1;
  if (isalpha(suffix)) {
    ptr[strlen(ptr)-1]='\0';
    temp=atof(ptr);
    switch(suffix) {
      case 'K': factor=1024; break;
      case 'M': factor=1024*1024; break;
      case 'G': factor=1024*1024*1024; break;
      default:
        cerr << "str2ll: Invalid suffix\n" << endl; break;
    }
    temp*=factor;
  }
  else 
    temp=atof(ptr);
//  cout << setiosflags(ios::fixed) << "temp: " << temp << endl;
  delete[] ptr;
  return static_cast<long long>(temp);
}

int str2int(const char* str) {
  char* ptr=StrDup(str);
  char suffix=toupper(static_cast<int>(ptr[strlen(ptr)-1]));
  float toret;
  int factor=1;
  if (isalpha(suffix)) {
    ptr[strlen(ptr)-1]='\0';
    toret=atof(ptr);
    switch(suffix) {
      case 'K': factor=1024; break;
      case 'M': factor=1024*1024; break;
      case 'G': factor=1024*1024*1024; break;
      default:
        cerr << "str2int: Invalid suffix\n" << endl; break;
    }
    toret*=factor;
  }
  else
    toret=atof(ptr);
  delete[] ptr;
  return static_cast<int>(toret);
}

#if defined(linux)
int parseProcFile(istream &is, char *sbPrefix,
                    char *sbOutBuf, int lenOutBuf) {
  int len;
  while (1) {
    len = lenOutBuf;
    if (! is.getline(sbOutBuf, len, '\n')) return 0;
    if (strncmp(sbOutBuf, sbPrefix, strlen(sbPrefix)) == 0) {
      // found the line
      char *p = strstr(sbOutBuf, ": ");
      if (!p) return 1;  // found whole line
      // copy the part of the string after colon to the front of the buffer
      char *q = sbOutBuf;
      p += 2;  // skip colon and spaces
      while (*p) {
        *(q++) = *(p++);
      }
      *q = '\0';
      return 1;
    }
  }
}
#endif /* linux */

// int getCpuInfo(const bool verbose) {
//   int  nProcs;
// #if defined(solaris) || defined(ALPHA)
//   nProcs = sysconf(_SC_NPROCESSORS_CONF);
//   if (verbose)
//     cout << "num_cpu = " << nProcs << endl;
// #elif defined(rs6000)
//   nProcs = _system_configuration.ncpus;
//   cout << "num_cpu = " << nProcs << endl;
// #elif defined(rs6000)
// #elif defined(linux)
//   nProcs=0;
//   ifstream in("/proc/cpuinfo");
//   if (in) {
//     char buf[512];
//     char arch[512];
//     while (parseProcFile(in, "model name", buf, 512)) {
//       ++nProcs;

//       if (strncmp(buf, "Pentium", 7) == 0) {
//         sprintf(arch, "x86 %s", buf);
//       } // other cpu type names follow here
//     }
//     // just assume all are the same, and output the last one
//     if (verbose && nProcs > 0) {
//       cout << "num_cpu = " << nProcs << endl;
//       cout << "architecture = " << arch << endl;
//     }
//   }
// #else
// #  error Undefined out_cpuinfo()
// #endif
//   return nProcs;
// }


#if defined(linux)
unsigned long long getMemInfo(const unsigned which) {
  fstream ifn("/proc/meminfo",ios::in);
  assert(ifn);
  char trash[IC_MAX_STR];
  // getting rid of the first line
  ifn.get(trash,IC_MAX_STR,'\n');
  assert(!ifn.fail());
  unsigned long long mem[6];
  // getting rid of "Mem: " 
  ifn.get(trash,IC_MAX_STR,' ');
  assert(!ifn.fail());
  ifn >> mem[MEM_TOTAL] >> mem[MEM_USED] >> mem[MEM_FREE] >> mem[MEM_SHARED] >> mem[MEM_BUFFERS] >> mem[MEM_CACHED];
  assert(!ifn.fail());
  ifn.close();
  return mem[which];
}
#elif defined(solaris)
unsigned long long getMemInfo(const unsigned which) {
  long nphpages=sysconf(_SC_PHYS_PAGES);
  long pagesize=sysconf(_SC_PAGESIZE);
  return static_cast<unsigned long long>(nphpages)*pagesize;
}
#endif

double getWallClock(void) {
  struct timeval  tval;
  int ret = gettimeofday(&tval,NULL);
  if (ret<0) return -1.0;
  return ((double) ((double)tval.tv_sec+(double)tval.tv_usec/1000000.0));
}

double getWallClockTime(void) {
  struct timeval tval;
  int ret=gettimeofday(&tval,NULL);
  assert(ret==0);
  return tval.tv_sec+tval.tv_usec/static_cast<double>(1000000.0);
}

// ****************************************************************************
//  Name: StrDup
//  Desc: Duplicate a string by creating new space and copying it.
//  Date: 04/10/1994 : mdb - Created.
//
//  Inputs: sb - string to duplicate
//  Return: char* - points to new string
// ****************************************************************************
char* StrDup(const char *sb) {
  if (!sb) return NULL;
  char *sbTmp = new char[strlen(sb) + 1];
  strcpy(sbTmp, sb);
  return sbTmp;
}

// ****************************************************************************
//  Name: strrstr
//  Desc: Obvious counterpart to strstr, but does not seem to exist.
//  Date: 01/08/2000 : mdb - Created.
//
//  Inputs: sbStr - string to search
//          sbSub - substring to look for
//  Return: char* - pointer to beginning of substring in sb
// ****************************************************************************
char *StrRStr(const char *sbStr, const char *sbSub) {
  char ch, *p, *pSub = (char *)sbSub;
  int  wLen;

  ch = *pSub++;
  if (ch == '\0') return (char *)sbStr; // arbitrary return (undefined)
  wLen = strlen(pSub);

  for (p=(char *)sbStr+strlen(sbStr)-1; p >= sbStr; --p) {
    if (*p == ch && strncmp(p+1, pSub, wLen) == 0) return p;  // found
  }
  return NULL;
}

// ****************************************************************************
//  Name: StrNDup
//  Desc: Duplicate a string by creating new space and copying up to N of it.
//  Date: 07/30/1997 : mdb - Created.
//
//  Inputs: sb - string to duplicate
//          n  - max chars to dup
//  Return: char* - points to new string
// ****************************************************************************
char *StrNDup(const char *sb, int n) {
  char *sbTmp;
  int   len;

  if (!sb) return NULL;
  len = strlen(sb);

  if (len > n) len = n;

  sbTmp = new char[len + 1];
  strncpy(sbTmp, sb, len);
  sbTmp[len] = '\0';
  return sbTmp;
}

char* MemDup(const char* src, const unsigned srcsize) {
  if (!src) return NULL;
  assert(srcsize);
  char* dest=new char[srcsize];
  memcpy(dest,src,srcsize);
  return dest;
}

char* StrNCpy(char* dest, const char* src, const unsigned maxsize) {
  char* ret=strncpy(dest,src,maxsize-1);
  dest[maxsize-1]='\0';
  return ret;
}

char* StrNCat(char* dest, const char* src, const unsigned maxsize) {
  char* ret=strncat(dest,src,maxsize-1);
  dest[maxsize-1]='\0';
  return ret;
}


char* BaseName(const char* path, char* ans, const unsigned maxsize) {
  const char* ptr=path+(strlen(path)-1);
  while(*ptr!='/' && ptr>path) {
    ptr--;
  }
  if (*ptr!='/')
    return StrNCpy(ans,path,maxsize);
  return StrNCpy(ans,ptr+1,maxsize);
}

char* DirName(const char* path, char *ans, const unsigned maxsize) {
// gets the directory name from a complete filename (with path)
  const char* ptr=path+(strlen(path)-1);
  while(*ptr!='/' && ptr>path) {
    ptr--;
  }
  if (*ptr!='/')
    return StrNCpy(ans,".",maxsize);
  return StrNCpy(ans,path,ptr-path+1);
}

void replaceAll(char* str, const char oldchar, const char newchar) {
  unsigned i;
  for(i=0;i<strlen(str);++i) {
    if (str[i]==oldchar)
      str[i]=newchar;
  }
}

#if !defined(ALPHA) && !defined(AIX)
// this is a _np (non-portable) routine that does not exist in solaris/linux
int pthread_get_expiration_np(const struct timespec *delta,
				     struct timespec *abstime) {
  if (delta->tv_sec < 0 ||
      delta->tv_nsec < 0 || delta->tv_nsec >= NSEC_PER_SEC) {
    return EINVAL;
  }
#if defined(SUNOS5)
  clock_gettime(CLOCK_REALTIME, abstime);
#else
  struct timeval tv;
  struct timezone tz;
  if (gettimeofday(&tv, &tz) != 0) return 0; // failed
  abstime->tv_sec = tv.tv_sec;
  abstime->tv_nsec = tv.tv_usec / 1000;
#endif
  abstime->tv_sec += delta->tv_sec;
  abstime->tv_nsec += delta->tv_nsec;
  if (abstime->tv_nsec >= NSEC_PER_SEC) {
    int sec = abstime->tv_nsec / NSEC_PER_SEC;
    abstime->tv_sec += sec;
    abstime->tv_nsec -= sec * NSEC_PER_SEC;
  }
  return 0;
}
#endif

void writeNTStr(const int descriptor, const char* str) {
  unsigned size=strlen(str);
  // write the size
  int ret=write(descriptor,&size,sizeof(size));
  if (ret<0) 
    perror("write");
  assert(ret==sizeof(size));
  // write the null terminated string
  ret=write(descriptor,str,size);
  if (ret<0) 
    perror("write");
  assert(ret==static_cast<int>(size));
}

void writeBlob(const int descriptor, const char* blob, const unsigned bsize) {
  // write the size
  int ret=write(descriptor,&bsize,sizeof(bsize));
  assert(ret==sizeof(bsize));
  // write the blob
  int written=0;
  do {
    ret=write(descriptor,blob+written,bsize-written);
    if (ret<0) {
      perror("writeBlob");
      exit(-1);
    }
    written+=ret;
  } while(written<static_cast<int>(bsize));
  assert(written==static_cast<int>(bsize));
}

void readNTStr(const int descriptor, char*& str) {
  // read the string size
  unsigned size;
  int ret=read(descriptor,&size,sizeof(size));
  assert(ret==sizeof(size));
  str=new char[size+1];
  // read the string
  ret=read(descriptor,str,size);
  if (ret!=static_cast<int>(size)) {
    perror("readNTStr");
    exit(-1);
  }
  assert(ret==static_cast<int>(size));
  str[size]='\0';
}

unsigned readBlobSize(const int descriptor) {
  // read the blob size
  unsigned bsize;
  int ret=read(descriptor,&bsize,sizeof(bsize));
  if (ret!=sizeof(bsize)) {
    perror("readBlobSize");
    exit(-1);
  }
  assert(ret==sizeof(bsize));
  return bsize;
}

void readBlob(const int descriptor, char* blob, const unsigned bsize) {
  // read the blob
  int nread=0;
  do {
    // I was getting interrupted system call, that's why I implemented the loop
    int ret=read(descriptor,blob+nread,bsize-nread);
    if (ret<0) {
      perror("readBlob");
      exit(-1);
    }
    nread+=ret;
  } while(nread<static_cast<int>(bsize));
  assert(nread==static_cast<int>(bsize));
}

#if defined(solaris)
// solaris in a Sun machine is big endian
// network byte order is big endian
double htond(const double hostdouble) {
  return hostdouble;
}

double ntohd(const double netdouble) {
  return netdouble;
}

float htonf(const float hostfloat) {
  return hostfloat;
}

float ntohf(const float netfloat) {
  return netfloat;
}
#endif

#if defined(linux)
// linux in a PC machine is little endian
// network byte order is big endian
double htond(double hostdouble) {
  double netdouble;
  char *from=(char *)&hostdouble;
  char *to=(char *)&netdouble;
  unsigned i;
#ifdef DEBUG
  cout << "htond " << hostdouble;
#endif
  for(i=0;i<sizeof(double);++i) {
    to[i]=from[sizeof(double)-i-1];
#ifdef DEBUG
    cout << " " << static_cast<unsigned>(0xFF & from[i]);
#endif
  }
#ifdef DEBUG
  cout << endl;
#endif
  return netdouble;
}

double ntohd(const double netdouble) {
  double hostdouble;
  char *to=(char *)&hostdouble;
  char *from=(char *)&netdouble;
  unsigned i;
#ifdef DEBUG
  cout << "ntohd";
#endif
  for(i=0;i<sizeof(double);++i) {
    to[i]=from[sizeof(double)-i-1];
#ifdef DEBUG
    cout << " " << static_cast<unsigned>(0xFF & to[i]);
#endif
  }
#ifdef DEBUG
  cout << " " << hostdouble << endl;
#endif
  return hostdouble;
}

float htonf(const float hostfloat) {
  float netfloat;
  char *from=(char *)&hostfloat;
  char *to=(char *)&netfloat;
  unsigned i;
  for(i=0;i<sizeof(float);++i)
    to[i]=from[sizeof(float)-i-1];
  return netfloat;
}

float ntohf(const float netfloat) {
  float hostfloat;
  char *to=(char *)&hostfloat;
  char *from=(char *)&netfloat;
  unsigned i;
  for(i=0;i<sizeof(float);++i)
    to[i]=from[sizeof(float)-i-1];
  return hostfloat;
}
#endif

void GetMyIPAddress(char* ipstr) {
  char hostname[IC_MAX_STR];
  assert(gethostname(hostname,IC_MAX_STR)==0);
  struct hostent* he=gethostbyname(hostname);
//  cout << gethostid() << endl;
  assert(he);
  struct in_addr addr;
  memcpy(&addr.s_addr,he->h_addr_list[0], he->h_length);
  strcpy(ipstr,inet_ntoa(addr));
}

void err_doit(int errnoflag, const char *fmt, va_list ap) {
// Print a message and return to caller
// Caller specifies "errnoflag"
  int errno_save;
  char buf[IC_MAX_STR];

  errno_save = errno;		// value caller might want printed
  vsprintf(buf, fmt, ap);
  if (errnoflag)
    sprintf(buf + strlen(buf), ": %s", strerror(errno_save));
  strcat(buf, "\n");
  fflush(stdout);		// in case stdout and stderr are the same
  fputs(buf, stderr);
  fflush(stderr);
}

void err_ret(const char *fmt, ...) {
// Nonfatal error related to a system call.
// Print a message and return. 
  va_list ap;

  va_start(ap, fmt);
  err_doit(1, fmt, ap);
  va_end(ap);
}

void err_sys(const char *fmt, ...) {
// Fatal error related to a system call.
// Print a message and terminate.
  va_list ap;

  va_start(ap, fmt);
  err_doit(1, fmt, ap);
  va_end(ap);
#ifdef PARALLEL
  MPI_Abort(MPI_COMM_WORLD, -1);
#endif
  exit(1);
}

void err_msg(const char *fmt, ...) {
// Nonfatal error unrelated to a system call
// Print a message and return
  va_list ap;

  va_start(ap, fmt);
  err_doit(0, fmt, ap);
  va_end(ap);
}

void err_quit(const char *fmt, ...) {
// Fatal error unrelated to a system call
// Print a message and terminate
  va_list ap;

  va_start(ap, fmt);
  err_doit(0, fmt, ap);
  va_end(ap);
#ifdef PARALLEL
  MPI_Abort(MPI_COMM_WORLD, -1);
#endif
  exit(1);
}

template<class typeT>
inline typeT fracPart(const typeT n) {
  return n-static_cast<typeT>(static_cast<int>(n));
}

template<class typeT>
inline typeT positiveFracPart(const typeT n) {
  typeT factor=static_cast<typeT>(n < 0 ? -1 : 1);
  return (n-static_cast<typeT>(static_cast<int>(n)))*factor;
}

template<class typeT>
inline bool isExact(const typeT n, const typeT precision) {
  typeT factor=0;
  if (n<0)
    factor=-0.5;
  else
    factor=0.5;
  typeT temp=static_cast<typeT>(static_cast<int>(n+factor))-n;

  if (temp<0)
    return (-1*temp)<precision;

  return temp<precision;
}

template<class typeT>
inline bool isEqual(const typeT x, const typeT y, const typeT precision) {
  typeT diff=x-y;
  if (diff<0)
    diff*=static_cast<typeT>(-1);
  return diff<precision;
}

unsigned i6862solarisu(unsigned i686u) {
  return solaris2i686u(i686u);
}

unsigned solaris2i686u(unsigned solarisu) {
  unsigned i686u;
  char *from=(char *)&solarisu;
  char *to=(char *)&i686u;
  unsigned i;
#ifdef DEBUG
  cout << "solaris2linux " << solarisu;
#endif
  for(i=0;i<sizeof(unsigned);++i) {
    to[i]=from[sizeof(unsigned)-i-1];
#ifdef DEBUG
    cout << " " << static_cast<unsigned>(0xFF & from[i]);
#endif
  }
#ifdef DEBUG
  cout << endl;
#endif
  return i686u;
}

void* meminit(void* s1, const void* s2, unsigned n, size_t size) {
  unsigned i, j;
  char* t1=(char*)s1;
  const char* t2=(const char*)s2;
  for(i=0;i<n;++i) {
    for(j=0;j<size;++j)
      *(t1+(i*size)+j)=*(t2+j);
  }
  return s1;
}

int USleep(const unsigned long int useconds) {
  struct timespec rqtp;

  rqtp.tv_sec  = useconds / (unsigned long)  1000000;
  rqtp.tv_nsec = (useconds % (unsigned long) 1000000) * 1000 ;

  int ret=nanosleep(&rqtp,(struct  timespec *)NULL);
  assert(errno!=EINVAL && errno!=ENOSYS);
  return ret;
}
