#ifndef IC_UTIL_H
#define IC_UTIL_H

#include <pthread.h>
#include <iostream>
#include <math.h>
#include <A++.h>
#include "IC_support.h"

// define this for error checking and reporting info at runtime
//#define DC_UTIL_DEBUG

class Mutex {
private:
  pthread_mutex_t mutex;
#if defined(DC_UTIL_DEBUG)
  char     *sbName;
  bool      fLocked;
  pthread_t tidOwner;
#endif /* DC_UTIL_DEBUG */

public:
  Mutex(char *sbName=NULL, pthread_mutexattr_t *pattr=NULL);
  ~Mutex(void);

  void lock(void);
  void unlock(void);

  // return T if it was locked
  bool trylock(void);

  void setOwner(void);  // called by cond to change ownership

  inline pthread_mutex_t &getNative(void) { return mutex; };
};

template<class entryT> class RArray;
#ifndef INSURE
template<class entryT> std::ostream& operator<< (std::ostream& o, const RArray<entryT>& b);
#endif

template<class entryT>
class RArray {
  public:
    RArray(const unsigned mymaxelements=1, const bool mycompactIt=false);
    RArray(const RArray<entryT>& la);
    RArray(const entryT* arr, const unsigned size, const int mymaxelements=-1);
    virtual RArray<entryT>& operator=(const RArray<entryT>& la);
    virtual RArray<entryT>& assign(const RArray<entryT>& la);
    virtual void resize();
    virtual unsigned compact();
    /*
    virtual void addABunch(const unsigned nel,...);
    */
    virtual void add(const entryT& el);
    virtual void removeEntryAt(const unsigned i);
    virtual void addElementAt(const unsigned i, const entryT& el);
    virtual void sort(int (*compar)(const void *a, const void *b)=NULL);
    virtual entryT* getElement(const unsigned i) const;
    virtual void setElement(const unsigned i, const entryT* el, 
      const bool deleteOld=true);
    virtual entryT* find(const entryT& myentry, int (*compar)(const void *, const void *)=cmp_unsigned) const;
    virtual int ord(const entryT& myentry, int (*compar)(const void *, const void *)=cmp_unsigned) const;
    virtual void destroy();
    inline virtual bool isSorted() const { return sorted; };
    inline virtual void setSorted() { sorted=true; };
    virtual void invert();
    inline virtual unsigned getNElements() const { return nelements; }; 
    inline virtual unsigned getMaxElements() const { return maxelements; };
    virtual void intersection(const RArray<entryT>& ra, 
        const RArray<entryT>& rb, int (*compar)(const void *a, const void *b));
    virtual void difference(const RArray<entryT>& ra, 
        const RArray<entryT>& rb, int (*compar)(const void *a, const void *b));
    virtual bool contains(const RArray<entryT>& ra, 
        int (*compar)(const void *a, const void *b)) const;
    virtual bool isEqual(const RArray<entryT>& ra, 
        int (*compar)(const void *a, const void *b)) const;
    virtual ~RArray();
  protected:
#ifndef INSURE
    virtual void printOn(std::ostream& o) const;
#endif
    entryT** container;
    unsigned nelements;
    unsigned maxelements;
    bool sorted;
    bool compactIt;
};

const unsigned CF_STRLEN=256;

const unsigned CF_READING_ATTRIBUTES=1;
const unsigned CF_READING_VALUES=2;

const int CF_OK       =  0;
const int CF_CANTOPEN = -1;

class CF_AttrType {
  public:
    CF_AttrType(const char* myname=NULL, const unsigned maxvalues=1);
    CF_AttrType(const CF_AttrType& a);
    ~CF_AttrType();
  private:
    char const* name;
    RArray<char const*> values;
    bool inspected;
friend class ConfFile;
#ifndef INSURE
friend std::ostream& operator<< (std::ostream& o, const CF_AttrType& a);
#endif
};

class CF_SectionType {
  public:
    CF_SectionType(const char* myname=NULL, const unsigned maxattrs=2);
    CF_SectionType(const CF_SectionType& s);
    ~CF_SectionType();
  private:
    char const* name;
    RArray<CF_AttrType> attrs;
friend class ConfFile;
#ifndef INSURE
friend std::ostream& operator<< (std::ostream& o, const CF_SectionType& s);
#endif
};

class ConfFile {
  public:
    ConfFile(); 
    ConfFile(const ConfFile&);
    int readConfFile(const char *filename);
    int getNSections() const;
    int getNSectionEntries(const char *section) const;
    int getNAttrEntries(const char *section, const char *attr) const;
    const char* getValue4(const char *section, const char *attr) const;
    const char* getValue4N(const char *section, const char *attr, const unsigned n) const;
    int getPosition(const char *section, const char *attr, const char *val) const;
    bool areThereAnyNonInspectedEntries() const;
    ~ConfFile();
  private:
    void removeAllSpaces(char *line) const;
    char* my_strtok(const char *str, const char *delim) const;
    RArray<CF_SectionType> sects;
    int lastErrno;
#ifndef INSURE
friend std::ostream& operator<< (std::ostream& o, const ConfFile& cf);
#endif
};

#ifdef PPLUSPLUS
void gnuplot(const char* prefix, const doubleArray& a, const double baseX, 
      const double dX, const double baseY, const double dY, const unsigned ts);
#endif

#endif
