#include "pgme.h"
#include "global.h"
#include "util.h"
#include "error.h"
#include "intercomm.h"
#include <stdlib.h>
#include <stdio.h>
#include <pvm3.h>
#include <string.h>
#include <unistd.h>

pgme_s* ic_this_program = 0;
/* int joinedAnyPgme = 0; */
/* char AnyPgmeName[] = "XYZ123__"; */

/* retained for old Sync2Pgme */
char tout_gp[] = "TousLesGp";
int _joined_gp = 0;

IC_Program* IC_Init(char* name, int tasks, int rank) {
  IC_Program* prog;
  int i, tid;

  setcall("IC_Init");
  if (name == 0 || tasks < 1 || rank < 0) {
    errormsg("invalid parameters");
    return 0;
  }
  
  if ((tid = pvm_mytid()) < 0) {
    errormsg("communication subsystem error");
    return 0;
  }

  if (rank == 0) {
    if (pvm_joingroup(name) < 0) {
      errormsg("program name matches existing PVM group name");
      return 0;
    }
  } else {
    while (pvm_gsize(name) != rank)
      sleep(1);
    if (pvm_joingroup(name) < 0) {
      errormsg("communication subsystem error");
      return 0;
    }
  }
  
  if (pvm_barrier(name, tasks) < 0) {
    errormsg("communication subsystem error");
    return 0;
  }
  
  prog = (IC_Program*)malloc(sizeof(IC_Program));
  prog->nbNode = tasks;
  prog->name = strdup(name);
  prog->tid = (int*)calloc(prog->nbNode, sizeof(int));
  prog->myPos = rank;
  prog->joined = 0;
  for (i = 0; i < prog->nbNode; ++i) {
    prog->tid[i] = pvm_gettid(name, i);
    if (i == rank && prog->tid[i] != tid) {
      errormsg("incorrect group rank assignment for this task");
      free(prog->tid);
      free(prog->name);
      free(prog);
      return 0;
    }
  }
  
  ic_this_program = (pgme_s*)prog;
  return prog;
}

IC_Program* IC_Wait(char* name, int tasks) {
  IC_Program* prog;
  int i;

  setcall("IC_Wait");
  if (name == 0 || tasks < 1) {
    errormsg("invalid parameters");
    return 0;
  }

  prog = (IC_Program*)malloc(sizeof(IC_Program));
  prog->nbNode = tasks;
  prog->name = strdup(name);
  prog->tid = (int*)calloc(prog->nbNode, sizeof(int));
  prog->myPos = -1;
  prog->joined = 0;
  while (pvm_gsize(name) < tasks) {
    sleep(1);
  }
  for (i = 0; i < tasks; i++) {
    prog->tid[i] = pvm_gettid(name, i);
  }

  return prog;
}

int IC_Sync(IC_Program* myprog, IC_Program* prog) {
  char* group;
  
  setcall("IC_Sync");
  if (myprog == 0 || prog == 0) {
    errormsg("invalid parameters");
    return -1;
  }
  
  if (prog->joined == 0) {
    group = (char*)calloc(strlen(myprog->name)+strlen(prog->name)+2, sizeof(char));
    if (strcmp(myprog->name, prog->name) > 0) 
      sprintf(group, "%s2%s", myprog->name, prog->name);
    else
      sprintf(group, "%s2%s", prog->name, myprog->name);
    
    if (pvm_joingroup(group) < 0) {
      errormsg("communication subsystem error");
      free(group);
      return -1;
    }
    prog->joined = group;
  }
  
  if (pvm_barrier(prog->joined, myprog->nbNode + prog->nbNode) < 0) {
    errormsg("communication subsystem error");
    return -1;
  }
  
  return 0;
}

void IC_Free_program(IC_Program* prog) {
  if (prog) {
    if (prog->joined) {
      pvm_lvgroup(prog->joined);
      free(prog->joined);
    }
    free(prog->tid);
    free(prog->name);
    free(prog);
  }
}

void IC_Quit(IC_Program* myprog) {
  if (myprog) {
    free(myprog->tid);
    pvm_lvgroup(myprog->name);
    free(myprog->name);
    free(myprog);    
    ic_this_program = 0;
  }
}

int PrintPgme(pgme_s *pgme) {
  fprintf(stderr,"\n-----------------");
  fprintf(stderr,"\n nbNode=%i ",pgme->nbNode);
  fprintf(stderr,"\n name=%s ",pgme->name);
  fprintf(stderr,"\n tids ... ");
  fprintf(stderr,"\n myPos=%i ",pgme->myPos);
  fprintf(stderr,"\n-----------------\n");
}

/* DEPRECIATED: CLH 01/15/04 */
/* pgme_s *InitPgmeMe(char *name, int numnode, int me) { */
/*   char name1[100]; */
/*   pgme_s *pgme; */
/*   int mytid; */
/*   int i; */
  
/*   sprintf(name1,"%s_1",name); */
/*   pgme=malloc(sizeof(pgme_s)); */
/*   pgme->nbNode=numnode; */
/*   pgme->name=(char *)malloc(strlen(name)+1); */
/*   sprintf(pgme->name,"%s",name); */
/*   pgme->tid=(int *)malloc(sizeof(int)*numnode); */
  
/*   mytid=pvm_mytid(); */
/*   pvm_joingroup(name1); */
/*   pvm_barrier(name1,numnode); */
  
/*   while (pvm_gsize(name)!=me) { */
/*     if (me==0 && pvm_gsize(name)<0) break; */
/*     sleep(1); */
/*   } */
  
/*   pvm_joingroup(name); */
/*   pvm_barrier(name,numnode); */

/*   pgme->myPos=-1; */
/*   for (i=0;i<numnode;i++) { */
/*     pgme->tid[i]=pvm_gettid(name,i); */
/*     if (mytid==pgme->tid[i]) pgme->myPos=i; */
/*     if (mytid==pgme->tid[i] && me!=i) */
/*       warning("en utilisant l initialization de Bongki");  */
/*   } */
  
/*   pvm_setopt(PvmRoute,PvmRouteDirect); */
/*   pvm_setopt(PvmFragSize,GlueFragBuffer); */
  
/*   ic_this_program=pgme; */
  
/*   return(pgme); */
/* } */

pgme_s *WaitPgme(char *nom, int numnode) {
  pgme_s *pgme;
  int i;

  pgme = (pgme_s*)malloc(sizeof(pgme_s));
  pgme->nbNode = numnode;
  pgme->name = (char*)calloc(strlen(nom) + 1, sizeof(char));
  sprintf(pgme->name, "%s", nom);
  pgme->tid = (int*)calloc(numnode, sizeof(int));
  pgme->myPos = -1;
  while (pvm_gsize(nom) != numnode)
    sleep(1);
  for (i = 0; i < numnode; i++)
    pgme->tid[i] = pvm_gettid(nom, i);
  
  return pgme;
}

int MyPosPgme(pgme_s *pgme) {
  return pgme->myPos;
}

/* DEPRECIATED: CLH 01/15/04 */
/* int MyTidPgme(pgme_s *pgme) { */
/*   if (pgme->myPos == -1) */
/*     return -1; */
/*   return TidPgme(pgme,pgme->myPos); */
/* } */

int TidPgme(pgme_s *pgme, int num) {
  return (pgme->tid)[num];
}

int NumNodePgme(pgme_s *pgme) {
  return pgme->nbNode;
}

void FreePgme(pgme_s *pgme) {
  free(pgme->tid);
  free(pgme->name);
  free(pgme);
}

void SyncPgme(pgme_s *pgme) {
  int i;

  pvm_initsend(GlueEncoding);
  pvm_send(TidPgme(pgme,0), 1005);     
  if (MyPosPgme(pgme) == 0) { 
    for (i = 0; i < NumNodePgme(pgme); i++)       
      pvm_recv(-1, 1005);  
    pvm_initsend(GlueEncoding); 
    for (i = 0; i < NumNodePgme(pgme); i++)
      pvm_send(TidPgme(pgme,i), 1006);    
  }
  pvm_recv(TidPgme(pgme,0), 1006);     
}

/* DEPRECIATED: CLH 01/15/04 */
/* void *getPtFromId() { */
/*   return NULL; */
/* } */

int Sync2Pgme(pgme_s *pgme1, pgme_s *pgme2) {
  int numnode;
  
  if (_joined_gp == 0) {
    pvm_joingroup(tout_gp);
    _joined_gp++;
  }  
  numnode = NumNodePgme(pgme1) + NumNodePgme(pgme2);
  return pvm_barrier(tout_gp, numnode);
}

/* DEPRECIATED: CLH 01/15/04 */
/* int Tid2PosPgme(pgme_s *pgme, int tid) { */
/*   int i; */
  
/*   for (i = 0; i < pgme->nbNode; i++) */
/*     if (pgme->tid[i] == tid) */
/*       return i; */
/*   return -1; */
/* } */
