/*
 * File: simple_ttable.c
 * Auth: Jae-Yong Lee (jylee@cs.umd.edu)
 *       University of Maryland, College Park
 * Desc: 
 * Date: 
 */

#include "simple_ttable.h"
#include <stdio.h>
#include <stdlib.h>

simple_ttable* Allocate_Simple_TTABLE(int nData)
{
  simple_ttable* table;
  
  table = (simple_ttable*)malloc(sizeof(simple_ttable));  
  table->nData = nData;
  table->global_index=(int*)malloc(sizeof(int)*table->nData);
  table->local_offset=(int*)malloc(sizeof(int)*table->nData);
  table->proc_num=(int*)malloc(sizeof(int)*table->nData);  
  table->global_low_bound = table->global_high_bound = -1;
  
  return table;
}

void FreeSimpleTable(simple_ttable* table)
{
  if (table) {
    if (table->nData > 0) {
      free(table->global_index);
      free(table->proc_num);
      free(table->local_offset);
    }
    free(table);
  }
}

void Print_simple_ttable(simple_ttable* table)
{
  int i;
  
  printf("--- Simple TTable\n");
  printf("nData = %d\n",table->nData);
  for (i = 0; i < table->nData; i++) {
    printf("global=%d\n", table->global_index[i]);
    printf("procnum=%d\n", table->proc_num[i]);
    printf("local_off=%d\n", table->local_offset[i]);
  }
}
