#include <sys/time.h>
#ifndef SUN
#include <sys/time.h>
#else
#include <sys/timer.h>
#endif

#include <pvm3.h>
#include <stdio.h>
#include "global.h"
#include "pgme.h"

#define MAX_TIMER 20
#define min(a,b) ((a<b)?a:b)
#define max(a,b) ((a>b)?a:b)

int start_time[MAX_TIMER];
int add_time[MAX_TIMER];

void init_timers() 
{
  int i;
  for (i=0;i<MAX_TIMER;i++)
    add_time[i]=0;
  for (i=0;i<MAX_TIMER;i++)
    start_time[i]=0;
  printf("\nWarning I have put a Synchronization before every start timer \n");

}

void start_timer(int timer) 
{
  struct timeval tp;
  struct timezone tz;
  
  SyncPgme(ic_this_program);
  
  gettimeofday (&tp,&tz);
  start_time[timer] = tp.tv_sec * 1000000 + tp.tv_usec;
}

void start_timer_1(int timer) 
{
  struct timeval tp;
  struct timezone tz;
    
  gettimeofday (&tp,&tz);
  start_time[timer] = tp.tv_sec * 1000000 + tp.tv_usec;
}

void stop_timer(int timer) {
  struct timeval tp;
  struct timezone tz;

  gettimeofday (&tp,&tz);
  add_time[timer] += tp.tv_sec * 1000000 + tp.tv_usec - start_time[timer] ;
}

void write_timer(int timer, FILE *F)
{
  fprintf(F," %i ",add_time[timer]/1000);
}

void print_timer(int timer)
{
  write_timer(timer,stdout);
}

int return_timer(int timer)
{
  return(add_time[timer]);
}

int return_timer_max(int timer)
{
  int i,tmp,result;
  
  pvm_initsend(GlueEncoding);
  pvm_pkint(&(add_time[timer]),1,1);
  pvm_send(TidPgme(ic_this_program,0),1007);     
  if (MyPosPgme(ic_this_program)==0)
    {
      result=add_time[timer];
      for (i=0;i<NumNodePgme(ic_this_program);i++)
	{
	  pvm_recv(TidPgme(ic_this_program,i),1007);     
	  pvm_upkint(&tmp,1,1);
	  result=max(result,tmp);
	}
      for (i=0;i<NumNodePgme(ic_this_program);i++)
	{
	  pvm_initsend(GlueEncoding);
	  pvm_pkint(&(result),1,1);
	  for (i=0;i<NumNodePgme(ic_this_program);i++)
	    pvm_send(TidPgme(ic_this_program,i),1007);     
	}
    }
  pvm_recv(TidPgme(ic_this_program,0),1007);     
  pvm_upkint(&result,1,1);

  SyncPgme(ic_this_program);

  return(result);
}

int return_timer_min(int timer)
{
  int i,tmp,result;

  pvm_initsend(GlueEncoding);
  pvm_pkint(&(add_time[timer]),1,1);
  pvm_send(TidPgme(ic_this_program,0),1008);     
  if (MyPosPgme(ic_this_program)==0)
    {
      result=add_time[timer];
      for (i=0;i<NumNodePgme(ic_this_program);i++)
	{
	  pvm_recv(TidPgme(ic_this_program,i),1008);     
	  pvm_upkint(&tmp,1,1);
	  result=min(result,tmp);
	}
      for (i=0;i<NumNodePgme(ic_this_program);i++)
	{
	  pvm_initsend(GlueEncoding);
	  pvm_pkint(&(result),1,1);
	  for (i=0;i<NumNodePgme(ic_this_program);i++)
	    pvm_send(TidPgme(ic_this_program,i),1008);     
	}
    }
  pvm_recv(TidPgme(ic_this_program,0),1008);     
  pvm_upkint(&result,1,1);

  SyncPgme(ic_this_program);

  return(result);
}

void write_timer3(int timer, FILE *F)
{
  fprintf(F," %i %i %i (ms) ",
	  return_timer_min(timer)/1000,
	  return_timer(timer)/1000,
	  return_timer_max(timer)/1000);	  
}

int return_timer_avg(int timer)
{
  int i,tmp;
  int result;
  int sum = 0;

  pvm_initsend(GlueEncoding);
  pvm_pkint(&(add_time[timer]),1,1);
  pvm_send(TidPgme(ic_this_program,0),1008);     
  if (MyPosPgme(ic_this_program)==0)
    {
      result=add_time[timer];
      for (i=0;i<NumNodePgme(ic_this_program);i++)
	{
	  pvm_recv(TidPgme(ic_this_program,i),1008);     
	  pvm_upkint(&tmp,1,1);
	  /*	  result=min(result,tmp);
	   */
	  sum += tmp;
	}
      result = sum/NumNodePgme(ic_this_program);

      for (i=0;i<NumNodePgme(ic_this_program);i++)
	{
	  pvm_initsend(GlueEncoding);
	  pvm_pkint(&(result),1,1);
	  for (i=0;i<NumNodePgme(ic_this_program);i++)
	    pvm_send(TidPgme(ic_this_program,i),1008);     
	}
    }
  pvm_recv(TidPgme(ic_this_program,0),1008);     
  pvm_upkint(&result,1,1);

  SyncPgme(ic_this_program);

  return(result);
}
