/* block decompositions */
int BD2[DESCS2][TASKS][2][2] = {
  {
    /* decomposition 0 */
    {{0,0},{3,3}}, /* block 0 */
    {{0,4},{3,7}}, /* block 1 */
    {{4,0},{7,3}}, /* block 2 */
    {{4,4},{7,7}}  /* block 3 */
  },{
    /* decomposition 1 */
    {{0,0},{2,3}}, /* block 0 */
    {{0,4},{4,7}}, /* block 1 */
    {{3,0},{7,3}}, /* block 2 */
    {{5,4},{7,7}}  /* block 3 */
  },{
    /* decomposition 2 */
    {{0,0},{3,2}}, /* block 0 */
    {{0,3},{3,7}}, /* block 1 */
    {{4,0},{7,4}}, /* block 2 */
    {{4,5},{7,7}}  /* block 3 */
  },{
    /* decomposition 3 */
    {{0,0},{1,7}}, /* block 0 */
    {{2,0},{3,7}}, /* block 1 */
    {{4,0},{5,7}}, /* block 2 */
    {{6,0},{7,7}}  /* block 3 */
  }
};

/* block region transfers */
int BS2[XFERS2][3][2] = {
  {{0,0},{1,1},{1,1}}, /* send 2x2 */
  {{4,4},{5,5},{1,1}}, /* send 2x2 */
  {{2,2},{3,3},{1,1}}, /* send 2x2 */
  {{6,6},{7,7},{1,1}}, /* send 2x2 */
  {{1,1},{4,1},{1,1}}, /* send 4x1 */
  {{1,1},{4,1},{1,1}}, /* send 4x1 */
  {{2,2},{3,3},{1,1}}, /* send 2x2 */
  {{2,2},{2,5},{1,1}}, /* send 1x4 */
  {{0,0},{3,3},{2,2}}, /* send 4x4/2 */
  {{0,0},{3,3},{2,2}}, /* send 4x4/2 */
  {{3,3},{4,5},{1,1}}, /* send 2x3 */
  {{3,3},{5,4},{1,1}}, /* send 3x2 */
};

int BR2[XFERS2][3][2] = {
  {{2,2},{3,3},{1,1}}, /* recv 2x2 */
  {{6,6},{7,7},{1,1}}, /* recv 2x2 */
  {{0,0},{1,1},{1,1}}, /* recv 2x2 */
  {{4,4},{5,5},{1,1}}, /* recv 2x2 */
  {{3,2},{6,2},{1,1}}, /* recv 4x1 */
  {{6,3},{6,6},{1,1}}, /* recv 1x4 */
  {{0,4},{3,4},{1,1}}, /* recv 4x1 */
  {{0,0},{1,1},{1,1}}, /* recv 2x2 */
  {{4,4},{7,7},{2,2}}, /* recv 4x4/2 */
  {{2,2},{3,3},{1,1}}, /* recv 2x2 */
  {{4,4},{6,5},{1,1}}, /* recv 3x2 */
  {{0,0},{0,5},{1,1}}  /* recv 1x6 */
};

int BD3[DESCS3][TASKS][2][3] = {
  {
    /* decomposition 0 */
    {{0,0,0},{3,3,7}}, /* block 0 */
    {{0,4,0},{3,7,7}}, /* block 1 */
    {{4,0,0},{7,3,7}}, /* block 2 */
    {{4,4,0},{7,7,7}}, /* block 3 */
  },
  {
    {{0,0,0},{2,3,7}}, /* block 0 */
    {{0,4,0},{4,7,7}}, /* block 1 */
    {{3,0,0},{7,3,7}}, /* block 2 */
    {{5,4,0},{7,7,7}}  /* block 3 */
  }
};

int BS3[XFERS3][3][3] = {
  {{0,0,0},{1,1,1},{1,1,1}},
  {{4,4,4},{5,5,5},{1,1,1}},
  {{2,2,2},{5,5,5},{2,2,2}},
  {{3,3,3},{6,6,6},{2,2,2}}
};

int BR3[XFERS3][3][3] = {
  {{2,2,2},{3,3,3},{1,1,1}},
  {{6,6,6},{7,7,7},{1,1,1}},
  {{0,0,0},{3,3,3},{2,2,2}},
  {{4,4,4},{7,7,7},{2,2,2}}
};
