#include "ctest.h"
#include "pvm_utils.h"
#include "general_bsparti.h"
#include "simple_ttable.h"
#include <stdlib.h>
#include <pvm3.h>

#include "cblocks.h"
#include "ctables.h"

/* xfer region sizes */
int XS2[XFERS2] = {4,4,4,4,4,4,4,4,4,4,6,6}; 
int XS3[XFERS3] = {8,8,8,8};

extern char* groupname;
extern char* othername;
extern char* thirdname;

extern IC_Program* this;
extern IC_Program* other;
extern IC_Program* third;

extern IC_Desc* desc;

int common_startup(int argc, char* argv[], int* r, int* t) {
  int p;

  /* process args */
  if (argc > 1) {
    if ((*t = atoi(argv[1])) < 0) {
      fprintf(stderr, "invalid value for test\n");
      return 0;
    }
  } else {
    *t = 0;
  }
  
  /* initialize pvm */
  if ((p = pvm_startup(argv, TASKS)) < TASKS) {
    fprintf(stderr, "need %d tasks\n", TASKS);
    return 0;
  }
  if ((*r = pvm_joingroup(groupname+1)) < 0) {
    pvm_perror("joingroup");
    return 0;
  }
  if (pvm_barrier(groupname+1, p) < 0) {
    pvm_perror("barrier");
    return 0;
  } 
  
  /* initialize ic */
  if ((this = IC_Init(groupname, TASKS, *r)) == 0) {
    fprintf(stderr, "error initializing program\n");
    return 0;
  }
  if ((other = IC_Wait(othername, TASKS)) == 0) {
    fprintf(stderr, "error initializing other program\n");
    return 0;
  }
  if (IC_Sync(this, other) < 0) {
    fprintf(stderr, "error synchronizing programs\n");
    return 0;
  }
  if ((third = IC_Wait(thirdname, TASKS)) == 0) {
    fprintf(stderr, "error initializing third program\n");
    return 0;
  }
  if (IC_Sync(this, third) < 0) {
    fprintf(stderr, "error synchronizing programs\n");
    return 0;
  }  
  
  return 1;
}

int verify2Drecv4(IC_Program* sender, IC_Desc* desc, int* A, int* size, int rank, int xs[4],
		   int bd[TASKS][2][2], int bs[4][3][2], int br[4][3][2], 
		   int tt[TASKS][2][SIZE], int ts[4][8], int tr[4][8]) {
  int i, j, k, l, m, n, o, p, quit, cnt = 4;
  
  switch(desc->type) {
    
  case IC_BDECOMP:
    /* step through the global array */
    for (i = 0; i < DIMY; ++i) {
      for (j = 0; j < DIMX; ++j) {
	
	/* see if we're inside the local region (k & l are local coords) */
	if ((i >= bd[rank][LO][0] && i <= bd[rank][UP][0]) && 
	    (j >= bd[rank][LO][1] && j <= bd[rank][UP][1])) {
	  k = i - bd[rank][LO][0];
	  l = j - bd[rank][LO][1];
	  
	  for (p = 0; p < cnt; ++p) {
	    /* see if we're inside one of the destination regions (m is the linearization coord) */
	    if ((i >= br[p][LO][0] && i <= br[p][UP][0]) && 
		(j >= br[p][LO][1] && j <= br[p][UP][1]) &&
		((i - br[p][LO][0]) % br[p][ST][0] == 0) &&
		((j - br[p][LO][1]) % br[p][ST][1] == 0)) {
	      /* COL MAJOR LINEARIZATION */
	      o = (br[p][UP][0] - br[p][LO][0] + 1)/br[p][ST][0];
	      m = o*((j - br[p][LO][1])/br[p][ST][1]) 
		+ ((i - br[p][LO][0])/br[p][ST][0]);
	      
	      /* see what descriptor type the other program uses */
	      if (sender == other) {
		o = (bs[p][UP][0] - bs[p][LO][0] + 1)/bs[p][ST][0];
		n = ((m/o + bs[p][LO][1])*bs[p][ST][1]) 
		  + 10*((m%o + bs[p][LO][0])*bs[p][ST][0]);
	      } else if (sender == third) {
		n = ts[p][m];
	      } else {
		return 0;
	      }
	      break;

	    } else {
	      m = -1;
	      n = 10*i + j; /* default value */
	    }
	  }

	  if (*(A+k*size[1]+l) != n) {
	    printf("got=%d, wanted=%d\n", *(A+k*size[1]+l), n);
	    return 0;
	  }
	}
      }
    }
    break;
    
  case IC_TTABLE:
    /* step through the global array */
    for (i = 0; i < TASKS; ++i) {
      for (j = 0; j < SIZE; ++j) {
	
	/* see if we're responsible for this index */
	if (rank == tt[i][TSK][j]) {
	  
	  for (p = 0; p < cnt; ++p) {
	    for (k = 0; k < xs[p]; ++k) {
	      
	      /* see if we're considering a destination index */
	      if (j + i*SIZE == tr[p][k]) {
		
		/* see what descriptor type the other program uses */
		if (sender == other) {
		  l = ts[p][k];
		  goto endloop;
		} else if (sender == third) {
		  o = (bs[p][UP][0] - bs[p][LO][0] + 1)/bs[p][ST][0];
		  l = ((k/o + bs[p][LO][1])*bs[p][ST][1]) + 
		    10*((k%o + bs[p][LO][0])*bs[p][ST][0]);
		  goto endloop;
		} else {
		  return 0;
		}
		
	      } else {
		l = j + i*SIZE; /* default value */
	      }
	    }
	  }
	endloop:
	  if (*(A+tt[i][OFF][j]) != l) {
	    printf("got=%d, wanted=%d\n", *(A+tt[i][OFF][j]), l);
	    return 0;
	  }
	}
      }
    }
    break;
    
  default:
    fprintf(stderr, "invalid descriptor type\n");
    return 0;
  }
  
  return 1;
}

int verify2Drecv6(IC_Program* sender, IC_Desc* desc, int* A, int* size, int rank, int xs[6],
		   int bd[TASKS][2][2], int bs[6][3][2], int br[6][3][2], 
		   int tt[TASKS][2][SIZE], int ts[6][8], int tr[6][8]) {
  int i, j, k, l, m, n, o, p, quit, cnt = 6;
  
  switch(desc->type) {
    
  case IC_BDECOMP:
    /* step through the global array */
    for (i = 0; i < DIMY; ++i) {
      for (j = 0; j < DIMX; ++j) {
	
	/* see if we're inside the local region (k & l are local coords) */
	if ((i >= bd[rank][LO][0] && i <= bd[rank][UP][0]) && 
	    (j >= bd[rank][LO][1] && j <= bd[rank][UP][1])) {
	  k = i - bd[rank][LO][0];
	  l = j - bd[rank][LO][1];
	  
	  for (p = 0; p < cnt; ++p) {
	    /* see if we're inside one of the destination regions (m is the linearization coord) */
	    if ((i >= br[p][LO][0] && i <= br[p][UP][0]) && 
		(j >= br[p][LO][1] && j <= br[p][UP][1]) &&
		((i - br[p][LO][0]) % br[p][ST][0] == 0) &&
		((j - br[p][LO][1]) % br[p][ST][1] == 0)) {
	      /* COL MAJOR LINEARIZATION */
	      o = (br[p][UP][0] - br[p][LO][0] + 1)/br[p][ST][0];
	      m = o*((j - br[p][LO][1])/br[p][ST][1]) 
		+ ((i - br[p][LO][0])/br[p][ST][0]);
	      
	      /* see what descriptor type the other program uses */
	      if (sender == other) {
		o = (bs[p][UP][0] - bs[p][LO][0] + 1)/bs[p][ST][0];
		n = ((m/o + bs[p][LO][1])*bs[p][ST][1]) 
		  + 10*((m%o + bs[p][LO][0])*bs[p][ST][0]);
	      } else if (sender == third) {
		n = ts[p][m];
	      } else {
		return 0;
	      }
	      break;

	    } else {
	      m = -1;
	      n = 10*i + j; /* default value */
	    }
	  }

	  if (*(A+k*size[1]+l) != n) {
	    printf("got=%d, wanted=%d\n", *(A+k*size[1]+l), n);
	    return 0;
	  }
	}
      }
    }
    break;
    
  case IC_TTABLE:
    /* step through the global array */
    for (i = 0; i < TASKS; ++i) {
      for (j = 0; j < SIZE; ++j) {
	
	/* see if we're responsible for this index */
	if (rank == tt[i][TSK][j]) {
	  
	  for (p = 0; p < cnt; ++p) {
	    for (k = 0; k < xs[p]; ++k) {
	      
	      /* see if we're considering a destination index */
	      if (j + i*SIZE == tr[p][k]) {
		
		/* see what descriptor type the other program uses */
		if (sender == other) {
		  l = ts[p][k];
		  goto endloop;
		} else if (sender == third) {
		  o = (bs[p][UP][0] - bs[p][LO][0] + 1)/bs[p][ST][0];
		  l = ((k/o + bs[p][LO][1])*bs[p][ST][1]) + 
		    10*((k%o + bs[p][LO][0])*bs[p][ST][0]);
		  goto endloop;
		} else {
		  return 0;
		}
		
	      } else {
		l = j + i*SIZE; /* default value */
	      }
	    }
	  }
	endloop:
	  if (*(A+tt[i][OFF][j]) != l) {
	    printf("got=%d, wanted=%d\n", *(A+tt[i][OFF][j]), l);
	    return 0;
	  }
	}
      }
    }
    break;
    
  default:
    fprintf(stderr, "invalid descriptor type\n");
    return 0;
  }
  
  return 1;
}

int verify3Drecv8(IC_Program* sender, IC_Desc* desc, int* A, int* size, int rank, int xs[8],
		   int bd[TASKS][2][3], int bs[8][3][3], int br[8][3][3], 
		   int tt[TASKS][2][SIZE], int ts[8][8], int tr[8][8]) {
  int i, j, k, l, m, n, o, p, q, r, s, quit, cnt = 8;
  
  switch(desc->type) {
    
  case IC_BDECOMP:
    /* step through the global array */
    for (i = 0; i < DIMY; ++i) {
      for (j = 0; j < DIMX; ++j) {
	for (k = 0; k < DIMZ; ++k) {
	  
	  /* see if we're inside the local region (k, l, & m are local coords) */
	  if ((i >= bd[rank][LO][0] && i <= bd[rank][UP][0]) && 
	      (j >= bd[rank][LO][1] && j <= bd[rank][UP][1]) &&
	      (k >= bd[rank][LO][2] && k <= bd[rank][UP][2])) {
	    l = i - bd[rank][LO][0];
	    m = j - bd[rank][LO][1];
	    n = k - bd[rank][LO][2];
	    
	    for (s = 0; s < cnt; ++s) {
	      /* see if we're inside one of the destination regions (q is the linearization coord) */
	      if ((i >= br[s][LO][0] && i <= br[s][UP][0]) && 
		  (j >= br[s][LO][1] && j <= br[s][UP][1]) &&
		  (k >= br[s][LO][2] && k <= br[s][UP][2]) &&
		  ((i - br[s][LO][0]) % br[s][ST][0] == 0) &&
		  ((j - br[s][LO][1]) % br[s][ST][1] == 0) &&
		  ((k - br[s][LO][2]) % br[s][ST][2] == 0)) {
		/* COL MAJOR LINEARIZATION */
		o = (br[s][UP][0] - br[s][LO][0] + 1)/br[s][ST][0];
		p = (br[s][UP][1] - br[s][LO][1] + 1)/br[s][ST][1];
		q = o*p*((k - br[s][LO][2])/br[s][ST][2])
		  + o*((j - br[s][LO][1])/br[s][ST][1]) 
		  + ((i - br[s][LO][0])/br[s][ST][0]);
		
		/* see what descriptor type the other program uses */
		if (sender == other) {
		  o = (bs[s][UP][0] - bs[s][LO][0] + 1)/bs[s][ST][0];
		  p = (bs[s][UP][1] - bs[s][LO][1] + 1)/bs[s][ST][1];
		  r = ((q/(o*p) + bs[s][LO][2])*bs[s][ST][2])
		    + 10*(((q%(o*p))/o + bs[s][LO][1])*bs[s][ST][1])
		    + 100*(((q%(o*p))%o + bs[s][LO][0])*bs[s][ST][0]);
		} else if (sender == third) {
		  r = ts[s][q];
		} else {
		  return 0;
		}
		break;
		
	      } else {
		q = -1;
		r = 100*i + 10*j + k; /* default value */
	      }
	    }
	    
	    if (*(A+l*size[1]*size[2]+m*size[2]+n) != r) {
	      printf("got=%d, wanted=%d\n", *(A+l*size[1]*size[2]+m*size[2]+n), r);
	      return 0;
	    }
	  }
	}
      }
    }
    break;
    
  case IC_TTABLE:
    /* step through the global array */
    for (i = 0; i < TASKS; ++i) {
      for (j = 0; j < SIZE; ++j) {
	
	/* see if we're responsible for this index */
	if (rank == tt[i][TSK][j]) {
	  
	  for (s = 0; s < cnt; ++s) {
	    for (k = 0; k < xs[s]; ++k) {
	      
	      /* see if we're considering a destination index */
	      if (j + i*SIZE == tr[s][k]) {
		
		/* see what descriptor type the other program uses */
		if (sender == other) {
		  l = ts[s][k];
		  goto endloop;
		} else if (sender == third) {
		  o = (bs[s][UP][0] - bs[s][LO][0] + 1)/bs[s][ST][0];
		  p = (bs[s][UP][1] - bs[s][LO][1] + 1)/bs[s][ST][1];
		  l = ((k/(o*p) + bs[s][LO][2])*bs[s][ST][2])
		    + 10*(((k%(o*p))/o + bs[s][LO][1])*bs[s][ST][1])
		    + 100*(((k%(o*p))%o + bs[s][LO][0])*bs[s][ST][0]);
		  goto endloop;
		} else {
		  return 0;
		}
		
	      } else {
		l = j + i*SIZE; /* default value */
	      }
	    }
	  }
	endloop:
	  if (*(A+tt[i][OFF][j]) != l) {
	    printf("got=%d, wanted=%d\n", *(A+tt[i][OFF][j]), l);
	    return 0;
	  }
	}
      }
    }
    break;
    
  default:
    fprintf(stderr, "invalid descriptor type\n");
    return 0;
  }
  
  return 1;
}

int verify_recv(IC_Program* sender, IC_Desc* desc, int* A, int* size, int rank, int d, int r, int cnt, int dim) {
  switch (dim) {
  case 2:
    switch (cnt) {
    case 4:
      return verify2Drecv4(sender, desc, A, size, rank, &XS2[r],
			   BD2[d], &BS2[r], &BR2[r], TT[d], &TS[r], &TR[r]);
    case 6:
      return verify2Drecv6(sender, desc, A, size, rank, &XS2[r],
			   BD2[d], &BS2[r], &BR2[r], TT[d], &TS[r], &TR[r]);
    }
  case 3:
    switch (cnt) {
    case 8:
      return verify3Drecv8(sender, desc, A, size, rank, &XS3[r],
			   BD3[d], &BS3[r], &BR3[r], TT[d], &TS[r], &TR[r]);
    }
  }
}

void fprint_array(FILE* fp, char type, void* A, int rank, int* size, int off, int dim) {
  int i, j = 1;
  
  if (!A)
    return;
  
  for (i = dim+1; i < rank; ++i)
    j *= size[i];
  
  for (i = 0; i < size[dim]; ++i) {
    if (dim == rank-1)
      switch (type) {
      case 'c':
	fprintf(fp, "%3hd ", *((char*)A+off+i));
	break;
      case 'i':
	fprintf(fp, "%3d ", *((int*)A+off+i));
	break;
      case 'f':
	fprintf(fp, "%3.2f ", *((float*)A+off+i));
	break;
      case 'd':
	fprintf(fp, "%3.2lf ", *((double*)A+off+i));
	break;
      }
    else
      fprint_array(fp, type, A, rank, size, off+j*i, dim+1);
  }
  
  fprintf(fp, "\n");
}
