#include "ctest_block.h"
#include "ctest.h"
#include <stdlib.h>

extern char* groupname;
extern IC_Program* this;

extern int BD2[DESCS2][TASKS][2][2];
extern int BS2[XFERS2][3][2];
extern int BR2[XFERS2][3][2];

extern int XS2[XFERS2];

extern int BD3[DESCS3][TASKS][2][3];
extern int BS3[XFERS3][3][3];
extern int BR3[XFERS3][3][3];

extern int XS3[XFERS3];

IC_Desc* create_desc(int d, int rank, int* size, int** A, int dims) {  
  IC_Desc* desc = 0;
  int tasks[TASKS];
  int i, s = 1;

  /* block-to-task assignment */
  for (i = 0; i < TASKS; ++i) {
    tasks[i] = i;
  }
  
  switch (dims) {
  case 2:
    if ((desc = IC_Create_bdecomp_desc(2, &BD2[d][0][0][0], tasks, TASKS)) == 0) {
      fprintf(stderr, "error creating descriptor\n");
      return 0;
    }
    break;
  case 3:
    if ((desc = IC_Create_bdecomp_desc(3, &BD3[d][0][0][0], tasks, TASKS)) == 0) {
      fprintf(stderr, "error creating descriptor\n");
      return 0;
    }
    break;
  }
  
  /* debugging */
/*   { */
/*     decomp_Birreg* decomp = desc->spec; */
/*     print_irr(decomp->root); */
/*   } */

  /* allocate local memory */
  for (i = 0; i < dims; ++i) {
    switch (dims) {
    case 2:
      size[i] = (BD2[d][rank][UP][i] - BD2[d][rank][LO][i]) + 1;
      break;
    case 3:
      size[i] = (BD3[d][rank][UP][i] - BD3[d][rank][LO][i]) + 1;
      break;
    }
    s *= size[i];
  }
  *A = (int*)calloc(s, sizeof(int));

  return desc;
}

void init2Darray(int* size, int* A, int d, int rank) {
  int i, j;
  
  for (i = 0; i < size[0]; ++i) {
    for (j = 0; j < size[1]; ++j) {
      *(A+i*size[1]+j) 
	= 10*(i+BD2[d][rank][LO][0]) 
	+ 1*(j+BD2[d][rank][LO][1]);
    }
  }
}

void init3Darray(int* size, int* A, int d, int rank) {
  int i, j, k;
  
  for (i = 0; i < size[0]; ++i) {
    for (j = 0; j < size[1]; ++j) {
      for (k = 0; k < size[2]; ++k) {
	*(A+i*size[1]*size[2]+j*size[2]+k) 
	  = 100*(i+BD3[d][rank][LO][0]) 
	  + 10*(j+BD3[d][rank][LO][1])
	  + 1*(k+BD3[d][rank][LO][2]);
      }
    }
  }
}

void init_array(int* size, int* A, int d, int rank, int dims) {
  switch (dims) {
  case 2:
    init2Darray(size, A, d, rank);
    break;
  case 3:
    init3Darray(size, A, d, rank);
    break;
  }
}

int send_region(IC_Program* receiver, IC_Desc* desc, int r, int* A, int cnt, int dims) {
  IC_Region* regions[XFERS2];
  IC_Sched* sched;
  int i;

  for (i = 0; i < cnt; ++i) {
    switch (dims) {
    case 2:
      regions[i] = IC_Create_block_region(2, BS2[r+i][LO], BS2[r+i][UP], BS2[r+i][ST]);
      break;
    case 3:
      regions[i] = IC_Create_block_region(3, BS3[r+i][LO], BS3[r+i][UP], BS3[r+i][ST]);
      break;
    }
    if (!regions[i]) {
      fprintf(stderr, "error creating send region\n");
      return 0;
    }

/*     Print_Region(regions[i]); */
  }
  
  if ((sched = IC_Compute_schedule(this, receiver, desc, regions, cnt)) == 0) {
    IC_Print_error("error creating schedule");
    return 0;
  }
  
  if (IC_Send_int(receiver, sched, A, 666) < 0) {
    fprintf(stderr, "error on send\n");
    return 0;
  }
  
  if (IC_Sync(this, receiver) < 0) {
    fprintf(stderr, "error synchronizing programs\n");
    return 0;
  }  
  
  IC_Free_sched(sched);
  for (i = 0; i < cnt; ++i) {
    IC_Free_region(regions[i]);
  }

  return 1;
}

int recv_region(IC_Program* sender, IC_Desc* desc, int r, int* A, int cnt, int dims) {
  IC_Region* regions[XFERS2];
  IC_Sched* sched;
  int i;
  
  for (i = 0; i < cnt; ++i) {
    switch (dims) {
    case 2:
      regions[i] = IC_Create_block_region(2, BR2[r+i][LO], BR2[r+i][UP], BR2[r+i][ST]);
      break;
    case 3:
      regions[i] = IC_Create_block_region(3, BR3[r+i][LO], BR3[r+i][UP], BR3[r+i][ST]);
      break;
    }
    if (!regions[i]) {
      fprintf(stderr, "error creating recv region\n");
      return 0;
    }

/*     Print_Region(regions[i]); */
  }
  
  if ((sched = IC_Compute_schedule(this, sender, desc, regions, cnt)) == 0) {
    fprintf(stderr, "error creating schedule\n");
    return 0;
  }
  
  if (IC_Recv_int(sender, sched, A, 666) < 0) {
    fprintf(stderr, "error on send\n");
    return 0;
  }
  
  if (IC_Sync(this, sender) < 0) {
    fprintf(stderr, "error synchronizing programs\n");
    return 0;
  }  

  IC_Free_sched(sched);
  for (i = 0; i < cnt; ++i) {
    IC_Free_region(regions[i]);
  }
  
  return 1;
}

int sendrecv(int rank, int test, IC_Program* prog, int bcnt, int ndim, int descs, int xfers) {
  IC_Desc* desc = 0;
  int decomp, region;
  int* A, size[MAXDIM];
  int sts;
  
  decomp = 0;
  while (decomp < descs) {
    desc = create_desc(decomp, rank, size, &A, ndim);
    if (!desc)
      return 0;
    
    region = 0;
    while (region < xfers - bcnt) {      
      
      /* send */
      init_array(size, A, decomp, rank, ndim);
      if (!send_region(prog, desc, region, A, bcnt, ndim))
	return 0;
      
      ++region;
      
      /* recv */
      init_array(size, A, decomp, rank, ndim);
      if (!recv_region(prog, desc, region, A, bcnt, ndim))
	return 0;
      sts = verify_recv(prog, desc, A, size, rank, decomp, region, bcnt, ndim);
      sts = pvm_allstatus(groupname, sts, decomp*10+region);
      if (rank == 0) {
	if (!sts)
	  printf("test %d.%d.%d failed\n", test, decomp+1, region+1);
	else
	  printf("test %d.%d.%d succeeded\n", test, decomp+1, region+1);
      }
      if (!sts)
	fprint_array(stdout, 'i', A, ndim, size, 0, 0);
      
      ++region;
    }
    
    free(A);    
    IC_Free_desc(desc);
    
    decomp += 2;
  }  
  
  return 1;
}

int recvsend(int rank, int test, IC_Program* prog, int bcnt, int ndim, int descs, int xfers) {
  IC_Desc* desc = 0;
  int decomp, region;
  int* A, size[MAXDIM];
  int sts;

  decomp = 1;
  while (decomp < descs) {
    desc = create_desc(decomp, rank, size, &A, ndim);
    if (!desc)
      return 0;
    
    region = 0;
    while (region < xfers - bcnt) {

      /* recv */
      init_array(size, A, decomp, rank, ndim);
      if (!recv_region(prog, desc, region, A, bcnt, ndim))
	return 0;
      sts = verify_recv(prog, desc, A, size, rank, decomp, region, bcnt, ndim);
      sts = pvm_allstatus(groupname, sts, decomp*10+region);
      if (rank == 0) {
	if (!sts)
	  printf("test %d.%d.%d failed\n", test, decomp+1, region+1);
	else
	  printf("test %d.%d.%d succeeded\n", test, decomp+1, region+1);
      }
      if (!sts)
	fprint_array(stdout, 'i', A, ndim, size, 0, 0);

      ++region;
      
      /* send */
      init_array(size, A, decomp, rank, ndim);
      if (!send_region(prog, desc, region, A, bcnt, ndim))
	return 0;

      ++region;
    }
    
    free(A);
    IC_Free_desc(desc);    

    decomp += 2;
  }
  
  return 1;
}
