#include "chaos_ctest.h"
#include <ttable.h>
#include <stdio.h>
#include <stdlib.h>
#include <pvm3.h>

int main(int argc, char* argv[]) {
  char* groupname = "chaos_ctest_east";
  char* othername = "chaos_ctest_west";

  IC_Program* this;
  IC_Program* other;
  int i, p, r, s;

  IC_Desc* desc;
  int size = SIZE;
  int* A;
  int local_size;

  IC_Region* regions[4];
  IC_Sched* sched;
  
  /* process command line args */
  if (argc < 3) {
    fprintf(stderr, "usage: %s tasks other_tasks\n", argv[0]);
    return 1;
  }
  
  if ((r = atoi(argv[1])) < 1) {
    fprintf(stderr, "invalid value for tasks\n");
    return 1;
  }
  if ((s = atoi(argv[2])) < 1) {
    fprintf(stderr, "invalid value for other_tasks\n");
    return 1;
  }

  /* initialize PVM */
  if ((p = pvm_startup(argv, r)) < r) {
    fprintf(stderr, "need %d tasks\n", r);
    return 1;
  }
  
  /* initialize CHAOS */
  parti_pvm_setup(p, 100, groupname);
  PARTI_setup();
  r = parti_pvm_mynode();
  printf("INSTANCE=%d\n", r);

  /* initialize IC */
  if ((this = IC_Init(groupname, p, r)) == 0) {
    fprintf(stderr, "error initializing program\n");
    return 1;
  }

  if ((other = IC_Wait(othername, s)) == 0) {
    fprintf(stderr, "error initializing other program\n");
    return 1;
  }

  if (IC_Sync(this, other) < 0) {
    fprintf(stderr, "error synchronizing programs\n");
    return 1;
  }

  /* create the CHAOS descriptor */
  A = create_ttable(&desc, p, r, &local_size);  
  for (i = 0; i < local_size; ++i)
    A[i] = 0;
  
  /* set up regions */
  regions[0] = IC_Create_enum_region(rr1, rs1);
  regions[1] = IC_Create_enum_region(rr2, rs2);
  regions[2] = IC_Create_enum_region(rr3, rs3);
  regions[3] = IC_Create_enum_region(rr4, rs4);

  /* recv regions */
  if ((sched = IC_Compute_schedule(this, other, desc, regions, 1)) == 0) {
    fprintf(stderr, "error create schedule\n");
    return 1;
  }

  IC_Recv_int(other, sched, A, 666);
  IC_Sync(this, other);
  print_array(stdout, A, local_size);

  IC_Free_sched(sched);

  IC_Free_region(regions[3]);
  IC_Free_region(regions[2]);
  IC_Free_region(regions[1]);
  IC_Free_region(regions[0]);
  
  free(A);
  IC_Free_desc(desc);

  /* cleanup */
  IC_Free_program(other);
  IC_Quit(this);

  pvm_barrier(groupname, p);
  pvm_exit();  
  return 0;
}
