#include "mbp_ctest.h"
#include <bsparti.h>
#include <stdio.h>
#include <stdlib.h>
#include <pvm3.h>

int main(int argc, char* argv[]) {
  char* groupname = "mbp_ctest_west";
  char* othername = "mbp_ctest_east";
  
  IC_Program* self;
  IC_Program* other;
  int p, r, s;

  IC_Desc* desc;
  int rank = RANK;
  int size[RANK] = {DIMX, DIMY};
  int* A;
  int local_sizes[RANK];

  IC_Region* regions[4];
  IC_Sched* sched;

  r = s = 4;

  /* initialize PVM */
  if ((p = pvm_startup(argv, r)) < r) {
    fprintf(stderr, "need %d tasks\n", r);
    return 1;
  }

  /* initialize MBP */
#if MBP_VERSION > 1
  r = pvm_joingroup(groupname+1);
  parti_setup(groupname+1);
  pvm_barrier(groupname+1, p);
#else
  parti_pvm_setup(p, 100, groupname);
  PARTI_setup();
  r = parti_pvm_mynode();
#endif

  /* initialize IC */
  if ((self = IC_Init(groupname, p, r)) == 0) {
    IC_Print_error("error initializing program");
    return 1;
  }

  if ((other = IC_Wait(othername, s)) == 0) {
    fprintf(stderr, "error initializing other program\n");
    return 1;
  }

  if (IC_Sync(self, other) < 0) {
    fprintf(stderr, "error synchronizing programs\n");
    return 1;
  }

  /* create the MBP descriptor */
  A = create_bdecomp(&desc, p, r, local_sizes);
  print_array(stdout, A, local_sizes);
  
  regions[0] = IC_Create_block_region(RANK, sl1, su1, ss1);
  regions[1] = IC_Create_block_region(RANK, sl2, su2, ss2);
  regions[2] = IC_Create_block_region(RANK, sl3, su3, ss3);
  regions[3] = IC_Create_block_region(RANK, sl4, su4, ss4);

  if ((sched = IC_Compute_schedule(self, other, desc, regions, 4)) == 0) {
    fprintf(stderr, "error creating schedule\n");
    return 1;
  }

  IC_Send_int(other, sched, A, 666);
  IC_Sync(self, other);

  IC_Free_sched(sched);

  IC_Free_region(regions[3]);
  IC_Free_region(regions[2]);
  IC_Free_region(regions[1]);
  IC_Free_region(regions[0]);
  
  free(A);
  IC_Free_desc(desc);

  /* cleanup */
  IC_Free_program(other);
  IC_Quit(self);
  
#if MBP_VERSION > 1
  pvm_barrier(groupname+1, p);
  parti_cleanup();
#else
/*   PARTI_cleanup(); */
#endif
  pvm_exit();  
  return 0;
}
